/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fuzzymatch;

import java.util.ArrayList;
import org.pentaho.di.core.util.Utils;

public class LetterPairSimilarity {
    private static String[] letterPairs(String str) {
        int numPairs = str.length() - 1;
        if (str.length() == 0) {
            numPairs = 0;
        }
        String[] pairs = new String[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            pairs[i] = str.substring(i, i + 2);
        }
        return pairs;
    }

    private static ArrayList<String> wordLetterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        String[] words = str.split("\\s");
        for (int w = 0; w < words.length; ++w) {
            String[] pairsInWord = LetterPairSimilarity.letterPairs(words[w]);
            for (int p = 0; p < pairsInWord.length; ++p) {
                allPairs.add(pairsInWord[p]);
            }
        }
        return allPairs;
    }

    public static double getSimiliarity(String str1, String str2) {
        if (Utils.isEmpty((CharSequence)str1) && Utils.isEmpty((CharSequence)str2)) {
            return new Double(1.0);
        }
        ArrayList<String> pairs1 = LetterPairSimilarity.wordLetterPairs(str1.toUpperCase());
        ArrayList<String> pairs2 = LetterPairSimilarity.wordLetterPairs(str2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (int i = 0; i < pairs1.size(); ++i) {
            String pair1 = pairs1.get(i);
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        return 2.0 * (double)intersection / (double)union;
    }
}

