/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilesrowscount;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCount;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GetFilesRowsCountMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetFilesRowsCountMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    public static final String DEFAULT_ROWSCOUNT_FIELDNAME = "rowscount";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilesCount;
    private String filesCountFieldName;
    private String rowsCountFieldName;
    private String RowSeparator_format;
    private String RowSeparator;
    private boolean filefield;
    private boolean isaddresult;
    private String outputFilenameField;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private boolean smartCount;

    public String getRowSeparator() {
        return this.RowSeparator;
    }

    public void setRowSeparator(String RowSeparatorin) {
        this.RowSeparator = RowSeparatorin;
    }

    public String getRowSeparatorFormat() {
        return this.RowSeparator_format;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public void setSmartCount(boolean smartCount) {
        this.smartCount = smartCount;
    }

    @Deprecated
    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean isSmartCount() {
        return this.smartCount;
    }

    @Deprecated
    public String setOutputFilenameField() {
        return this.outputFilenameField;
    }

    public String getOutputFilenameField() {
        return this.outputFilenameField;
    }

    public void setOutputFilenameField(String outputFilenameField) {
        this.outputFilenameField = outputFilenameField;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public void setRowSeparatorFormat(String RowSeparator_formatin) {
        this.RowSeparator_format = RowSeparator_formatin;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean includeCountFiles() {
        return this.includeFilesCount;
    }

    public void setIncludeCountFiles(boolean includeFilesCount) {
        this.includeFilesCount = includeFilesCount;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public String getFilesCountFieldName() {
        return this.filesCountFieldName;
    }

    public String getRowsCountFieldName() {
        return this.rowsCountFieldName;
    }

    public void setFilesCountFieldName(String filesCountFieldName) {
        this.filesCountFieldName = filesCountFieldName;
    }

    public void setRowsCountFieldName(String rowsCountFieldName) {
        this.rowsCountFieldName = rowsCountFieldName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        GetFilesRowsCountMeta retval = (GetFilesRowsCountMeta)super.clone();
        int nrFiles = this.fileName.length;
        retval.allocate(nrFiles);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"files_count", (boolean)this.includeFilesCount));
        retval.append("    ").append(XMLHandler.addTagValue((String)"files_count_fieldname", (String)this.filesCountFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rows_count_fieldname", (String)this.rowsCountFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowseparator_format", (String)this.RowSeparator_format));
        retval.append("    ").append(XMLHandler.addTagValue((String)"row_separator", (String)this.RowSeparator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_Field", (String)this.outputFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"smartCount", (boolean)this.smartCount));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private String scrubOldRowSeparator(String original) {
        if (original != null) {
            if (original.equalsIgnoreCase("CR")) {
                return "LINEFEED";
            }
            if (original.equalsIgnoreCase("LF")) {
                return "CARRIAGERETURN";
            }
        }
        return original;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.includeFilesCount = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"files_count"));
            this.filesCountFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"files_count_fieldname");
            this.rowsCountFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rows_count_fieldname");
            this.RowSeparator_format = this.scrubOldRowSeparator(XMLHandler.getTagValue((Node)stepnode, (String)"rowseparator_format"));
            this.RowSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"row_separator");
            this.smartCount = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"smartCount"));
            String addresult = XMLHandler.getTagValue((Node)stepnode, (String)"isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : YES.equalsIgnoreCase(addresult);
            this.filefield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.outputFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_Field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrFiles);
            for (int i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        this.smartCount = false;
        this.outputFilenameField = "";
        this.filefield = false;
        this.isaddresult = true;
        this.includeFilesCount = false;
        this.filesCountFieldName = "";
        this.rowsCountFieldName = DEFAULT_ROWSCOUNT_FIELDNAME;
        this.RowSeparator_format = "CR";
        this.RowSeparator = "";
        int nrFiles = 0;
        this.allocate(nrFiles);
        for (int i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInteger v = new ValueMetaInteger(space.environmentSubstitute(this.rowsCountFieldName));
        v.setLength(10, 0);
        v.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)v);
        if (this.includeFilesCount) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.filesCountFieldName));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.includeFilesCount = rep.getStepAttributeBoolean(id_step, "files_count");
            this.filesCountFieldName = rep.getStepAttributeString(id_step, "files_count_fieldname");
            this.rowsCountFieldName = rep.getStepAttributeString(id_step, "rows_count_fieldname");
            this.RowSeparator_format = this.scrubOldRowSeparator(rep.getStepAttributeString(id_step, "rowseparator_format"));
            this.RowSeparator = rep.getStepAttributeString(id_step, "row_separator");
            this.smartCount = rep.getStepAttributeBoolean(id_step, "smartCount");
            String addresult = rep.getStepAttributeString(id_step, "isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : rep.getStepAttributeBoolean(id_step, "isaddresult");
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.outputFilenameField = rep.getStepAttributeString(id_step, "filename_Field");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            this.allocate(nrFiles);
            for (int i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "files_count", this.includeFilesCount);
            rep.saveStepAttribute(id_transformation, id_step, "files_count_fieldname", this.filesCountFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rows_count_fieldname", this.rowsCountFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rowseparator_format", this.RowSeparator_format);
            rep.saveStepAttribute(id_transformation, id_step, "row_separator", this.RowSeparator);
            rep.saveStepAttribute(id_transformation, id_step, "isaddresult", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "smartCount", this.smartCount);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "filename_Field", this.outputFilenameField);
            for (int i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.RowSeparator_format.equals("CUSTOM") && this.RowSeparator == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoSeparator", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.SeparatorOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new GetFilesRowsCount(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetFilesRowsCountData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

