/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTP;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class HTTPMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = HTTPMeta.class;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_CLOSE_CONNECTIONS_TIME = -1;
    private String socketTimeout;
    private String connectionTimeout;
    private String closeIdleConnectionsTime;
    private String url;
    private String[] argumentField;
    private String[] argumentParameter;
    private String fieldName;
    private String encoding;
    private boolean urlInField;
    private String urlField;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private String resultCodeFieldName;
    private String responseTimeFieldName;
    private String responseHeaderFieldName;
    private String[] headerParameter;
    private String[] headerField;

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCloseIdleConnectionsTime() {
        return this.closeIdleConnectionsTime;
    }

    public void setCloseIdleConnectionsTime(String closeIdleConnectionsTime) {
        this.closeIdleConnectionsTime = closeIdleConnectionsTime;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String[] getArgumentField() {
        return this.argumentField;
    }

    public void setArgumentField(String[] argument) {
        this.argumentField = argument;
    }

    public String[] getHeaderField() {
        return this.headerField;
    }

    public void setHeaderField(String[] headerField) {
        this.headerField = headerField;
    }

    public String[] getArgumentParameter() {
        return this.argumentParameter;
    }

    public void setArgumentParameter(String[] argumentDirection) {
        this.argumentParameter = argumentDirection;
    }

    public String[] getHeaderParameter() {
        return this.headerParameter;
    }

    public void setHeaderParameter(String[] headerParameter) {
        this.headerParameter = headerParameter;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs, int nrqueryparams) {
        this.argumentField = new String[nrargs];
        this.argumentParameter = new String[nrargs];
        this.headerField = new String[nrqueryparams];
        this.headerParameter = new String[nrqueryparams];
    }

    @Override
    public Object clone() {
        HTTPMeta retval = (HTTPMeta)super.clone();
        int nrargs = this.argumentField.length;
        int nrheaderparams = this.headerField.length;
        retval.allocate(nrargs, nrheaderparams);
        System.arraycopy(this.argumentField, 0, retval.argumentField, 0, nrargs);
        System.arraycopy(this.argumentParameter, 0, retval.argumentParameter, 0, nrargs);
        System.arraycopy(this.headerField, 0, retval.headerField, 0, nrheaderparams);
        System.arraycopy(this.headerParameter, 0, retval.headerParameter, 0, nrheaderparams);
        return retval;
    }

    @Override
    public void setDefault() {
        int i;
        this.socketTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
        this.closeIdleConnectionsTime = String.valueOf(-1);
        int nrargs = 0;
        int nrquery = 0;
        this.allocate(nrargs, nrquery);
        for (i = 0; i < nrargs; ++i) {
            this.argumentField[i] = "arg" + i;
            this.argumentParameter[i] = "arg";
        }
        for (i = 0; i < nrquery; ++i) {
            this.headerField[i] = "header" + i;
            this.headerParameter[i] = "header";
        }
        this.fieldName = "result";
        this.resultCodeFieldName = "";
        this.responseTimeFieldName = "";
        this.responseHeaderFieldName = "";
        this.encoding = "UTF-8";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String headerFieldName;
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.fieldName)) {
            v = new ValueMetaString(this.fieldName);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)this.resultCodeFieldName)) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.resultCodeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)this.responseTimeFieldName)) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.responseTimeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(headerFieldName = space.environmentSubstitute(this.responseHeaderFieldName)))) {
            ValueMetaString v2 = new ValueMetaString(headerFieldName);
            v2.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v2);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XMLHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"httpLogin", (String)this.httpLogin));
        retval.append("    " + XMLHandler.addTagValue((String)"httpPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword)));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    " + XMLHandler.addTagValue((String)"socketTimeout", (String)this.socketTimeout));
        retval.append("    " + XMLHandler.addTagValue((String)"connectionTimeout", (String)this.connectionTimeout));
        retval.append("    " + XMLHandler.addTagValue((String)"closeIdleConnectionsTime", (String)this.closeIdleConnectionsTime));
        retval.append("    <lookup>").append(Const.CR);
        for (i = 0; i < this.argumentField.length; ++i) {
            retval.append("      <arg>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.argumentField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"parameter", (String)this.argumentParameter[i]));
            retval.append("      </arg>").append(Const.CR);
        }
        for (i = 0; i < this.headerField.length; ++i) {
            retval.append("      <header>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.headerField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"parameter", (String)this.headerParameter[i]));
            retval.append("      </header>" + Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"response_time", (String)this.responseTimeFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"response_header", (String)this.responseHeaderFieldName));
        retval.append("    </result>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            Node anode;
            int i;
            this.url = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"urlInField"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"urlField");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.httpLogin = XMLHandler.getTagValue((Node)stepnode, (String)"httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"httpPassword"));
            this.proxyHost = XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort");
            this.socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socketTimeout");
            this.connectionTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"connectionTimeout");
            this.closeIdleConnectionsTime = XMLHandler.getTagValue((Node)stepnode, (String)"closeIdleConnectionsTime");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrargs = XMLHandler.countNodes((Node)lookup, (String)"arg");
            int nrheaders = XMLHandler.countNodes((Node)lookup, (String)"header");
            this.allocate(nrargs, nrheaders);
            for (i = 0; i < nrargs; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argumentField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.argumentParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            for (i = 0; i < nrheaders; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"header", (int)i);
                this.headerField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.headerParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
            this.resultCodeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"code");
            this.responseTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"response_time");
            this.responseHeaderFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"response_header");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"HTTPMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.url = rep.getStepAttributeString(id_step, "url");
            this.urlInField = rep.getStepAttributeBoolean(id_step, "urlInField");
            this.urlField = rep.getStepAttributeString(id_step, "urlField");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.httpLogin = rep.getStepAttributeString(id_step, "httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "httpPassword"));
            this.proxyHost = rep.getStepAttributeString(id_step, "proxyHost");
            this.proxyPort = rep.getStepAttributeString(id_step, "proxyPort");
            this.socketTimeout = rep.getStepAttributeString(id_step, "socketTimeout");
            this.connectionTimeout = rep.getStepAttributeString(id_step, "connectionTimeout");
            this.closeIdleConnectionsTime = rep.getStepAttributeString(id_step, "closeIdleConnectionsTime");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            int nrheaders = rep.countNrStepAttributes(id_step, "header_name");
            this.allocate(nrargs, nrheaders);
            for (i = 0; i < nrargs; ++i) {
                this.argumentField[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentParameter[i] = rep.getStepAttributeString(id_step, i, "arg_parameter");
            }
            for (i = 0; i < nrheaders; ++i) {
                this.headerField[i] = rep.getStepAttributeString(id_step, i, "header_name");
                this.headerParameter[i] = rep.getStepAttributeString(id_step, i, "header_parameter");
            }
            this.fieldName = rep.getStepAttributeString(id_step, "result_name");
            this.resultCodeFieldName = rep.getStepAttributeString(id_step, "result_code");
            this.responseTimeFieldName = rep.getStepAttributeString(id_step, "response_time");
            this.responseHeaderFieldName = rep.getStepAttributeString(id_step, "response_header");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "url", this.url);
            rep.saveStepAttribute(id_transformation, id_step, "urlInField", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "urlField", this.urlField);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "httpLogin", this.httpLogin);
            rep.saveStepAttribute(id_transformation, id_step, "httpPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword));
            rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.proxyHost);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.proxyPort);
            rep.saveStepAttribute(id_transformation, id_step, "socketTimeout", this.socketTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "connectionTimeout", this.connectionTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "closeIdleConnectionsTime", this.closeIdleConnectionsTime);
            for (i = 0; i < this.argumentField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_name", this.argumentField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_parameter", this.argumentParameter[i]);
            }
            for (i = 0; i < this.headerField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "header_name", this.headerField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "header_parameter", this.headerParameter[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.fieldName);
            rep.saveStepAttribute(id_transformation, id_step, "result_code", this.resultCodeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "response_time", this.responseTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "response_header", this.responseHeaderFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.urlInField ? (Utils.isEmpty((CharSequence)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta)) : (Utils.isEmpty((CharSequence)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPMeta.CheckResult.UrlOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new HTTP(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new HTTPData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public String getResponseTimeFieldName() {
        return this.responseTimeFieldName;
    }

    public void setResponseTimeFieldName(String responseTimeFieldName) {
        this.responseTimeFieldName = responseTimeFieldName;
    }

    public String getResponseHeaderFieldName() {
        return this.responseHeaderFieldName;
    }

    public void setResponseHeaderFieldName(String responseHeaderFieldName) {
        this.responseHeaderFieldName = responseHeaderFieldName;
    }
}

