/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JaninoMetaFunction
implements Cloneable {
    public static final String XML_TAG = "formula";
    private String fieldName;
    private String formula;
    private int valueType;
    private int valueLength;
    private int valuePrecision;
    private String replaceField;

    public JaninoMetaFunction(String fieldName, String formula, int valueType, int valueLength, int valuePrecision, String replaceField) {
        this.fieldName = fieldName;
        this.formula = formula;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.replaceField = replaceField;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JaninoMetaFunction mf = (JaninoMetaFunction)obj;
            return this.getXML().equals(mf.getXML());
        }
        return false;
    }

    public Object clone() {
        try {
            JaninoMetaFunction retval = (JaninoMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldName));
        xml.append(XMLHandler.addTagValue((String)"formula_string", (String)this.formula));
        xml.append(XMLHandler.addTagValue((String)"value_type", (String)ValueMetaFactory.getValueMetaName((int)this.valueType)));
        xml.append(XMLHandler.addTagValue((String)"value_length", (int)this.valueLength));
        xml.append(XMLHandler.addTagValue((String)"value_precision", (int)this.valuePrecision));
        xml.append(XMLHandler.addTagValue((String)"replace_field", (String)this.replaceField));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public JaninoMetaFunction(Node calcnode) {
        this.fieldName = XMLHandler.getTagValue((Node)calcnode, (String)"field_name");
        this.formula = XMLHandler.getTagValue((Node)calcnode, (String)"formula_string");
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_type"));
        this.valueLength = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_length"), (int)-1);
        this.valuePrecision = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_precision"), (int)-1);
        this.replaceField = XMLHandler.getTagValue((Node)calcnode, (String)"replace_field");
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, nr, "field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, nr, "formula_string", this.formula);
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_type", ValueMetaFactory.getValueMetaName((int)this.valueType));
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_length", this.valueLength);
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_precision", this.valuePrecision);
        rep.saveStepAttribute(id_transformation, id_step, nr, "replace_field", this.replaceField);
    }

    public JaninoMetaFunction(Repository rep, ObjectId id_step, int nr) throws KettleException {
        this.fieldName = rep.getStepAttributeString(id_step, nr, "field_name");
        this.formula = rep.getStepAttributeString(id_step, nr, "formula_string");
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, nr, "value_type"));
        this.valueLength = (int)rep.getStepAttributeInteger(id_step, nr, "value_length");
        this.valuePrecision = (int)rep.getStepAttributeInteger(id_step, nr, "value_precision");
        this.replaceField = rep.getStepAttributeString(id_step, nr, "replace_field");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getReplaceField() {
        return this.replaceField;
    }

    public void setReplaceField(String replaceField) {
        this.replaceField = replaceField;
    }
}

