/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mail;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mail.Mail;
import org.pentaho.di.trans.steps.mail.MailData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MailMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MailMeta.class;
    private String server;
    private String destination;
    private String destinationCc;
    private String destinationBCc;
    private String replyAddress;
    private String replyName;
    private String subject;
    private boolean includeDate;
    private boolean includeSubFolders;
    private boolean zipFilenameDynamic;
    private boolean isFilenameDynamic;
    private String dynamicFieldname;
    private String dynamicWildcard;
    private String dynamicZipFilename;
    private String sourcefilefoldername;
    private String sourcewildcard;
    private String contactPerson;
    private String contactPhone;
    private String comment;
    private boolean includingFiles;
    private boolean zipFiles;
    private String zipFilename;
    private String ziplimitsize;
    private boolean usingAuthentication;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean onlySendComment;
    private boolean useHTML;
    private boolean usingSecureAuthentication;
    private boolean usePriority;
    private String port;
    private String priority;
    private String importance;
    private String sensitivity;
    private String secureconnectiontype;
    private String encoding;
    private String replyToAddresses;
    private String[] embeddedimages;
    private String[] contentids;
    private boolean attachContentFromField;
    private String attachContentField;
    private String attachContentFileNameField;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void allocate(int value) {
        this.embeddedimages = new String[value];
        this.contentids = new String[value];
    }

    private void readData(Node stepnode) {
        this.setServer(XMLHandler.getTagValue((Node)stepnode, (String)"server"));
        this.setPort(XMLHandler.getTagValue((Node)stepnode, (String)"port"));
        this.setDestination(XMLHandler.getTagValue((Node)stepnode, (String)"destination"));
        this.setDestinationCc(XMLHandler.getTagValue((Node)stepnode, (String)"destinationCc"));
        this.setDestinationBCc(XMLHandler.getTagValue((Node)stepnode, (String)"destinationBCc"));
        this.setReplyToAddresses(XMLHandler.getTagValue((Node)stepnode, (String)"replyToAddresses"));
        this.setReplyAddress(XMLHandler.getTagValue((Node)stepnode, (String)"replyto"));
        this.setReplyName(XMLHandler.getTagValue((Node)stepnode, (String)"replytoname"));
        this.setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"subject"));
        this.setIncludeDate("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_date")));
        this.setIncludeSubFolders("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_subfolders")));
        this.setZipFilenameDynamic("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"zipFilenameDynamic")));
        this.setisDynamicFilename("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"isFilenameDynamic")));
        this.setDynamicFieldname(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicFieldname"));
        this.setDynamicWildcard(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicWildcard"));
        this.setAttachContentFromField("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"attachContentFromField")));
        this.setAttachContentField(XMLHandler.getTagValue((Node)stepnode, (String)"attachContentField"));
        this.setAttachContentFileNameField(XMLHandler.getTagValue((Node)stepnode, (String)"attachContentFileNameField"));
        this.setDynamicZipFilenameField(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicZipFilename"));
        this.setSourceFileFoldername(XMLHandler.getTagValue((Node)stepnode, (String)"sourcefilefoldername"));
        this.setSourceWildcard(XMLHandler.getTagValue((Node)stepnode, (String)"sourcewildcard"));
        this.setContactPerson(XMLHandler.getTagValue((Node)stepnode, (String)"contact_person"));
        this.setContactPhone(XMLHandler.getTagValue((Node)stepnode, (String)"contact_phone"));
        this.setComment(XMLHandler.getTagValue((Node)stepnode, (String)"comment"));
        this.setIncludingFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_files")));
        this.setUsingAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_auth")));
        this.setUsingSecureAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_secure_auth")));
        this.setAuthenticationUser(XMLHandler.getTagValue((Node)stepnode, (String)"auth_user"));
        this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password")));
        this.setOnlySendComment("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"only_comment")));
        this.setUseHTML("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_HTML")));
        this.setUsePriority("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_Priority")));
        this.setEncoding(XMLHandler.getTagValue((Node)stepnode, (String)"encoding"));
        this.setPriority(XMLHandler.getTagValue((Node)stepnode, (String)"priority"));
        this.setImportance(XMLHandler.getTagValue((Node)stepnode, (String)"importance"));
        this.setSensitivity(XMLHandler.getTagValue((Node)stepnode, (String)"sensitivity"));
        this.setSecureConnectionType(XMLHandler.getTagValue((Node)stepnode, (String)"secureconnectiontype"));
        this.setZipFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"zip_files")));
        this.setZipFilename(XMLHandler.getTagValue((Node)stepnode, (String)"zip_name"));
        this.setZipLimitSize(XMLHandler.getTagValue((Node)stepnode, (String)"zip_limit_size"));
        Node images = XMLHandler.getSubNode((Node)stepnode, (String)"embeddedimages");
        int nrImages = XMLHandler.countNodes((Node)images, (String)"embeddedimage");
        this.allocate(nrImages);
        for (int i = 0; i < nrImages; ++i) {
            Node fnode = XMLHandler.getSubNodeByNr((Node)images, (String)"embeddedimage", (int)i);
            this.embeddedimages[i] = XMLHandler.getTagValue((Node)fnode, (String)"image_name");
            this.contentids[i] = XMLHandler.getTagValue((Node)fnode, (String)"content_id");
        }
    }

    public void setEmbeddedImage(int i, String value) {
        this.embeddedimages[i] = value;
    }

    public void setEmbeddedImages(String[] value) {
        this.embeddedimages = value;
    }

    public void setContentIds(int i, String value) {
        this.contentids[i] = value;
    }

    public void setContentIds(String[] value) {
        this.contentids = value;
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String getXML() throws KettleException {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination", (String)this.destination));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationCc", (String)this.destinationCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationBCc", (String)this.destinationBCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyToAddresses", (String)this.replyToAddresses));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyto", (String)this.replyAddress));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replytoname", (String)this.replyName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"subject", (String)this.subject));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_date", (boolean)this.includeDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubFolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipFilenameDynamic", (boolean)this.zipFilenameDynamic));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isFilenameDynamic", (boolean)this.isFilenameDynamic));
        retval.append("      ").append(XMLHandler.addTagValue((String)"attachContentFromField", (boolean)this.attachContentFromField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"attachContentField", (String)this.attachContentField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"attachContentFileNameField", (String)this.attachContentFileNameField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dynamicFieldname", (String)this.dynamicFieldname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dynamicWildcard", (String)this.dynamicWildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dynamicZipFilename", (String)this.dynamicZipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourcefilefoldername", (String)this.sourcefilefoldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourcewildcard", (String)this.sourcewildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_person", (String)this.contactPerson));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_phone", (String)this.contactPhone));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_files", (boolean)this.includingFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_files", (boolean)this.zipFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_name", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_limit_size", (String)this.ziplimitsize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_auth", (boolean)this.usingAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_secure_auth", (boolean)this.usingSecureAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_comment", (boolean)this.onlySendComment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_HTML", (boolean)this.useHTML));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_Priority", (boolean)this.usePriority));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("    " + XMLHandler.addTagValue((String)"importance", (String)this.importance));
        retval.append("    " + XMLHandler.addTagValue((String)"sensitivity", (String)this.sensitivity));
        retval.append("    " + XMLHandler.addTagValue((String)"secureconnectiontype", (String)this.secureconnectiontype));
        retval.append("      <embeddedimages>").append(Const.CR);
        if (this.embeddedimages != null) {
            for (int i = 0; i < this.embeddedimages.length; ++i) {
                retval.append("        <embeddedimage>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"image_name", (String)this.embeddedimages[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"content_id", (String)this.contentids[i]));
                retval.append("        </embeddedimage>").append(Const.CR);
            }
        }
        retval.append("      </embeddedimages>").append(Const.CR);
        return retval.toString();
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setDestinationCc(String destCc) {
        this.destinationCc = destCc;
    }

    public void setDestinationBCc(String destBCc) {
        this.destinationBCc = destBCc;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationCc() {
        return this.destinationCc;
    }

    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    public void setReplyAddress(String reply) {
        this.replyAddress = reply;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyName(String replyname) {
        this.replyName = replyname;
    }

    public String getReplyName() {
        return this.replyName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setIncludeDate(boolean incl) {
        this.includeDate = incl;
    }

    public void setIncludeSubFolders(boolean incl) {
        this.includeSubFolders = incl;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public String[] getEmbeddedImages() {
        return this.embeddedimages;
    }

    public String[] getContentIds() {
        return this.contentids;
    }

    public boolean isZipFilenameDynamic() {
        return this.zipFilenameDynamic;
    }

    public void setZipFilenameDynamic(boolean isdynamic) {
        this.zipFilenameDynamic = isdynamic;
    }

    public void setisDynamicFilename(boolean isdynamic) {
        this.isFilenameDynamic = isdynamic;
    }

    public void setAttachContentFromField(boolean attachContentFromField) {
        this.attachContentFromField = attachContentFromField;
    }

    public void setAttachContentField(String attachContentField) {
        this.attachContentField = attachContentField;
    }

    public void setAttachContentFileNameField(String attachContentFileNameField) {
        this.attachContentFileNameField = attachContentFileNameField;
    }

    public void setDynamicWildcard(String dynamicwildcard) {
        this.dynamicWildcard = dynamicwildcard;
    }

    public void setDynamicZipFilenameField(String dynamiczipfilename) {
        this.dynamicZipFilename = dynamiczipfilename;
    }

    public String getDynamicZipFilenameField() {
        return this.dynamicZipFilename;
    }

    public String getDynamicWildcard() {
        return this.dynamicWildcard;
    }

    public void setSourceFileFoldername(String sourcefile) {
        this.sourcefilefoldername = sourcefile;
    }

    public String getSourceFileFoldername() {
        return this.sourcefilefoldername;
    }

    public void setSourceWildcard(String wildcard) {
        this.sourcewildcard = wildcard;
    }

    public String getSourceWildcard() {
        return this.sourcewildcard;
    }

    public void setDynamicFieldname(String dynamicfield) {
        this.dynamicFieldname = dynamicfield;
    }

    public String getDynamicFieldname() {
        return this.dynamicFieldname;
    }

    public boolean getIncludeDate() {
        return this.includeDate;
    }

    public boolean isDynamicFilename() {
        return this.isFilenameDynamic;
    }

    public boolean isAttachContentFromField() {
        return this.attachContentFromField;
    }

    public String getAttachContentField() {
        return this.attachContentField;
    }

    public String getAttachContentFileNameField() {
        return this.attachContentFileNameField;
    }

    public void setContactPerson(String person) {
        this.contactPerson = person;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPhone(String phone) {
        this.contactPhone = phone;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    public void setIncludingFiles(boolean includeFiles) {
        this.includingFiles = includeFiles;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public String getZipLimitSize() {
        return this.ziplimitsize;
    }

    public void setZipLimitSize(String ziplimitsize) {
        this.ziplimitsize = ziplimitsize;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public boolean isZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean UseHTML) {
        this.useHTML = UseHTML;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSecureConnectionType() {
        return this.secureconnectiontype;
    }

    public void setSecureConnectionType(String secureconnectiontypein) {
        this.secureconnectiontype = secureconnectiontypein;
    }

    public void setReplyToAddresses(String replytoaddresses) {
        this.replyToAddresses = replytoaddresses;
    }

    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUsePriority(boolean usePriorityin) {
        this.usePriority = usePriorityin;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setImportance(String importancein) {
        this.importance = importancein;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setPriority(String priorityin) {
        this.priority = priorityin;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.server = rep.getStepAttributeString(id_step, "server");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.destination = rep.getStepAttributeString(id_step, "destination");
            this.destinationCc = rep.getStepAttributeString(id_step, "destinationCc");
            this.destinationBCc = rep.getStepAttributeString(id_step, "destinationBCc");
            this.replyToAddresses = rep.getStepAttributeString(id_step, "replyToAddresses");
            this.replyAddress = rep.getStepAttributeString(id_step, "replyto");
            this.replyName = rep.getStepAttributeString(id_step, "replytoname");
            this.subject = rep.getStepAttributeString(id_step, "subject");
            this.includeDate = rep.getStepAttributeBoolean(id_step, "include_date");
            this.includeSubFolders = rep.getStepAttributeBoolean(id_step, "include_subfolders");
            this.zipFilenameDynamic = rep.getStepAttributeBoolean(id_step, "zipFilenameDynamic");
            this.attachContentFromField = rep.getStepAttributeBoolean(id_step, "attachContentFromField");
            this.attachContentField = rep.getStepAttributeString(id_step, "attachContentField");
            this.attachContentFileNameField = rep.getStepAttributeString(id_step, "attachContentFileNameField");
            this.isFilenameDynamic = rep.getStepAttributeBoolean(id_step, "isFilenameDynamic");
            this.dynamicFieldname = rep.getStepAttributeString(id_step, "dynamicFieldname");
            this.dynamicWildcard = rep.getStepAttributeString(id_step, "dynamicWildcard");
            this.dynamicZipFilename = rep.getStepAttributeString(id_step, "dynamicZipFilename");
            this.sourcefilefoldername = rep.getStepAttributeString(id_step, "sourcefilefoldername");
            this.sourcewildcard = rep.getStepAttributeString(id_step, "sourcewildcard");
            this.contactPerson = rep.getStepAttributeString(id_step, "contact_person");
            this.contactPhone = rep.getStepAttributeString(id_step, "contact_phone");
            this.comment = rep.getStepAttributeString(id_step, "comment");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.priority = rep.getStepAttributeString(id_step, "priority");
            this.importance = rep.getStepAttributeString(id_step, "importance");
            this.sensitivity = rep.getStepAttributeString(id_step, "sensitivity");
            this.includingFiles = rep.getStepAttributeBoolean(id_step, "include_files");
            this.usingAuthentication = rep.getStepAttributeBoolean(id_step, "use_auth");
            this.usingSecureAuthentication = rep.getStepAttributeBoolean(id_step, "use_secure_auth");
            this.authenticationUser = rep.getStepAttributeString(id_step, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password"));
            this.onlySendComment = rep.getStepAttributeBoolean(id_step, "only_comment");
            this.useHTML = rep.getStepAttributeBoolean(id_step, "use_HTML");
            this.usePriority = rep.getStepAttributeBoolean(id_step, "use_Priority");
            this.secureconnectiontype = rep.getStepAttributeString(id_step, "secureconnectiontype");
            this.zipFiles = rep.getStepAttributeBoolean(id_step, "zip_files");
            this.zipFilename = rep.getStepAttributeString(id_step, "zip_name");
            this.ziplimitsize = rep.getStepAttributeString(id_step, "zip_limit_size");
            int imagesnr = rep.countNrStepAttributes(id_step, "embeddedimage");
            this.allocate(imagesnr);
            for (int a = 0; a < imagesnr; ++a) {
                this.embeddedimages[a] = rep.getStepAttributeString(id_step, a, "embeddedimage");
                this.contentids[a] = rep.getStepAttributeString(id_step, a, "contentid");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load step type 'mail' from the repository with id_step=" + id_step, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "server", this.server);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "destination", this.destination);
            rep.saveStepAttribute(id_transformation, id_step, "destinationCc", this.destinationCc);
            rep.saveStepAttribute(id_transformation, id_step, "destinationBCc", this.destinationBCc);
            rep.saveStepAttribute(id_transformation, id_step, "replyToAddresses", this.replyToAddresses);
            rep.saveStepAttribute(id_transformation, id_step, "replyto", this.replyAddress);
            rep.saveStepAttribute(id_transformation, id_step, "replytoname", this.replyName);
            rep.saveStepAttribute(id_transformation, id_step, "subject", this.subject);
            rep.saveStepAttribute(id_transformation, id_step, "include_date", this.includeDate);
            rep.saveStepAttribute(id_transformation, id_step, "include_subfolders", this.includeSubFolders);
            rep.saveStepAttribute(id_transformation, id_step, "zipFilenameDynamic", this.zipFilenameDynamic);
            rep.saveStepAttribute(id_transformation, id_step, "attachContentFromField", this.attachContentFromField);
            rep.saveStepAttribute(id_transformation, id_step, "attachContentField", this.attachContentField);
            rep.saveStepAttribute(id_transformation, id_step, "attachContentFileNameField", this.attachContentFileNameField);
            rep.saveStepAttribute(id_transformation, id_step, "isFilenameDynamic", this.isFilenameDynamic);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicFieldname", this.dynamicFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicWildcard", this.dynamicWildcard);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicZipFilename", this.dynamicZipFilename);
            rep.saveStepAttribute(id_transformation, id_step, "sourcefilefoldername", this.sourcefilefoldername);
            rep.saveStepAttribute(id_transformation, id_step, "sourcewildcard", this.sourcewildcard);
            rep.saveStepAttribute(id_transformation, id_step, "contact_person", this.contactPerson);
            rep.saveStepAttribute(id_transformation, id_step, "contact_phone", this.contactPhone);
            rep.saveStepAttribute(id_transformation, id_step, "comment", this.comment);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "priority", this.priority);
            rep.saveStepAttribute(id_transformation, id_step, "importance", this.importance);
            rep.saveStepAttribute(id_transformation, id_step, "sensitivity", this.sensitivity);
            rep.saveStepAttribute(id_transformation, id_step, "include_files", this.includingFiles);
            rep.saveStepAttribute(id_transformation, id_step, "use_auth", this.usingAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "use_secure_auth", this.usingSecureAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.authenticationUser);
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
            rep.saveStepAttribute(id_transformation, id_step, "only_comment", this.onlySendComment);
            rep.saveStepAttribute(id_transformation, id_step, "use_HTML", this.useHTML);
            rep.saveStepAttribute(id_transformation, id_step, "use_Priority", this.usePriority);
            rep.saveStepAttribute(id_transformation, id_step, "secureconnectiontype", this.secureconnectiontype);
            rep.saveStepAttribute(id_transformation, id_step, "zip_files", this.zipFiles);
            rep.saveStepAttribute(id_transformation, id_step, "zip_name", this.zipFilename);
            rep.saveStepAttribute(id_transformation, id_step, "zip_limit_size", this.ziplimitsize);
            if (this.embeddedimages != null) {
                for (int i = 0; i < this.embeddedimages.length; ++i) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "embeddedimage", this.embeddedimages[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "contentid", this.contentids[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save step type 'mail' to the repository for id_step=" + id_step, (Throwable)dbe);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (Utils.isEmpty((CharSequence)this.server)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (prev.indexOfValue(transMeta.environmentSubstitute(this.server)) < 0) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerFieldNotFound", (String[])new String[]{this.server}), (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        }
        cr = Utils.isEmpty((CharSequence)this.port) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.replyAddress) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.destination) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.subject) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.comment) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.isFilenameDynamic) {
            cr = Utils.isEmpty((CharSequence)this.dynamicFieldname) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.sourcefilefoldername) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isZipFiles()) {
            if (this.isFilenameDynamic) {
                cr = Utils.isEmpty((CharSequence)this.getDynamicZipFilenameField()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = Utils.isEmpty((CharSequence)this.zipFilename) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Mail(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MailData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

