/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mysqlbulkloader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.injection.InjectionTypeConverter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoader;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="MySQLBulkLoader.Injection.", groups={"FIELDS"})
public class MySQLBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = MySQLBulkLoaderMeta.class;
    public static final int FIELD_FORMAT_TYPE_OK = 0;
    public static final int FIELD_FORMAT_TYPE_DATE = 1;
    public static final int FIELD_FORMAT_TYPE_TIMESTAMP = 2;
    public static final int FIELD_FORMAT_TYPE_NUMBER = 3;
    public static final int FIELD_FORMAT_TYPE_STRING_ESCAPE = 4;
    private static final String[] fieldFormatTypeCodes = new String[]{"OK", "DATE", "TIMESTAMP", "NUMBER", "STRING_ESC"};
    private static final String[] fieldFormatTypeDescriptions = new String[]{BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.FieldFormatType.OK.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.FieldFormatType.Date.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.FieldFormatType.Timestamp.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.FieldFormatType.Number.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.FieldFormatType.StringEscape.Description", (String[])new String[0])};
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    @Injection(name="FIFO_FILE")
    private String fifoFileName;
    private DatabaseMeta databaseMeta;
    @Injection(name="FIELD_TABLE", group="FIELDS")
    private String[] fieldTable;
    @Injection(name="FIELD_STREAM", group="FIELDS")
    private String[] fieldStream;
    @Injection(name="FIELD_FORMAT", group="FIELDS", converter=FieldFormatTypeConverter.class)
    private int[] fieldFormatType;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="USE_REPLACE_CLAUSE")
    private boolean replacingData;
    @Injection(name="USE_IGNORE_CLAUSE")
    private boolean ignoringErrors;
    @Injection(name="LOCAL_FILE")
    private boolean localFile;
    @Injection(name="DELIMITER")
    private String delimiter;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="ESCAPE_CHAR")
    private String escapeChar;
    @Injection(name="BULK_SIZE")
    private String bulkSize;

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.fieldFormatType = new int[nrvalues];
    }

    @Override
    public Object clone() {
        MySQLBulkLoaderMeta retval = (MySQLBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        System.arraycopy(this.fieldTable, 0, retval.fieldTable, 0, nrvalues);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrvalues);
        System.arraycopy(this.fieldFormatType, 0, retval.fieldFormatType, 0, nrvalues);
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.fifoFileName = XMLHandler.getTagValue((Node)stepnode, (String)"fifo_file_name");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.escapeChar = XMLHandler.getTagValue((Node)stepnode, (String)"escape_char");
            this.bulkSize = XMLHandler.getTagValue((Node)stepnode, (String)"bulk_size");
            this.replacingData = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"replace"));
            this.ignoringErrors = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignore"));
            this.localFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"local"));
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatType[i] = MySQLBulkLoaderMeta.getFieldFormatType(XMLHandler.getTagValue((Node)vnode, (String)"field_format_ok"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.encoding = "";
        this.fifoFileName = "/tmp/fifo";
        this.delimiter = "\t";
        this.enclosure = "\"";
        this.escapeChar = "\\";
        this.replacingData = false;
        this.ignoringErrors = false;
        this.localFile = true;
        this.bulkSize = null;
        this.allocate(0);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"escape_char", (String)this.escapeChar));
        retval.append("    ").append(XMLHandler.addTagValue((String)"replace", (boolean)this.replacingData));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ignore", (boolean)this.ignoringErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"local", (boolean)this.localFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fifo_file_name", (String)this.fifoFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bulk_size", (String)this.bulkSize));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_format_ok", (String)MySQLBulkLoaderMeta.getFieldFormatTypeCode(this.fieldFormatType[i])));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.escapeChar = rep.getStepAttributeString(id_step, "escape_char");
            this.fifoFileName = rep.getStepAttributeString(id_step, "fifo_file_name");
            this.replacingData = rep.getStepAttributeBoolean(id_step, "replace");
            this.ignoringErrors = rep.getStepAttributeBoolean(id_step, "ignore");
            this.localFile = rep.getStepAttributeBoolean(id_step, "local");
            this.bulkSize = rep.getStepAttributeString(id_step, "bulk_size");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatType[i] = MySQLBulkLoaderMeta.getFieldFormatType(rep.getStepAttributeString(id_step, i, "field_format_ok"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "escape_char", this.escapeChar);
            rep.saveStepAttribute(id_transformation, id_step, "fifo_file_name", this.fifoFileName);
            rep.saveStepAttribute(id_transformation, id_step, "replace", this.replacingData);
            rep.saveStepAttribute(id_transformation, id_step, "ignore", this.ignoringErrors);
            rep.saveStepAttribute(id_transformation, id_step, "local", this.localFile);
            rep.saveStepAttribute(id_transformation, id_step, "bulk_size", this.bulkSize);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format_ok", MySQLBulkLoaderMeta.getFieldFormatTypeCode(this.fieldFormatType[i]));
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String cr_table;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new MySQLBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MySQLBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getFifoFileName() {
        return this.fifoFileName;
    }

    public void setFifoFileName(String fifoFileName) {
        this.fifoFileName = fifoFileName;
    }

    public boolean isReplacingData() {
        return this.replacingData;
    }

    public void setReplacingData(boolean replacingData) {
        this.replacingData = replacingData;
    }

    public int[] getFieldFormatType() {
        return this.fieldFormatType;
    }

    public void setFieldFormatType(int[] fieldFormatType) {
        this.fieldFormatType = fieldFormatType;
    }

    public static String[] getFieldFormatTypeCodes() {
        return fieldFormatTypeCodes;
    }

    public static String[] getFieldFormatTypeDescriptions() {
        return fieldFormatTypeDescriptions;
    }

    public static String getFieldFormatTypeCode(int type) {
        return fieldFormatTypeCodes[type];
    }

    public static String getFieldFormatTypeDescription(int type) {
        return fieldFormatTypeDescriptions[type];
    }

    public static int getFieldFormatType(String codeOrDescription) {
        int i;
        for (i = 0; i < fieldFormatTypeCodes.length; ++i) {
            if (!fieldFormatTypeCodes[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        for (i = 0; i < fieldFormatTypeDescriptions.length; ++i) {
            if (!fieldFormatTypeDescriptions[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        return 0;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public boolean isIgnoringErrors() {
        return this.ignoringErrors;
    }

    public void setIgnoringErrors(boolean ignoringErrors) {
        this.ignoringErrors = ignoringErrors;
    }

    public String getBulkSize() {
        return this.bulkSize;
    }

    public void setBulkSize(String bulkSize) {
        this.bulkSize = bulkSize;
    }

    public boolean isLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(boolean localFile) {
        this.localFile = localFile;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public static class FieldFormatTypeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws KettleValueException {
            for (int i = 0; i < fieldFormatTypeCodes.length; ++i) {
                if (!fieldFormatTypeCodes[i].equalsIgnoreCase(v)) continue;
                return i;
            }
            return 0;
        }
    }
}

