/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyinput;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputData;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputField;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputMeta;

public class PropertyInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PropertyInputMeta.class;
    private PropertyInputMeta meta;
    private PropertyInputData data;

    public PropertyInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block7: {
            if (this.first && !this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files == null || this.data.files.nrOfFiles() == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoFiles", (String[])new String[0]));
                }
                this.handleMissingFiles();
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
            }
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "PropertyInput001");
            }
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || this.data.propfiles && !this.data.it.hasNext() || !this.data.propfiles && !this.data.iniIt.hasNext()) {
                    if (!this.data.propfiles && this.data.realSection == null && this.data.readrow != null && this.data.itSection.hasNext()) {
                        this.data.iniSection = (Profile.Section)this.data.wini.get((Object)this.data.itSection.next().toString());
                        this.data.iniIt = this.data.iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || this.data.propfiles && !this.data.it.hasNext() || !this.data.propfiles && !this.data.iniIt.hasNext()) {
                    if (!this.data.propfiles && this.data.realSection == null && this.data.file != null && this.data.itSection.hasNext()) {
                        this.data.iniSection = (Profile.Section)this.data.wini.get((Object)this.data.itSection.next().toString());
                        this.data.iniIt = this.data.iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            this.logError("Unable to read row from file : " + IO.getMessage());
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            r = (Object[])this.data.readrow.clone();
        }
        try {
            RowMetaInterface irow;
            String key = null;
            key = this.data.propfiles ? this.data.it.next().toString() : this.data.iniIt.next().toString();
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                String value = null;
                value = this.meta.getInputFields()[i].getColumnCode().equals(PropertyInputField.ColumnCode[0]) ? key : (this.meta.isResolveValueVariable() ? (this.data.propfiles ? this.environmentSubstitute(this.data.pro.getProperty(key)) : this.environmentSubstitute(this.data.iniSection.fetch((Object)key))) : (this.data.propfiles ? this.data.pro.getProperty(key) : this.data.iniSection.fetch((Object)key)));
                switch (this.meta.getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                if (this.meta.isFileField()) {
                    r = RowDataUtil.addValueData((Object[])r, (int)(this.data.totalpreviousfields + i), (Object)value);
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                r[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Utils.isEmpty((CharSequence)value)) continue;
                r[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.meta.getInputFields().length;
            if (this.meta.includeFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.filename;
            }
            if (this.meta.includeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                r[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.includeIniSection() && !Utils.isEmpty((CharSequence)this.meta.getINISectionField())) {
                r[this.data.totalpreviousfields + rowIndex++] = this.environmentSubstitute(this.data.iniSection.getName());
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.shortFilename;
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.extension;
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.path;
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.size);
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = new Boolean(this.data.hidden);
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.lastModificationDateTime;
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.uriName;
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.rootUriName;
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? r : irow.cloneRow(r);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotReadFromFile", (String[])new String[]{this.data.file.toString()}), (Throwable)e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openNextFile() {
        InputStream fis = null;
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
                    if (Utils.isEmpty((CharSequence)this.meta.getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FilenameInStream", (String[])new String[]{this.meta.getDynamicFilenameField(), filename}));
                }
                this.data.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta());
            }
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                this.data.hidden = this.data.file.isHidden();
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                this.data.extension = this.data.file.getName().getExtension();
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                this.data.uriName = this.data.file.getName().getURI();
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                this.data.rootUriName = this.data.file.getName().getRootURI();
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                this.data.size = new Long(this.data.file.getContent().getSize());
            }
            if (this.meta.resetRowNumber()) {
                this.data.rownr = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            fis = this.data.file.getContent().getInputStream();
            if (this.data.propfiles) {
                this.data.pro = new Properties();
                this.data.pro.load(fis);
                this.data.it = this.data.pro.keySet().iterator();
            } else {
                this.data.wini = new Wini(fis);
                if (!Utils.isEmpty((CharSequence)this.data.realEncoding)) {
                    this.data.wini.getConfig().setFileEncoding(Charset.forName(this.data.realEncoding));
                }
                if (this.data.realSection != null) {
                    this.data.iniSection = (Profile.Section)this.data.wini.get((Object)this.data.realSection);
                    if (this.data.iniSection == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotFindSection", (String[])new String[]{this.data.realSection, "" + this.data.file.getName()}));
                    }
                } else {
                    this.data.itSection = this.data.wini.keySet().iterator();
                    this.data.iniSection = (Profile.Section)this.data.wini.get((Object)this.data.itSection.next().toString());
                }
                this.data.iniIt = this.data.iniSection.keySet().iterator();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.log.TotalKey", (String[])new String[]{"" + (this.data.propfiles ? this.data.pro.size() : this.data.iniSection.size()), KettleVFS.getFilename((FileObject)this.data.file)}));
            }
            BaseStep.closeQuietly(fis);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            boolean bl = false;
            return bl;
        }
        finally {
            BaseStep.closeQuietly(fis);
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyInputMeta)smi;
        this.data = (PropertyInputData)sdi;
        if (super.init(smi, sdi)) {
            String realSection;
            String realEncoding = this.environmentSubstitute(this.meta.getEncoding());
            if (!Utils.isEmpty((CharSequence)realEncoding)) {
                this.data.realEncoding = realEncoding;
            }
            if (!Utils.isEmpty((CharSequence)(realSection = this.environmentSubstitute(this.meta.getSection())))) {
                this.data.realSection = realSection;
            }
            this.data.propfiles = PropertyInputMeta.getFileTypeByDesc(this.meta.getFileType()) == 0;
            this.data.rownr = 1L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyInputMeta)smi;
        this.data = (PropertyInputData)sdi;
        if (this.data.readrow != null) {
            this.data.readrow = null;
        }
        if (this.data.iniSection != null) {
            this.data.iniSection.clear();
        }
        this.data.iniSection = null;
        if (this.data.itSection != null) {
            this.data.itSection = null;
        }
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

