/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyinput.PropertyInput;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputData;
import org.pentaho.di.trans.steps.propertyinput.PropertyInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PropertyInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PropertyInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String YES = "Y";
    public static final String[] type_trim_code = new String[]{"none", "left", "right", "both"};
    public static final String[] column_code = new String[]{"key", "value"};
    public static final String[] fileTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Property", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Ini", (String[])new String[0])};
    public static final String[] fileTypeCode = new String[]{"property", "ini"};
    public static final int FILE_TYPE_PROPERTY = 0;
    public static final int FILE_TYPE_INI = 1;
    private String encoding;
    private String fileType;
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private boolean resetRowNumber;
    private boolean resolvevaluevariable;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private PropertyInputField[] inputFields;
    private boolean filefield;
    private boolean isaddresult;
    private String dynamicFilenameField;
    private boolean includeIniSection;
    private String iniSectionField;
    private String section;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public PropertyInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(PropertyInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    @Deprecated
    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public static String getFileTypeCode(int i) {
        if (i < 0 || i >= fileTypeCode.length) {
            return fileTypeCode[0];
        }
        return fileTypeCode[i];
    }

    public static int getFileTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fileTypeDesc.length; ++i) {
            if (!fileTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return PropertyInputMeta.getFileTypeByCode(tt);
    }

    public static int getFileTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fileTypeCode.length; ++i) {
            if (!fileTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getFileTypeDesc(int i) {
        if (i < 0 || i >= fileTypeDesc.length) {
            return fileTypeDesc[0];
        }
        return fileTypeDesc[i];
    }

    public void setFileType(String filetype) {
        this.fileType = filetype;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setIncludeIniSection(boolean includeIniSection) {
        this.includeIniSection = includeIniSection;
    }

    public boolean includeIniSection() {
        return this.includeIniSection;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setINISectionField(String iniSectionField) {
        this.iniSectionField = iniSectionField;
    }

    public String getINISectionField() {
        return this.iniSectionField;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getSection() {
        return this.section;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean resetRowNumber() {
        return this.resetRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public void setResetRowNumber(boolean resetRowNumber) {
        this.resetRowNumber = resetRowNumber;
    }

    public void setResolveValueVariable(boolean resolvevaluevariable) {
        this.resolvevaluevariable = resolvevaluevariable;
    }

    public boolean isResolveValueVariable() {
        return this.resolvevaluevariable;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        PropertyInputMeta retval = (PropertyInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (PropertyInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_type", (String)this.fileType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_Field", (String)this.dynamicFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"resetrownumber", (boolean)this.resetRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"resolvevaluevariable", (boolean)this.resolvevaluevariable));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ini_section", (boolean)this.includeIniSection));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ini_section_field", (String)this.iniSectionField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"section", (String)this.section));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"column", (String)this.inputFields[i].getColumnCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.fileType = XMLHandler.getTagValue((Node)stepnode, (String)"file_type");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            String addresult = XMLHandler.getTagValue((Node)stepnode, (String)"isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : YES.equalsIgnoreCase(addresult);
            this.section = XMLHandler.getTagValue((Node)stepnode, (String)"section");
            this.iniSectionField = XMLHandler.getTagValue((Node)stepnode, (String)"ini_section_field");
            this.includeIniSection = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ini_section"));
            this.filefield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.dynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_Field");
            this.resetRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"resetrownumber"));
            this.resolvevaluevariable = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"resolvevaluevariable"));
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = new PropertyInputField();
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setColumn(PropertyInputMeta.getColumnByCode(XMLHandler.getTagValue((Node)fnode, (String)"column")));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XMLHandler.getTagValue((Node)fnode, (String)"repeat");
                this.inputFields[i].setTrimType(PropertyInputMeta.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new PropertyInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.fileType = fileTypeCode[0];
        this.section = "";
        this.encoding = DEFAULT_ENCODING;
        this.includeIniSection = false;
        this.iniSectionField = "";
        this.resolvevaluevariable = false;
        this.isaddresult = true;
        this.filefield = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new PropertyInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        ValueMetaInterface v2;
        for (int i = 0; i < this.inputFields.length; ++i) {
            PropertyInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        String realFilenameField = space.environmentSubstitute(this.filenameField);
        if (this.includeFilename && !Utils.isEmpty((CharSequence)realFilenameField)) {
            ValueMetaString v3 = new ValueMetaString(realFilenameField);
            v3.setLength(500);
            v3.setPrecision(-1);
            v3.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v3);
        }
        String realRowNumberField = space.environmentSubstitute(this.rowNumberField);
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)realRowNumberField)) {
            v2 = new ValueMetaInteger(realRowNumberField);
            v2.setLength(10, 0);
            v2.setOrigin(name);
            r.addValueMeta(v2);
        }
        String realSectionField = space.environmentSubstitute(this.iniSectionField);
        if (this.includeIniSection && !Utils.isEmpty((CharSequence)realSectionField)) {
            v = new ValueMetaString(realSectionField);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.getSizeField()));
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMetaBoolean(space.environmentSubstitute(this.isHiddenField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMetaDate(space.environmentSubstitute(this.getLastModificationDateField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trim_code.length; ++i) {
                if (!type_trim_code[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final int getColumnByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < column_code.length; ++i) {
                if (!column_code[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.fileType = rep.getStepAttributeString(id_step, "file_type");
            this.section = rep.getStepAttributeString(id_step, "section");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.includeIniSection = rep.getStepAttributeBoolean(id_step, "ini_section");
            this.iniSectionField = rep.getStepAttributeString(id_step, "ini_section_field");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.dynamicFilenameField = rep.getStepAttributeString(id_step, "filename_Field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            String addresult = rep.getStepAttributeString(id_step, "isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : rep.getStepAttributeBoolean(id_step, "isaddresult");
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.resetRowNumber = rep.getStepAttributeBoolean(id_step, "reset_rownumber");
            this.resolvevaluevariable = rep.getStepAttributeBoolean(id_step, "resolve_value_variable");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = RequiredFilesCode[0];
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = RequiredFilesCode[0];
            }
            for (i = 0; i < nrFields; ++i) {
                PropertyInputField field = new PropertyInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setColumn(PropertyInputField.getColumnByCode(rep.getStepAttributeString(id_step, i, "field_column")));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(PropertyInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.uriNameFieldName = rep.getStepAttributeString(id_step, "uriNameFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "file_type", this.fileType);
            rep.saveStepAttribute(id_transformation, id_step, "section", this.section);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "ini_section", this.includeIniSection);
            rep.saveStepAttribute(id_transformation, id_step, "ini_section_field", this.iniSectionField);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "isaddresult", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "filename_Field", this.dynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "reset_rownumber", this.resetRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "resolve_value_variable", this.resolvevaluevariable);
            rep.saveStepAttribute(id_transformation, id_step, "sizeFieldName", this.sizeFieldName);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                PropertyInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_column", field.getColumnCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        String[] required = new String[this.fileName.length];
        boolean[] subdirs = new boolean[this.fileName.length];
        for (int i = 0; i < required.length; ++i) {
            required[i] = YES;
        }
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])required, (boolean[])subdirs);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new PropertyInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PropertyInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

