/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyoutput;

import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputData;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputMeta;

public class PropertyOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PropertyOutputMeta.class;
    private PropertyOutputMeta meta;
    private PropertyOutputData data;

    public PropertyOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (PropertyOutputMeta)smi;
            this.data = (PropertyOutputData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.indexOfKeyField = this.data.inputRowMeta.indexOfValue(this.meta.getKeyField());
                if (this.data.indexOfKeyField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getKeyField()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getKeyField()}));
                }
                this.data.indexOfValueField = this.data.inputRowMeta.indexOfValue(this.meta.getValueField());
                if (this.data.indexOfValueField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getValueField()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getValueField()}));
                }
                if (this.meta.isFileNameInField()) {
                    String realFieldName = this.environmentSubstitute(this.meta.getFileNameField());
                    if (Utils.isEmpty((CharSequence)realFieldName)) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameInFieldEmpty", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameInFieldEmpty", (String[])new String[0]));
                    }
                    this.data.indexOfFieldfilename = this.data.inputRowMeta.indexOfValue(realFieldName);
                    if (this.data.indexOfFieldfilename < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getValueField()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getValueField()}));
                    }
                } else {
                    this.data.filename = this.buildFilename();
                    if (Utils.isEmpty((CharSequence)this.data.filename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameEmpty", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameEmpty", (String[])new String[0]));
                    }
                    this.openNewFile();
                }
            }
            String propkey = this.data.inputRowMeta.getString(r, this.data.indexOfKeyField);
            String propvalue = this.data.inputRowMeta.getString(r, this.data.indexOfValueField);
            try {
                if (this.meta.isFileNameInField()) {
                    this.data.filename = this.data.inputRowMeta.getString(r, this.data.indexOfFieldfilename);
                    if (Utils.isEmpty((CharSequence)this.data.filename)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutputMeta.Log.FileNameEmty", (String[])new String[0]));
                    }
                    if (!this.checkSameFile()) {
                        this.closeFile();
                        this.openNewFile();
                    }
                }
                if (!this.data.KeySet.contains(propkey)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.Key", (String[])new String[]{propkey}));
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.Value", (String[])new String[]{propvalue}));
                    }
                    this.data.pro.setProperty(propkey, propvalue);
                    this.putRow(this.data.outputRowMeta, r);
                    this.incrementLinesOutput();
                    if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                        this.logBasic("linenr " + this.getLinesRead());
                    }
                    this.data.KeySet.add(propkey);
                }
            }
            catch (KettleStepException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyOutputMeta.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.data.outputRowMeta, r, 1L, errorMessage, null, "PROPSOUTPUTO001");
            }
        }
        return true;
    }

    public boolean checkSameFile() throws KettleException {
        return this.data.previousFileName.equals(this.data.filename);
    }

    private void saveProcessingFile() {
        this.data.previousFileName = this.data.filename;
    }

    private void openNewFile() throws KettleException {
        try {
            this.data.pro = new Properties();
            this.data.KeySet.clear();
            this.data.file = KettleVFS.getFileObject((String)this.data.filename, (VariableSpace)this.getTransMeta());
            if (this.meta.isAppend() && this.data.file.exists()) {
                this.data.pro.load(KettleVFS.getInputStream((FileObject)this.data.file));
            }
            this.createParentFolder();
            this.saveProcessingFile();
        }
        catch (Exception e) {
            throw new KettleException("Error opening file [" + this.data.filename + "]!", (Throwable)e);
        }
    }

    private void createParentFolder() throws KettleException {
        if (this.meta.isCreateParentFolder()) {
            FileObject parentfolder = null;
            try {
                parentfolder = this.data.file.getParent();
                if (!parentfolder.exists()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ParentFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
                throw new KettleException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeFile() {
        if (this.data.file == null) {
            return true;
        }
        boolean retval = false;
        OutputStream propsFile = null;
        try {
            propsFile = KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false);
            this.data.pro.store(propsFile, this.environmentSubstitute(this.meta.getComment()));
            if (this.meta.addToResult()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            this.data.KeySet.clear();
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file [" + this.data.file.getName() + "]! :" + e.toString());
            this.setErrors(1L);
        }
        finally {
            if (propsFile != null) {
                try {
                    propsFile.close();
                    propsFile = null;
                }
                catch (Exception exception) {}
            }
            if (this.data.file != null) {
                try {
                    this.data.file.close();
                    this.data.file = null;
                }
                catch (Exception exception) {}
            }
            if (this.data.pro != null) {
                this.data.pro = null;
            }
        }
        return retval;
    }

    public String buildFilename() {
        return this.meta.buildFilename(this, this.getCopy());
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyOutputMeta)smi;
        this.data = (PropertyOutputData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyOutputMeta)smi;
        this.data = (PropertyOutputData)sdi;
        this.closeFile();
        this.setOutputDone();
        super.dispose(smi, sdi);
    }
}

