/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorData;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

public class RowGenerator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RowGeneratorMeta.class;
    private RowGeneratorMeta meta = (RowGeneratorMeta)this.getStepMeta().getStepMetaInterface();
    private RowGeneratorData data;

    public RowGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (RowGeneratorData)stepDataInterface;
    }

    public static final RowMetaAndData buildRow(RowGeneratorMeta meta, List<CheckResultInterface> remarks, String origin) throws KettlePluginException {
        RowMeta rowMeta = new RowMeta();
        Object[] rowData = RowDataUtil.allocateRowData((int)(meta.getFieldName().length + 2));
        int index = 0;
        if (meta.isNeverEnding()) {
            if (!Utils.isEmpty((CharSequence)meta.getRowTimeField())) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaDate(meta.getRowTimeField()));
                rowData[index++] = null;
            }
            if (!Utils.isEmpty((CharSequence)meta.getLastTimeField())) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaDate(meta.getLastTimeField()));
                rowData[index++] = null;
            }
        }
        for (int i = 0; i < meta.getFieldName().length; ++i) {
            int valtype = ValueMetaFactory.getIdForValueMeta((String)meta.getFieldType()[i]);
            if (meta.getFieldName()[i] == null) continue;
            ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)meta.getFieldName()[i], (int)valtype);
            valueMeta.setLength(meta.getFieldLength()[i]);
            valueMeta.setPrecision(meta.getFieldPrecision()[i]);
            valueMeta.setConversionMask(meta.getFieldFormat()[i]);
            valueMeta.setCurrencySymbol(meta.getCurrency()[i]);
            valueMeta.setGroupingSymbol(meta.getGroup()[i]);
            valueMeta.setDecimalSymbol(meta.getDecimal()[i]);
            valueMeta.setOrigin(origin);
            ValueMetaInterface stringMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2);
            if (meta.isSetEmptyString() != null && meta.isSetEmptyString()[i]) {
                rowData[index] = "";
            } else {
                String stringValue = meta.getValue()[i];
                if (Utils.isEmpty((CharSequence)stringValue)) {
                    rowData[index] = null;
                    if (valueMeta.getType() == 0) {
                        String message = BaseMessages.getString(PKG, (String)"RowGenerator.CheckResult.SpecifyTypeError", (String[])new String[]{valueMeta.getName(), stringValue});
                        remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                    }
                } else {
                    try {
                        rowData[index] = valueMeta.convertData(stringMeta, (Object)stringValue);
                    }
                    catch (KettleValueException e) {
                        switch (valueMeta.getType()) {
                            case 1: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Number", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                                break;
                            }
                            case 3: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Date", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                                break;
                            }
                            case 5: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Integer", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                                break;
                            }
                            case 6: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.BigNumber", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                                break;
                            }
                            case 9: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Timestamp", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                                break;
                            }
                            default: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.CheckResult.SpecifyTypeError", (String[])new String[]{valueMeta.getName(), stringValue});
                                remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                            }
                        }
                    }
                }
            }
            rowMeta.addValueMeta(valueMeta);
            ++index;
        }
        return new RowMetaAndData((RowMetaInterface)rowMeta, rowData);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (RowGeneratorMeta)smi;
        this.data = (RowGeneratorData)sdi;
        Object[] r = null;
        boolean retval = true;
        if (this.first) {
            this.first = false;
            this.getRow();
        } else if (this.meta.isNeverEnding() && this.data.delay > 0L) {
            try {
                Thread.sleep(this.data.delay);
            }
            catch (InterruptedException e) {
                throw new KettleException((Throwable)e);
            }
        }
        if (!this.meta.isNeverEnding() && this.data.rowsWritten >= this.data.rowLimit) {
            this.setOutputDone();
            return false;
        }
        r = this.data.outputRowMeta.cloneRow(this.data.outputRowData);
        if (this.meta.isNeverEnding()) {
            this.data.prevDate = this.data.rowDate;
            this.data.rowDate = new Date();
            int index = 0;
            if (!Utils.isEmpty((CharSequence)this.meta.getRowTimeField())) {
                r[index++] = this.data.rowDate;
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getLastTimeField())) {
                r[index++] = this.data.prevDate;
            }
        }
        this.putRow(this.data.outputRowMeta, r);
        ++this.data.rowsWritten;
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"RowGenerator.Log.Wrote.Row", (String[])new String[]{Long.toString(this.data.rowsWritten), this.data.outputRowMeta.getString(r)}));
        }
        if (this.checkFeedback(this.data.rowsWritten) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"RowGenerator.Log.LineNr", (String[])new String[]{Long.toString(this.data.rowsWritten)}));
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.meta = (RowGeneratorMeta)smi;
            this.data = (RowGeneratorData)sdi;
            if (super.init(smi, sdi)) {
                this.data.rowLimit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)-1L);
                this.data.rowsWritten = 0L;
                this.data.delay = Const.toLong((String)this.environmentSubstitute(this.meta.getIntervalInMs()), (long)-1L);
                if (this.data.rowLimit < 0L) {
                    this.logError(BaseMessages.getString(PKG, (String)"RowGenerator.Wrong.RowLimit.Number", (String[])new String[0]));
                    return false;
                }
                ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
                RowMetaAndData outputRow = RowGenerator.buildRow(this.meta, remarks, this.getStepname());
                if (!remarks.isEmpty()) {
                    for (int i = 0; i < remarks.size(); ++i) {
                        CheckResult cr = (CheckResult)remarks.get(i);
                        this.logError(cr.getText());
                    }
                    return false;
                }
                this.data.outputRowData = outputRow.getData();
                this.data.outputRowMeta = outputRow.getRowMeta();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Error initializing step", e);
            return false;
        }
    }

    @Override
    public boolean canProcessOneRow() {
        return true;
    }
}

