/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowsfromresult;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResult;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class RowsFromResultMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RowsFromResult.class;
    private String[] fieldname;
    private int[] type;
    private int[] length;
    private int[] precision;

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String[] name) {
        this.fieldname = name;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        RowsFromResultMeta retval = (RowsFromResultMeta)super.clone();
        int nrFields = this.fieldname.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldname, 0, retval.fieldname, 0, nrFields);
        System.arraycopy(this.type, 0, retval.type, 0, nrFields);
        System.arraycopy(this.length, 0, retval.length, 0, nrFields);
        System.arraycopy(this.precision, 0, retval.precision, 0, nrFields);
        return retval;
    }

    public void allocate(int nrFields) {
        this.fieldname = new String[nrFields];
        this.type = new int[nrFields];
        this.length = new int[nrFields];
        this.precision = new int[nrFields];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>");
        for (int i = 0; i < this.fieldname.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldname[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.type[i])));
            retval.append("        " + XMLHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    private void readData(Node stepnode) {
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            Node line = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            this.fieldname[i] = XMLHandler.getTagValue((Node)line, (String)"name");
            this.type[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)line, (String)"type"));
            this.length[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"length"), (int)-2);
            this.precision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)line, (String)"precision"), (int)-2);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0);
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldname[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.type[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.length[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.precision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RowsFromResultMeta.Exception.ErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldname.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldname[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.type[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.length[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.precision[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RowsFromResultMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldname.length; ++i) {
            ValueMeta v = new ValueMeta(this.fieldname[i], this.type[i], this.length[i], this.precision[i]);
            v.setOrigin(origin);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowsFromResultMeta.CheckResult.StepExpectingNoReadingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowsFromResultMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RowsFromResult(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RowsFromResultData();
    }
}

