/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInput;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesModDummy;

public class ScriptValuesAddedFunctions
extends ScriptableObject {
    public static final long serialVersionUID = 1L;
    public static final int STRING_FUNCTION = 0;
    public static final int NUMERIC_FUNCTION = 1;
    public static final int DATE_FUNCTION = 2;
    public static final int LOGIC_FUNCTION = 3;
    public static final int SPECIAL_FUNCTION = 4;
    public static final int FILE_FUNCTION = 5;
    public static String[] jsFunctionList = new String[]{"appendToFile", "getTransformationName", "writeToLog", "getFiscalDate", "getProcessCount", "ceil", "floor", "abs", "getDayNumber", "isWorkingDay", "fireToDB", "getNextWorkingDay", "quarter", "dateDiff", "dateAdd", "fillString", "isCodepage", "ltrim", "rtrim", "lpad", "rpad", "week", "month", "year", "str2RegExp", "fileExists", "touch", "isRegExp", "date2str", "str2date", "sendMail", "replace", "decode", "isNum", "isDate", "lower", "upper", "str2num", "num2str", "Alert", "setEnvironmentVar", "getEnvironmentVar", "LoadScriptFile", "LoadScriptFromTab", "print", "println", "resolveIP", "trim", "substr", "getVariable", "setVariable", "LuhnCheck", "getDigitsOnly", "indexOf", "getOutputRowMeta", "getInputRowMeta", "createRowCopy", "putRow", "deleteFile", "createFolder", "copyFile", "getFileSize", "isFile", "isFolder", "getShortFilename", "getFileExtension", "getParentFoldername", "getLastModifiedTime", "trunc", "truncDate", "moveFile", "execProcess", "isEmpty", "isMailValid", "escapeXml", "removeDigits", "initCap", "protectXMLCDATA", "unEscapeXml", "escapeSQL", "escapeHtml", "unEscapeHtml", "loadFileContent", "getOcuranceString", "removeCRLF"};

    public static String getDigitsOnly(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.getDigitsOnly((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call getDigitsOnly requires 1 argument.");
    }

    public static boolean LuhnCheck(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        boolean returnCode = false;
        if (ArgList.length == 1) {
            if (!ScriptValuesAddedFunctions.isNull(ArgList) && !ScriptValuesAddedFunctions.isUndefined(ArgList)) {
                try {
                    int sum = 0;
                    int digit = 0;
                    int addend = 0;
                    boolean timesTwo = false;
                    String argstring = Context.toString((Object)ArgList[0]);
                    for (int i = argstring.length() - 1; i >= 0; --i) {
                        digit = Integer.parseInt(argstring.substring(i, i + 1));
                        if (timesTwo) {
                            addend = digit * 2;
                            if (addend > 9) {
                                addend -= 9;
                            }
                        } else {
                            addend = digit;
                        }
                        sum += addend;
                        timesTwo = !timesTwo;
                    }
                    int modulus = sum % 10;
                    if (modulus == 0) {
                        returnCode = true;
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call LuhnCheck requires 1 argument.");
        }
        return returnCode;
    }

    public static int indexOf(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        int returnIndex = -1;
        if (ArgList.length == 2 || ArgList.length == 3) {
            if (!ScriptValuesAddedFunctions.isNull(ArgList) && !ScriptValuesAddedFunctions.isUndefined(ArgList)) {
                String string = Context.toString((Object)ArgList[0]);
                String subString = Context.toString((Object)ArgList[1]);
                int fromIndex = 0;
                if (ArgList.length == 3) {
                    fromIndex = (int)Math.round(Context.toNumber((Object)ArgList[2]));
                }
                returnIndex = string.indexOf(subString, fromIndex);
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call indexOf requires 2 or 3 arguments");
        }
        return returnIndex;
    }

    public static Object getTransformationName(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            String objTranName = Context.toString((Object)actualObject.get("_TransformationName_", actualObject));
            return objTranName;
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static void appendToFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (!ScriptValuesAddedFunctions.isNull(ArgList) && !ScriptValuesAddedFunctions.isUndefined(ArgList)) {
            try {
                FileOutputStream file = new FileOutputStream(Context.toString((Object)ArgList[0]), true);
                DataOutputStream out = new DataOutputStream(file);
                out.writeBytes(Context.toString((Object)ArgList[1]));
                out.flush();
                out.close();
            }
            catch (Exception er) {
                throw Context.reportRuntimeError((String)er.toString());
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call appendToFile requires arguments.");
        }
    }

    public static Object getFiscalDate(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList)) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList)) {
                    return Context.getUndefinedValue();
                }
                Date dIn = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar startDate = Calendar.getInstance();
                Calendar fisStartDate = Calendar.getInstance();
                Calendar fisOffsetDate = Calendar.getInstance();
                startDate.setTime(dIn);
                SimpleDateFormat dfFormatter = new SimpleDateFormat("dd.MM.yyyy");
                String strOffsetDate = Context.toString((Object)ArgList[1]) + String.valueOf(startDate.get(1));
                Date dOffset = (Date)dfFormatter.parseObject(strOffsetDate);
                fisOffsetDate.setTime(dOffset);
                String strFisStartDate = "01.01." + String.valueOf(startDate.get(1) + 1);
                fisStartDate.setTime((Date)dfFormatter.parseObject(strFisStartDate));
                int iDaysToAdd = (int)((startDate.getTimeInMillis() - fisOffsetDate.getTimeInMillis()) / 86400000L);
                fisStartDate.add(5, iDaysToAdd);
                return fisStartDate.getTime();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
        throw Context.reportRuntimeError((String)"The function call getFiscalDate requires 2 arguments.");
    }

    public static double getProcessCount(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                Object scmO = actualObject.get("_step_", actualObject);
                StepInterface scm = (StepInterface)Context.jsToJava((Object)scmO, StepInterface.class);
                String strType = Context.toString((Object)ArgList[0]).toLowerCase();
                if (strType.equals("i")) {
                    return scm.getLinesInput();
                }
                if (strType.equals("o")) {
                    return scm.getLinesOutput();
                }
                if (strType.equals("r")) {
                    return scm.getLinesRead();
                }
                if (strType.equals("u")) {
                    return scm.getLinesUpdated();
                }
                if (strType.equals("w")) {
                    return scm.getLinesWritten();
                }
                if (strType.equals("e")) {
                    return scm.getLinesRejected();
                }
                return 0.0;
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        throw Context.reportRuntimeError((String)"The function call getProcessCount requires 1 argument.");
    }

    public static void writeToLog(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        switch (ArgList.length) {
            case 1: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList) || ScriptValuesAddedFunctions.isUndefined(ArgList)) break;
                    Object scmO = actualObject.get("_step_", actualObject);
                    ScriptValuesMod scm = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    String strMessage = Context.toString((Object)ArgList[0]);
                    scm.logDebug(strMessage);
                }
                catch (Exception scmO) {}
                break;
            }
            case 2: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList) || ScriptValuesAddedFunctions.isUndefined(ArgList)) break;
                    Object scmO = actualObject.get("_step_", actualObject);
                    ScriptValuesMod scm = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    String strType = Context.toString((Object)ArgList[0]).toLowerCase();
                    String strMessage = Context.toString((Object)ArgList[1]);
                    if (strType.equals("b")) {
                        scm.logBasic(strMessage);
                        break;
                    }
                    if (strType.equals("d")) {
                        scm.logDebug(strMessage);
                        break;
                    }
                    if (strType.equals("l")) {
                        scm.logDetailed(strMessage);
                        break;
                    }
                    if (strType.equals("e")) {
                        scm.logError(strMessage);
                        break;
                    }
                    if (strType.equals("m")) {
                        scm.logMinimal(strMessage);
                        break;
                    }
                    if (!strType.equals("r")) break;
                    scm.logRowlevel(strMessage);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw Context.reportRuntimeError((String)"The function call writeToLog requires 1 or 2 arguments.");
            }
        }
    }

    private static boolean isUndefined(Object ArgList) {
        return ScriptValuesAddedFunctions.isUndefined(new Object[]{ArgList}, new int[]{0});
    }

    private static boolean isUndefined(Object[] ArgList, int[] iArrToCheck) {
        for (int i = 0; i < iArrToCheck.length; ++i) {
            if (!ArgList[iArrToCheck[i]].equals(Context.getUndefinedValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(Object ArgList) {
        return ScriptValuesAddedFunctions.isNull(new Object[]{ArgList}, new int[]{0});
    }

    private static boolean isNull(Object[] ArgList) {
        for (int i = 0; i < ArgList.length; ++i) {
            if (ArgList[i] != null && !ArgList[i].equals(null)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(Object[] ArgList, int[] iArrToCheck) {
        for (int i = 0; i < iArrToCheck.length; ++i) {
            if (ArgList[iArrToCheck[i]] != null && !ArgList[iArrToCheck[i]].equals(null)) continue;
            return true;
        }
        return false;
    }

    public static Object abs(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                return new Double(Math.abs(Context.toNumber((Object)ArgList[0])));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)"The function call abs requires 1 argument.");
    }

    public static Object ceil(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return Double.NaN;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                return Math.ceil(Context.toNumber((Object)ArgList[0]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)"The function call ceil requires 1 argument.");
    }

    public static Object floor(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                return new Double(Math.floor(Context.toNumber((Object)ArgList[0])));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)"The function call floor requires 1 argument.");
    }

    public static Object getDayNumber(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dIn = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                String strType = Context.toString((Object)ArgList[1]).toLowerCase();
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                if (strType.equals("y")) {
                    return new Double(startDate.get(6));
                }
                if (strType.equals("m")) {
                    return new Double(startDate.get(5));
                }
                if (strType.equals("w")) {
                    return new Double(startDate.get(7));
                }
                if (strType.equals("wm")) {
                    return new Double(startDate.get(8));
                }
                return new Double(startDate.get(6));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)"The function call getDayNumber requires 2 arguments.");
    }

    public static Object isWorkingDay(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dIn = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                if (startDate.get(7) != 7 && startDate.get(7) != 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)"The function call isWorkingDay requires 1 argument.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fireToDB(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        Object oRC;
        block14: {
            oRC = new Object();
            if (ArgList.length == 2) {
                try {
                    Object scmO = actualObject.get("_step_", actualObject);
                    ScriptValuesMod scm = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    String strDBName = Context.toString((Object)ArgList[0]);
                    String strSQL = Context.toString((Object)ArgList[1]);
                    DatabaseMeta ci = DatabaseMeta.findDatabase(scm.getTransMeta().getDatabases(), (String)strDBName);
                    if (ci == null) {
                        throw Context.reportRuntimeError((String)("Database connection not found: " + strDBName));
                    }
                    ci.shareVariablesWith((VariableSpace)scm);
                    Database db = new Database((LoggingObjectInterface)scm, ci);
                    db.setQueryLimit(0);
                    try {
                        if (scm.getTransMeta().isUsingUniqueConnections()) {
                            Trans trans = scm.getTrans();
                            synchronized (trans) {
                                db.connect(scm.getTrans().getTransactionId(), scm.getPartitionID());
                            }
                        } else {
                            db.connect(scm.getPartitionID());
                        }
                        ResultSet rs = db.openQuery(strSQL);
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        int columnCount = resultSetMetaData.getColumnCount();
                        if (rs != null) {
                            ArrayList<Object[]> list = new ArrayList<Object[]>();
                            while (rs.next()) {
                                Object[] objRow = new Object[columnCount];
                                for (int i = 0; i < columnCount; ++i) {
                                    objRow[i] = rs.getObject(i + 1);
                                }
                                list.add(objRow);
                            }
                            Object[][] resultArr = new Object[list.size()][];
                            list.toArray((T[])resultArr);
                            db.disconnect();
                            return resultArr;
                        }
                        break block14;
                    }
                    catch (Exception er) {
                        throw Context.reportRuntimeError((String)er.toString());
                    }
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)e.toString());
                }
            }
            throw Context.reportRuntimeError((String)"The function call fireToDB requires 2 arguments.");
        }
        return oRC;
    }

    public static Object dateDiff(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 3) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return Context.getUndefinedValue();
                }
                Date dIn1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Date dIn2 = (Date)Context.jsToJava((Object)ArgList[1], Date.class);
                String strType = Context.toString((Object)ArgList[2]).toLowerCase();
                int iRC = 0;
                Calendar startDate = Calendar.getInstance();
                Calendar endDate = Calendar.getInstance();
                startDate.setTime(dIn1);
                endDate.setTime(dIn2);
                long endL = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
                long startL = startDate.getTimeInMillis() + (long)startDate.getTimeZone().getOffset(startDate.getTimeInMillis());
                if (strType.equals("y")) {
                    return new Double(endDate.get(1) - startDate.get(1));
                }
                if (strType.equals("m")) {
                    int iMonthsToAdd = (endDate.get(1) - startDate.get(1)) * 12;
                    return new Double(endDate.get(2) - startDate.get(2) + iMonthsToAdd);
                }
                if (strType.equals("d")) {
                    return new Double((endL - startL) / 86400000L);
                }
                if (strType.equals("wd")) {
                    int iOffset = -1;
                    if (endDate.before(startDate)) {
                        iOffset = 1;
                    }
                    while (iOffset == 1 && endL < startL || iOffset == -1 && endL > startL) {
                        int day = endDate.get(7);
                        if (day != 7 && day != 1) {
                            ++iRC;
                        }
                        endDate.add(5, iOffset);
                        endL = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
                    }
                    return new Double(iRC);
                }
                if (strType.equals("w")) {
                    int iDays = (int)((endL - startL) / 86400000L);
                    return new Double(iDays / 7);
                }
                if (strType.equals("ss")) {
                    return new Double((endL - startL) / 1000L);
                }
                if (strType.equals("mi")) {
                    return new Double((endL - startL) / 60000L);
                }
                if (strType.equals("hh")) {
                    return new Double((endL - startL) / 3600000L);
                }
                return new Double((endL - startL) / 86400000L);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
        throw Context.reportRuntimeError((String)"The function call dateDiff requires 3 arguments.");
    }

    public static Object getNextWorkingDay(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dIn = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                startDate.add(5, 1);
                while (startDate.get(7) == 7 || startDate.get(7) == 1) {
                    startDate.add(5, 1);
                }
                return startDate.getTime();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
        throw Context.reportRuntimeError((String)"The function call getNextWorkingDay requires 1 argument.");
    }

    public static Object dateAdd(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 3) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return Context.getUndefinedValue();
                }
                Date dIn = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                String strType = Context.toString((Object)ArgList[1]).toLowerCase();
                int iValue = (int)Context.toNumber((Object)ArgList[2]);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dIn);
                if (strType.equals("y")) {
                    cal.add(1, iValue);
                } else if (strType.equals("m")) {
                    cal.add(2, iValue);
                } else if (strType.equals("d")) {
                    cal.add(5, iValue);
                } else if (strType.equals("w")) {
                    cal.add(3, iValue);
                } else if (strType.equals("wd")) {
                    int iOffset = 0;
                    while (iOffset < iValue) {
                        cal.add(5, 1);
                        int day = cal.get(7);
                        if (day == 7 || day == 1) continue;
                        ++iOffset;
                    }
                } else if (strType.equals("hh")) {
                    cal.add(10, iValue);
                } else if (strType.equals("mi")) {
                    cal.add(12, iValue);
                } else if (strType.equals("ss")) {
                    cal.add(13, iValue);
                }
                return cal.getTime();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
        throw Context.reportRuntimeError((String)"The function call dateAdd requires 3 arguments.");
    }

    public static String fillString(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return (String)Context.getUndefinedValue();
                }
                String fillChar = Context.toString((Object)ArgList[0]);
                int count = (int)Context.toNumber((Object)ArgList[1]);
                if (fillChar.length() != 1) {
                    throw Context.reportRuntimeError((String)"Please provide a valid Char to the fillString");
                }
                char[] chars = new char[count];
                while (count > 0) {
                    chars[--count] = fillChar.charAt(0);
                }
                return new String(chars);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
        throw Context.reportRuntimeError((String)"The function call fillString requires 2 arguments.");
    }

    public static Object isCodepage(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        boolean bRC = false;
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return Context.getUndefinedValue();
                }
                String strValueToCheck = Context.toString((Object)ArgList[0]);
                String strCodePage = Context.toString((Object)ArgList[1]);
                byte[] bytearray = strValueToCheck.getBytes();
                CharsetDecoder d = Charset.forName(strCodePage).newDecoder();
                CharBuffer r = d.decode(ByteBuffer.wrap(bytearray));
                r.toString();
                bRC = true;
            }
            catch (Exception e) {
                bRC = false;
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call isCodepage requires 2 arguments.");
        }
        return bRC;
    }

    public static String ltrim(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                String strValueToTrim = Context.toString((Object)ArgList[0]);
                return strValueToTrim.replaceAll("^\\s+", "");
            }
            throw Context.reportRuntimeError((String)"The function call ltrim requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("The function call ltrim is not valid : " + e.getMessage()));
        }
    }

    public static String rtrim(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                String strValueToTrim = Context.toString((Object)ArgList[0]);
                return strValueToTrim.replaceAll("\\s+$", "");
            }
            throw Context.reportRuntimeError((String)"The function call rtrim requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("The function call rtrim is not valid : " + e.getMessage()));
        }
    }

    public static String lpad(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 3) {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return (String)Context.getUndefinedValue();
                }
                String valueToPad = Context.toString((Object)ArgList[0]);
                String filler = Context.toString((Object)ArgList[1]);
                int size = (int)Context.toNumber((Object)ArgList[2]);
                while (valueToPad.length() < size) {
                    valueToPad = filler + valueToPad;
                }
                return valueToPad;
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)"The function call lpad requires 3 arguments.");
        }
        return null;
    }

    public static String rpad(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 3) {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return (String)Context.getUndefinedValue();
                }
                String valueToPad = Context.toString((Object)ArgList[0]);
                String filler = Context.toString((Object)ArgList[1]);
                int size = (int)Context.toNumber((Object)ArgList[2]);
                while (valueToPad.length() < size) {
                    valueToPad = valueToPad + filler;
                }
                return valueToPad;
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)"The function call rpad requires 3 arguments.");
        }
        return null;
    }

    public static Object year(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(1));
            }
            throw Context.reportRuntimeError((String)"The function call year requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object month(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(2));
            }
            throw Context.reportRuntimeError((String)"The function call month requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object quarter(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                int iMonth = cal.get(2);
                if (iMonth <= 2) {
                    return new Double(1.0);
                }
                if (iMonth <= 5) {
                    return new Double(2.0);
                }
                if (iMonth <= 8) {
                    return new Double(3.0);
                }
                return new Double(4.0);
            }
            throw Context.reportRuntimeError((String)"The function call quarter requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object week(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(3));
            }
            throw Context.reportRuntimeError((String)"The function call week requires 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object str2RegExp(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String[] strArr = null;
        if (ArgList.length != 2) throw Context.reportRuntimeError((String)"The function call str2RegExp requires 2 arguments.");
        try {
            if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                return null;
            }
            if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                return Context.getUndefinedValue();
            }
            String strToMatch = Context.toString((Object)ArgList[0]);
            Pattern p = Pattern.compile(Context.toString((Object)ArgList[1]));
            Matcher m = p.matcher(strToMatch);
            if (!m.matches() || m.groupCount() <= 0) return strArr;
            strArr = new String[m.groupCount()];
            for (int i = 1; i <= m.groupCount(); ++i) {
                strArr[i - 1] = m.group(i);
            }
            return strArr;
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static void touch(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        block4: {
            try {
                if (ArgList.length == 1 && !ScriptValuesAddedFunctions.isNull(ArgList[0]) && !ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    File file = new File(Context.toString((Object)ArgList[0]));
                    boolean success = file.createNewFile();
                    if (!success) {
                        file.setLastModified(System.currentTimeMillis());
                    }
                    break block4;
                }
                throw Context.reportRuntimeError((String)"The function call touch requires 1 valid argument.");
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    public static Object fileExists(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1 && !ScriptValuesAddedFunctions.isNull(ArgList[0]) && !ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                if (ArgList[0].equals(null)) {
                    return null;
                }
                File file = new File(Context.toString((Object)ArgList[0]));
                return file.isFile();
            }
            throw Context.reportRuntimeError((String)"The function call fileExists requires 1 valid argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object str2date(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        Object oRC = new Object();
        String sArg1 = "";
        String sArg2 = "";
        String sArg3 = "";
        String sArg4 = "";
        switch (ArgList.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"Please provide a valid string to the function call str2date.");
            }
            case 1: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                        return Context.getUndefinedValue();
                    }
                    sArg1 = Context.toString((Object)ArgList[0]);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat();
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not apply local format for " + sArg1 + " : " + e.getMessage()));
                }
            }
            case 2: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return Context.getUndefinedValue();
                    }
                    sArg1 = Context.toString((Object)ArgList[0]);
                    sArg2 = Context.toString((Object)ArgList[1]);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not apply the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage()));
                }
            }
            case 3: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return Context.getUndefinedValue();
                    }
                    sArg1 = Context.toString((Object)ArgList[0]);
                    sArg2 = Context.toString((Object)ArgList[1]);
                    sArg3 = Context.toString((Object)ArgList[2]);
                    if (sArg3.length() != 2) {
                        throw Context.reportRuntimeError((String)("Locale " + sArg3 + " is not 2 characters long."));
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not apply the local format for locale " + sArg3 + " with the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage()));
                }
            }
            case 4: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2, 3})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2, 3})) {
                        return Context.getUndefinedValue();
                    }
                    sArg1 = Context.toString((Object)ArgList[0]);
                    sArg2 = Context.toString((Object)ArgList[1]);
                    sArg3 = Context.toString((Object)ArgList[2]);
                    sArg4 = Context.toString((Object)ArgList[3]);
                    TimeZone tz = TimeZone.getTimeZone(sArg4);
                    if (sArg3.length() != 2) {
                        throw Context.reportRuntimeError((String)("Locale " + sArg3 + " is not 2 characters long."));
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    dfFormatter.setTimeZone(tz);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not apply the local format for locale " + sArg3 + " with the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage()));
                }
            }
            default: {
                throw Context.reportRuntimeError((String)"The function call str2date requires 1, 2, 3, or 4 arguments.");
            }
        }
        return oRC;
    }

    public static Object date2str(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        Object oRC = new Object();
        switch (ArgList.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"Please provide a valid date to the function call date2str.");
            }
            case 1: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList)) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList)) {
                        return Context.getUndefinedValue();
                    }
                    Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                    if (dArg1.equals(null)) {
                        return null;
                    }
                    SimpleDateFormat dfFormatter = new SimpleDateFormat();
                    oRC = dfFormatter.format((Object)dArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)"Could not convert to local format.");
                }
            }
            case 2: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return Context.getUndefinedValue();
                    }
                    Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2);
                    oRC = dfFormatter.format((Object)dArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)"Could not convert to the given format.");
                }
            }
            case 3: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return Context.getUndefinedValue();
                    }
                    Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    String sArg3 = Context.toString((Object)ArgList[2]);
                    if (sArg3.length() != 2) {
                        throw Context.reportRuntimeError((String)"Locale is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3.toLowerCase());
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    oRC = dfFormatter.format(dArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)"Could not convert to the given local format.");
                }
            }
            case 4: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2, 3})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2, 3})) {
                        return Context.getUndefinedValue();
                    }
                    Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    String sArg3 = Context.toString((Object)ArgList[2]);
                    String sArg4 = Context.toString((Object)ArgList[3]);
                    TimeZone tz = TimeZone.getTimeZone(sArg4);
                    if (sArg3.length() != 2) {
                        throw Context.reportRuntimeError((String)"Locale is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3.toLowerCase());
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    dfFormatter.setTimeZone(tz);
                    oRC = dfFormatter.format(dArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)"Could not convert to the given local format.");
                }
            }
            default: {
                throw Context.reportRuntimeError((String)"The function call date2str requires 1, 2, 3, or 4 arguments.");
            }
        }
        return oRC;
    }

    public static Object isRegExp(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length >= 2) {
            if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                return null;
            }
            if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                return Context.getUndefinedValue();
            }
            String strToMatch = Context.toString((Object)ArgList[0]);
            for (int i = 1; i < ArgList.length; ++i) {
                Pattern p = Pattern.compile(Context.toString((Object)ArgList[i]));
                Matcher m = p.matcher(strToMatch);
                if (!m.matches()) continue;
                return new Double(i);
            }
        }
        return new Double(-1.0);
    }

    public static void sendMail(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        boolean debug = false;
        if (ArgList.length == 5) {
            try {
                Properties props = new Properties();
                props.put("mail.smtp.host", ArgList[0]);
                Session session = Session.getDefaultInstance((Properties)props, null);
                session.setDebug(debug);
                MimeMessage msg = new MimeMessage(session);
                InternetAddress addressFrom = new InternetAddress((String)ArgList[1]);
                msg.setFrom((Address)addressFrom);
                String[] strArrRecipients = ((String)ArgList[2]).split(",");
                InternetAddress[] addressTo = new InternetAddress[strArrRecipients.length];
                for (int i = 0; i < strArrRecipients.length; ++i) {
                    addressTo[i] = new InternetAddress(strArrRecipients[i]);
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
                msg.addHeader("MyHeaderName", "myHeaderValue");
                msg.setSubject((String)ArgList[3]);
                msg.setContent(ArgList[4], "text/plain");
                Transport.send((Message)msg);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("sendMail: " + e.toString()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call sendMail requires 5 arguments.");
        }
    }

    public static String upper(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                sRC = Context.toString((Object)ArgList[0]);
                sRC = sRC.toUpperCase();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("The function call upper is not valid : " + e.getMessage()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call upper requires 1 argument.");
        }
        return sRC;
    }

    public static String lower(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                sRC = Context.toString((Object)ArgList[0]);
                sRC = sRC.toLowerCase();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("The function call lower is not valid : " + e.getMessage()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call lower requires 1 argument.");
        }
        return sRC;
    }

    public static String num2str(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        switch (ArgList.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"The function call num2str requires at least 1 argument.");
            }
            case 1: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                        return (String)Context.getUndefinedValue();
                    }
                    double sArg1 = Context.toNumber((Object)ArgList[0]);
                    if (Double.isNaN(sArg1)) {
                        throw Context.reportRuntimeError((String)"The first Argument must be a Number.");
                    }
                    DecimalFormat formatter = new DecimalFormat();
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw Context.reportRuntimeError((String)("Could not apply the given format on the number : " + e.getMessage()));
                }
            }
            case 2: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return (String)Context.getUndefinedValue();
                    }
                    double sArg1 = Context.toNumber((Object)ArgList[0]);
                    if (Double.isNaN(sArg1)) {
                        throw Context.reportRuntimeError((String)"The first Argument must be a Number.");
                    }
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    DecimalFormat formatter = new DecimalFormat(sArg2);
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw Context.reportRuntimeError((String)("Could not apply the given format on the number : " + e.getMessage()));
                }
            }
            case 3: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return (String)Context.getUndefinedValue();
                    }
                    double sArg1 = Context.toNumber((Object)ArgList[0]);
                    if (Double.isNaN(sArg1)) {
                        throw Context.reportRuntimeError((String)"The first Argument must be a Number.");
                    }
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    String sArg3 = Context.toString((Object)ArgList[2]);
                    if (sArg3.length() != 2) break;
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols(EnvUtil.createLocale((String)sArg3.toLowerCase()));
                    DecimalFormat formatter = new DecimalFormat(sArg2, dfs);
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)e.toString());
                }
            }
            default: {
                throw Context.reportRuntimeError((String)"The function call num2str requires 1, 2, or 3 arguments.");
            }
        }
        return sRC;
    }

    public static Object str2num(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        double dRC = 0.0;
        switch (ArgList.length) {
            case 0: {
                throw Context.reportRuntimeError((String)"The function call str2num requires at least 1 argument.");
            }
            case 1: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                        return Context.getUndefinedValue();
                    }
                    if (ArgList[0].equals(null)) {
                        return null;
                    }
                    String sArg1 = Context.toString((Object)ArgList[0]);
                    DecimalFormat formatter = new DecimalFormat();
                    dRC = formatter.parse(Const.ltrim((String)sArg1)).doubleValue();
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not convert the given String : " + e.getMessage()));
                }
            }
            case 2: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return Context.getUndefinedValue();
                    }
                    String sArg1 = Context.toString((Object)ArgList[0]);
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    if (sArg1.equals("null") || sArg2.equals("null")) {
                        return null;
                    }
                    DecimalFormat formatter = new DecimalFormat(sArg2);
                    dRC = formatter.parse(sArg1).doubleValue();
                    return new Double(dRC);
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Could not convert the String with the given format :" + e.getMessage()));
                }
            }
            case 3: {
                try {
                    if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return Context.getUndefinedValue();
                    }
                    String sArg1 = Context.toString((Object)ArgList[0]);
                    String sArg2 = Context.toString((Object)ArgList[1]);
                    String sArg3 = Context.toString((Object)ArgList[2]);
                    if (sArg3.length() == 2) {
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols(EnvUtil.createLocale((String)sArg3.toLowerCase()));
                        DecimalFormat formatter = new DecimalFormat(sArg2, dfs);
                        dRC = formatter.parse(sArg1).doubleValue();
                        return new Double(dRC);
                    }
                    break;
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)e.getMessage());
                }
            }
            default: {
                throw Context.reportRuntimeError((String)"The function call str2num requires 1, 2, or 3 arguments.");
            }
        }
        return new Double(dRC);
    }

    public static Object isNum(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                double sArg1 = Context.toNumber((Object)ArgList[0]);
                if (Double.isNaN(sArg1)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        throw Context.reportRuntimeError((String)"The function call isNum requires 1 argument.");
    }

    public static Object isDate(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Context.jsToJava((Object)ArgList[0], Date.class);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        throw Context.reportRuntimeError((String)"The function call isDate requires 1 argument.");
    }

    public static Object decode(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length >= 2) {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return Context.getUndefinedValue();
                }
                Object objToCompare = ArgList[0];
                for (int i = 1; i < ArgList.length - 1; i += 2) {
                    if (!ArgList[i].equals(objToCompare)) continue;
                    return ArgList[i + 1];
                }
                if (ArgList.length % 2 == 0) {
                    return ArgList[ArgList.length - 1];
                }
                return objToCompare;
            }
            throw Context.reportRuntimeError((String)"The function call decode requires more than 1 argument.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("The function call decode is not valid : " + e.getMessage()));
        }
    }

    public static String replace(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length >= 2 && (ArgList.length - 1) % 2 == 0) {
                if (ScriptValuesAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return (String)Context.getUndefinedValue();
                }
                String objForReplace = Context.toString((Object)ArgList[0]);
                for (int i = 1; i < ArgList.length - 1; i += 2) {
                    objForReplace = objForReplace.replaceAll(Context.toString((Object)ArgList[i]), Context.toString((Object)ArgList[i + 1]));
                }
                return objForReplace;
            }
            throw Context.reportRuntimeError((String)"The function call replace is not valid (wrong number of arguments)");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Function call replace is not valid : " + e.getMessage()));
        }
    }

    public static String Alert(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String strMessage;
        boolean ok;
        SpoonInterface spoon = SpoonFactory.getInstance();
        if (ArgList.length == 1 && spoon != null && !(ok = spoon.messageBox(strMessage = Context.toString((Object)ArgList[0]), "Alert", true, 3))) {
            throw new RuntimeException("Alert dialog cancelled by user.");
        }
        return "";
    }

    public static void setEnvironmentVar(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sArg1 = "";
        String sArg2 = "";
        if (ArgList.length == 2) {
            try {
                sArg1 = Context.toString((Object)ArgList[0]);
                sArg2 = Context.toString((Object)ArgList[1]);
                System.setProperty(sArg1, sArg2);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call setEnvironmentVar requires 2 arguments.");
        }
    }

    public static String getEnvironmentVar(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC;
        block6: {
            sRC = "";
            if (ArgList.length == 1) {
                try {
                    String sArg1 = Context.toString((Object)ArgList[0]);
                    if (System.getProperties().contains(sArg1)) {
                        sRC = System.getProperty(sArg1, "");
                        break block6;
                    }
                    Object scmo = actualObject.get("_step_", actualObject);
                    Object scmO = Context.jsToJava((Object)scmo, StepInterface.class);
                    if (scmO instanceof StepInterface) {
                        StepInterface scm = (StepInterface)Context.jsToJava((Object)scmO, StepInterface.class);
                        sArg1 = Context.toString((Object)ArgList[0]);
                        sRC = scm.getVariable(sArg1, "");
                        break block6;
                    }
                    sRC = "";
                }
                catch (Exception e) {
                    sRC = "";
                }
            } else {
                throw Context.reportRuntimeError((String)"The function call getEnvironmentVar requires 1 argument.");
            }
        }
        return sRC;
    }

    public static String trim(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                sRC = Context.toString((Object)ArgList[0]);
                sRC = Const.trim((String)sRC);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("The function call trim is not valid : " + e.getMessage()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call trim requires 1 argument.");
        }
        return sRC;
    }

    public static String substr(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                sRC = Context.toString((Object)ArgList[0]);
                int from = (int)Math.round(Context.toNumber((Object)ArgList[1]));
                sRC = sRC.substring(from);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("The function call substr is not valid : " + e.getMessage()));
            }
        } else if (ArgList.length == 3) {
            try {
                int strLen;
                int to;
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                sRC = Context.toString((Object)ArgList[0]);
                int from = (int)Math.round(Context.toNumber((Object)ArgList[1]));
                int len = (int)Math.round(Context.toNumber((Object)ArgList[2]));
                if (from < 0) {
                    throw Context.reportRuntimeError((String)"start smaller than 0");
                }
                if (len < 0) {
                    len = 0;
                }
                if ((to = from + len) > (strLen = sRC.length())) {
                    to = strLen;
                }
                sRC = sRC.substring(from, to);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("The function call substr is not valid : " + e.getMessage()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call substr requires 2 or 3 arguments.");
        }
        return sRC;
    }

    public static String resolveIP(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC;
        if (ArgList.length == 2) {
            try {
                InetAddress address = InetAddress.getByName(Context.toString((Object)ArgList[0]));
                sRC = Context.toString((Object)ArgList[1]).equals("IP") ? address.getHostName() : address.getHostAddress();
                if (sRC.equals(Context.toString((Object)ArgList[0]))) {
                    sRC = "-";
                }
            }
            catch (Exception e) {
                sRC = "-";
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call resolveIP requires 2 arguments.");
        }
        return sRC;
    }

    public static void LoadScriptFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        for (int i = 0; i < ArgList.length; ++i) {
            ScriptValuesAddedFunctions.checkAndLoadJSFile(actualContext, actualObject, Context.toString((Object)ArgList[i]));
        }
    }

    public static void LoadScriptFromTab(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            for (int i = 0; i < ArgList.length; ++i) {
                String strToLoad = Context.toString((Object)ArgList[i]);
                String strScript = actualObject.get(strToLoad, actualObject).toString();
                actualContext.evaluateString(actualObject, strScript, "_" + strToLoad + "_", 0, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void print(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        for (int i = 0; i < ArgList.length; ++i) {
            System.out.print(Context.toString((Object)ArgList[i]));
        }
    }

    public static void println(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        ScriptValuesAddedFunctions.print(actualContext, actualObject, ArgList, FunctionContext);
        System.out.println();
    }

    public String getClassName() {
        return "SciptValuesAddedFunctions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndLoadJSFile(Context actualContext, Scriptable eval_scope, String fileName) {
        InputStreamReader inStream = null;
        try {
            inStream = new InputStreamReader(KettleVFS.getInputStream((String)fileName));
            actualContext.evaluateReader(eval_scope, (Reader)inStream, fileName, 1, null);
        }
        catch (FileNotFoundException Signal) {
            Context.reportError((String)("Unable to open file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        catch (WrappedException Signal) {
            Context.reportError((String)("WrappedException while evaluating file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        catch (EvaluatorException Signal) {
            Context.reportError((String)("EvaluatorException while evaluating file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        catch (JavaScriptException Signal) {
            Context.reportError((String)("JavaScriptException while evaluating file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        catch (IOException Signal) {
            Context.reportError((String)("Error while reading file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        catch (KettleFileException Signal) {
            Context.reportError((String)("Error while reading file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")"));
        }
        finally {
            try {
                if (inStream != null) {
                    ((Reader)inStream).close();
                }
            }
            catch (Exception Signal) {}
        }
    }

    public static void setVariable(Context actualContext, Scriptable actualObject, Object[] arguments, Function functionContext) {
        if (arguments.length != 3) {
            throw Context.reportRuntimeError((String)"The function call setVariable requires 3 arguments.");
        }
        Object stepObject = Context.jsToJava((Object)actualObject.get("_step_", actualObject), StepInterface.class);
        if (stepObject instanceof StepInterface) {
            StepInterface step = (StepInterface)stepObject;
            Trans trans = step.getTrans();
            String variableName = Context.toString((Object)arguments[0]);
            String variableValue = Context.toString((Object)arguments[1]);
            VariableScope variableScope = ScriptValuesAddedFunctions.getVariableScope(Context.toString((Object)arguments[2]));
            switch (variableScope) {
                case PARENT: {
                    ScriptValuesAddedFunctions.setParentScopeVariable(trans, variableName, variableValue);
                    break;
                }
                case GRAND_PARENT: {
                    ScriptValuesAddedFunctions.setGrandParentScopeVariable(trans, variableName, variableValue);
                    break;
                }
                case ROOT: {
                    ScriptValuesAddedFunctions.setRootScopeVariable(trans, variableName, variableValue);
                    break;
                }
                case SYSTEM: {
                    ScriptValuesAddedFunctions.setSystemScopeVariable(trans, variableName, variableValue);
                }
            }
        }
    }

    static void setRootScopeVariable(Trans trans, String variableName, String variableValue) {
        trans.setVariable(variableName, variableValue);
        for (VariableSpace parentSpace = trans.getParentVariableSpace(); parentSpace != null; parentSpace = parentSpace.getParentVariableSpace()) {
            parentSpace.setVariable(variableName, variableValue);
        }
    }

    static void setSystemScopeVariable(Trans trans, String variableName, String variableValue) {
        System.setProperty(variableName, variableValue);
        ScriptValuesAddedFunctions.setRootScopeVariable(trans, variableName, variableValue);
    }

    static void setParentScopeVariable(Trans trans, String variableName, String variableValue) {
        trans.setVariable(variableName, variableValue);
        VariableSpace parentSpace = trans.getParentVariableSpace();
        if (parentSpace != null) {
            parentSpace.setVariable(variableName, variableValue);
        }
    }

    static void setGrandParentScopeVariable(Trans trans, String variableName, String variableValue) {
        trans.setVariable(variableName, variableValue);
        VariableSpace parentSpace = trans.getParentVariableSpace();
        if (parentSpace != null) {
            parentSpace.setVariable(variableName, variableValue);
            VariableSpace grandParentSpace = parentSpace.getParentVariableSpace();
            if (grandParentSpace != null) {
                grandParentSpace.setVariable(variableName, variableValue);
            }
        }
    }

    static VariableScope getVariableScope(String codeOfScope) {
        switch (codeOfScope) {
            case "s": {
                return VariableScope.SYSTEM;
            }
            case "r": {
                return VariableScope.ROOT;
            }
            case "p": {
                return VariableScope.PARENT;
            }
            case "g": {
                return VariableScope.GRAND_PARENT;
            }
        }
        throw Context.reportRuntimeError((String)"The argument type of function call setVariable should either be \"s\", \"r\", \"p\", or \"g\".");
    }

    public static String getVariable(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String sRC = "";
        String sArg1 = "";
        String sArg2 = "";
        if (ArgList.length == 2) {
            try {
                Object scmo = actualObject.get("_step_", actualObject);
                Object scmO = Context.jsToJava((Object)scmo, StepInterface.class);
                if (scmO instanceof StepInterface) {
                    StepInterface scm = (StepInterface)Context.jsToJava((Object)scmO, StepInterface.class);
                    sArg1 = Context.toString((Object)ArgList[0]);
                    sArg2 = Context.toString((Object)ArgList[1]);
                    return scm.getVariable(sArg1, sArg2);
                }
                sArg2 = Context.toString((Object)ArgList[1]);
                return sArg2;
            }
            catch (Exception e) {
                sRC = "";
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call getVariable requires 2 arguments.");
        }
        return sRC;
    }

    public static RowMetaInterface getOutputRowMeta(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 0) {
            try {
                Object scmO = actualObject.get("_step_", actualObject);
                try {
                    ScriptValuesMod scm = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    return scm.getOutputRowMeta();
                }
                catch (Exception e) {
                    ScriptValuesModDummy scm = (ScriptValuesModDummy)Context.jsToJava((Object)scmO, ScriptValuesModDummy.class);
                    return scm.getOutputRowMeta();
                }
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Unable to get the output row metadata because of an error: " + Const.CR + e.toString()));
            }
        }
        throw Context.reportRuntimeError((String)"The function call getOutputRowMeta doesn't require arguments.");
    }

    public static RowMetaInterface getInputRowMeta(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 0) {
            try {
                Object scmO = actualObject.get("_step_", actualObject);
                try {
                    ScriptValuesMod scm = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    return scm.getInputRowMeta();
                }
                catch (Exception e) {
                    ScriptValuesModDummy scm = (ScriptValuesModDummy)Context.jsToJava((Object)scmO, ScriptValuesModDummy.class);
                    return scm.getInputRowMeta();
                }
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Unable to get the input row metadata because of an error: " + Const.CR + e.toString()));
            }
        }
        throw Context.reportRuntimeError((String)"The function call getInputRowMeta doesn't require arguments.");
    }

    public static Object[] createRowCopy(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                int newSize = (int)Math.round(Context.toNumber((Object)ArgList[0]));
                Object scmO = actualObject.get("row", actualObject);
                Object[] row = (Object[])Context.jsToJava((Object)scmO, new Object[0].getClass());
                return RowDataUtil.createResizedCopy((Object[])row, (int)newSize);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Unable to create a row copy: " + Const.CR + e.toString()));
            }
        }
        throw Context.reportRuntimeError((String)"The function call createRowCopy requires a single arguments : the new size of the row");
    }

    public static void putRow(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                Object[] newRow = (Object[])Context.jsToJava((Object)ArgList[0], new Object[0].getClass());
                Object scmO = actualObject.get("_step_", actualObject);
                try {
                    ScriptValuesMod step = (ScriptValuesMod)Context.jsToJava((Object)scmO, ScriptValuesMod.class);
                    step.putRow(step.getOutputRowMeta(), newRow);
                }
                catch (Exception e) {
                    ScriptValuesModDummy step = (ScriptValuesModDummy)Context.jsToJava((Object)scmO, ScriptValuesModDummy.class);
                    step.putRow(step.getOutputRowMeta(), newRow);
                }
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Unable to pass the new row to the next step(s) because of an error: " + Const.CR + e.toString()));
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call putRow requires 1 argument : the output row data (Object[])");
        }
    }

    public static void deleteFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        block16: {
            try {
                if (ArgList.length == 1 && !ScriptValuesAddedFunctions.isNull(ArgList[0]) && !ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    FileObject fileObject = null;
                    try {
                        fileObject = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                        if (fileObject.exists()) {
                            if (fileObject.getType() == FileType.FILE && !fileObject.delete()) {
                                Context.reportRuntimeError((String)("We can not delete file [" + Context.toString((Object)ArgList[0]) + "]!"));
                            }
                        } else {
                            Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        throw Context.reportRuntimeError((String)"The function call deleteFile is not valid.");
                    }
                    finally {
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw Context.reportRuntimeError((String)"The function call deleteFile is not valid.");
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    public static void createFolder(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        block15: {
            try {
                if (ArgList.length == 1 && !ScriptValuesAddedFunctions.isNull(ArgList[0]) && !ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    FileObject fileObject = null;
                    try {
                        fileObject = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                        if (!fileObject.exists()) {
                            fileObject.createFolder();
                        } else {
                            Context.reportRuntimeError((String)("folder [" + Context.toString((Object)ArgList[0]) + "] already exist!"));
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        throw Context.reportRuntimeError((String)"The function call createFolder is not valid.");
                    }
                    finally {
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw Context.reportRuntimeError((String)"The function call createFolder is not valid.");
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    public static void copyFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        block23: {
            try {
                if (!(ArgList.length != 3 || ScriptValuesAddedFunctions.isNull(ArgList[0]) || ScriptValuesAddedFunctions.isNull(ArgList[1]) || ScriptValuesAddedFunctions.isUndefined(ArgList[0]) || ScriptValuesAddedFunctions.isUndefined(ArgList[1]))) {
                    FileObject fileSource = null;
                    FileObject fileDestination = null;
                    try {
                        fileSource = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                        fileDestination = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[1]));
                        if (fileSource.exists()) {
                            if (fileSource.getType() == FileType.FILE) {
                                boolean destinationExists;
                                boolean overwrite = false;
                                if (!ArgList[1].equals(null)) {
                                    overwrite = Context.toBoolean((Object)ArgList[2]);
                                }
                                if ((destinationExists = fileDestination.exists()) && overwrite || !destinationExists) {
                                    FileUtil.copyContent((FileObject)fileSource, (FileObject)fileDestination);
                                }
                            }
                        } else {
                            Context.reportRuntimeError((String)("file to copy [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        throw Context.reportRuntimeError((String)("The function call copyFile throw an error : " + e.toString()));
                    }
                    finally {
                        if (fileSource != null) {
                            try {
                                fileSource.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileDestination != null) {
                            try {
                                fileDestination.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw Context.reportRuntimeError((String)"The function call copyFileis not valid.");
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getFileSize(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length != 1 || ScriptValuesAddedFunctions.isNull(ArgList[0]) || ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getFileSize is not valid.");
        if (ArgList[0].equals(null)) {
            return 0.0;
        }
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
            long filesize = 0L;
            if (file.exists()) {
                if (file.getType().equals((Object)FileType.FILE)) {
                    filesize = file.getContent().getSize();
                } else {
                    Context.reportRuntimeError((String)("[" + Context.toString((Object)ArgList[0]) + "] is not a file!"));
                }
            } else {
                Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
            }
            double d = filesize;
            return d;
        }
        catch (IOException e) {
            throw Context.reportRuntimeError((String)("The function call getFileSize throw an error : " + e.toString()));
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
        }
        {
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 1) throw Context.reportRuntimeError((String)"The function call isFile is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call isFile is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call isFile is not valid.");
            if (ArgList[0].equals(null)) {
                return false;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                boolean isafile = false;
                if (file.exists()) {
                    if (file.getType().equals((Object)FileType.FILE)) {
                        isafile = true;
                    } else {
                        Context.reportRuntimeError((String)("[" + Context.toString((Object)ArgList[0]) + "] is not a file!"));
                    }
                } else {
                    Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                boolean bl = isafile;
                return bl;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call is File throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFolder(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 1) throw Context.reportRuntimeError((String)"The function call isFolder is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call isFolder is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call isFolder is not valid.");
            if (ArgList[0].equals(null)) {
                return false;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                boolean isafolder = false;
                if (file.exists()) {
                    if (file.getType().equals((Object)FileType.FOLDER)) {
                        isafolder = true;
                    } else {
                        Context.reportRuntimeError((String)("[" + Context.toString((Object)ArgList[0]) + "] is not a folder!"));
                    }
                } else {
                    Context.reportRuntimeError((String)("folder [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                boolean bl = isafolder;
                return bl;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call isFolder throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getShortFilename(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 1) throw Context.reportRuntimeError((String)"The function call getShortFilename is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getShortFilename is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getShortFilename is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                String Filename = null;
                if (file.exists()) {
                    Filename = file.getName().getBaseName().toString();
                } else {
                    Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                String string = Filename;
                return string;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call getShortFilename throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileExtension(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 1) throw Context.reportRuntimeError((String)"The function call getFileExtension is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getFileExtension is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getFileExtension is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                String Extension = null;
                if (file.exists()) {
                    Extension = file.getName().getExtension().toString();
                } else {
                    Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                String string = Extension;
                return string;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call getFileExtension throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getParentFoldername(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 1) throw Context.reportRuntimeError((String)"The function call getParentFoldername is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getParentFoldername is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getParentFoldername is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                String foldername = null;
                if (file.exists()) {
                    foldername = KettleVFS.getFilename((FileObject)file.getParent());
                } else {
                    Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                String string = foldername;
                return string;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call getParentFoldername throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLastModifiedTime(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length != 2) throw Context.reportRuntimeError((String)"The function call getLastModifiedTime is not valid.");
            if (ScriptValuesAddedFunctions.isNull(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getLastModifiedTime is not valid.");
            if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) throw Context.reportRuntimeError((String)"The function call getLastModifiedTime is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                String dateformat = Context.toString((Object)ArgList[1]);
                if (ScriptValuesAddedFunctions.isNull(dateformat)) {
                    dateformat = "yyyy-MM-dd";
                }
                String lastmodifiedtime = null;
                if (file.exists()) {
                    Date lastmodifiedtimedate = new Date(file.getContent().getLastModifiedTime());
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                    lastmodifiedtime = dateFormat.format(lastmodifiedtimedate);
                } else {
                    Context.reportRuntimeError((String)("file [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                }
                String string = lastmodifiedtime;
                return string;
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("The function call getLastModifiedTime throw an error : " + e.toString()));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object trunc(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Double dArg1 = (Double)Context.jsToJava((Object)ArgList[0], Double.class);
                return Math.floor(dArg1);
            }
            throw Context.reportRuntimeError((String)"The function call trunc requires 1 argument, a number.");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static Object truncDate(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        try {
            if (ArgList.length == 2) {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return Context.getUndefinedValue();
                }
                Date dArg1 = (Date)Context.jsToJava((Object)ArgList[0], Date.class);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                Integer level = (Integer)Context.jsToJava((Object)ArgList[1], Integer.class);
                switch (level) {
                    case 5: {
                        cal.set(2, 1);
                    }
                    case 4: {
                        cal.set(5, 1);
                    }
                    case 3: {
                        cal.set(11, 0);
                    }
                    case 2: {
                        cal.set(12, 0);
                    }
                    case 1: {
                        cal.set(13, 0);
                    }
                    case 0: {
                        cal.set(14, 0);
                        break;
                    }
                    default: {
                        throw Context.reportRuntimeError((String)"Argument of TRUNC of date has to be between 0 and 5");
                    }
                }
                return cal.getTime();
            }
            throw Context.reportRuntimeError((String)"The function call truncDate requires 2 arguments: a date and a level (int)");
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
    }

    public static void moveFile(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        block23: {
            try {
                if (!(ArgList.length != 3 || ScriptValuesAddedFunctions.isNull(ArgList[0]) || ScriptValuesAddedFunctions.isNull(ArgList[1]) || ScriptValuesAddedFunctions.isUndefined(ArgList[0]) || ScriptValuesAddedFunctions.isUndefined(ArgList[1]))) {
                    FileObject fileSource = null;
                    FileObject fileDestination = null;
                    try {
                        fileSource = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[0]));
                        fileDestination = KettleVFS.getFileObject((String)Context.toString((Object)ArgList[1]));
                        if (fileSource.exists()) {
                            if (fileSource.getType() == FileType.FILE) {
                                boolean destinationExists;
                                boolean overwrite = false;
                                if (!ArgList[1].equals(null)) {
                                    overwrite = Context.toBoolean((Object)ArgList[2]);
                                }
                                if ((destinationExists = fileDestination.exists()) && overwrite || !destinationExists) {
                                    fileSource.moveTo(fileDestination);
                                }
                            }
                        } else {
                            Context.reportRuntimeError((String)("file to move [" + Context.toString((Object)ArgList[0]) + "] can not be found!"));
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        throw Context.reportRuntimeError((String)("The function call moveFile throw an error : " + e.toString()));
                    }
                    finally {
                        if (fileSource != null) {
                            try {
                                fileSource.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileDestination != null) {
                            try {
                                fileDestination.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw Context.reportRuntimeError((String)"The function call copyFile is not valid.");
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)e.toString());
            }
        }
    }

    public static String execProcess(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        String retval = null;
        if (!ScriptValuesAddedFunctions.isNull(ArgList) && !ScriptValuesAddedFunctions.isUndefined(ArgList)) {
            Process processrun = null;
            try {
                String ligne = "";
                StringBuilder buffer = new StringBuilder();
                processrun = Runtime.getRuntime().exec(Context.toString((Object)ArgList[0]));
                BufferedReader br = new BufferedReader(new InputStreamReader(processrun.getInputStream()));
                while ((ligne = br.readLine()) != null) {
                    buffer.append(ligne);
                }
                retval = buffer.toString();
            }
            catch (Exception er) {
                throw Context.reportRuntimeError((String)er.toString());
            }
            finally {
                if (processrun != null) {
                    processrun.destroy();
                }
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call execProcess is not valid.");
        }
        return retval;
    }

    public static Boolean isEmpty(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    throw new Exception(ArgList[0] + " is  undefined!");
                }
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return Boolean.TRUE;
                }
                if (Context.toString((Object)ArgList[0]).length() == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Error in isEmpty function: " + e.getMessage()));
            }
        }
        throw Context.reportRuntimeError((String)"The function call isEmpty is not valid");
    }

    public static Boolean isMailValid(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            Boolean isValid;
            try {
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    throw new Exception(ArgList[0] + " is  undefined!");
                }
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return Boolean.FALSE;
                }
                if (Context.toString((Object)ArgList[0]).length() == 0) {
                    return Boolean.FALSE;
                }
                String email = Context.toString((Object)ArgList[0]);
                if (email.indexOf(64) == -1 || email.indexOf(46) == -1) {
                    return Boolean.FALSE;
                }
                isValid = Boolean.TRUE;
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Error in isMailValid function: " + e.getMessage()));
            }
            return isValid;
        }
        throw Context.reportRuntimeError((String)"The function call isMailValid is not valid");
    }

    public static String escapeXml(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.escapeXML((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call escapeXml requires 1 argument.");
    }

    public static String escapeHtml(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.escapeHtml((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call escapeHtml requires 1 argument.");
    }

    public static String unEscapeHtml(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.unEscapeHtml((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call unEscapeHtml requires 1 argument.");
    }

    public static String unEscapeXml(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.unEscapeXml((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call unEscapeXml requires 1 argument.");
    }

    public static String escapeSQL(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.escapeSQL((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call escapeSQL requires 1 argument.");
    }

    public static String protectXMLCDATA(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.protectXMLCDATA((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call protectXMLCDATA requires 1 argument.");
    }

    public static String removeDigits(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.removeDigits((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call removeDigits requires 1 argument.");
    }

    public static String initCap(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            return Const.initCap((String)Context.toString((Object)ArgList[0]));
        }
        throw Context.reportRuntimeError((String)"The function call initCap requires 1 argument.");
    }

    public static Object loadFileContent(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        Object oRC = new Object();
        try {
            switch (ArgList.length) {
                case 0: {
                    throw Context.reportRuntimeError((String)"Please provide a filename to the function call loadFileContent.");
                }
                case 1: {
                    try {
                        if (ScriptValuesAddedFunctions.isNull(ArgList)) {
                            return null;
                        }
                        if (ScriptValuesAddedFunctions.isUndefined(ArgList)) {
                            return Context.getUndefinedValue();
                        }
                        oRC = LoadFileInput.getTextFileContent(Context.toString((Object)ArgList[0]), null);
                        break;
                    }
                    catch (Exception e) {
                        throw Context.reportRuntimeError((String)("The function call loadFileContent throw an error : " + e.toString()));
                    }
                }
                case 2: {
                    try {
                        if (ArgList[0].equals(null)) {
                            return null;
                        }
                        if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                            return Context.getUndefinedValue();
                        }
                        String encoding = null;
                        if (!ScriptValuesAddedFunctions.isUndefined(ArgList[1]) && !ArgList[1].equals(null)) {
                            encoding = Context.toString((Object)ArgList[1]);
                        }
                        oRC = LoadFileInput.getTextFileContent(Context.toString((Object)ArgList[0]), encoding);
                        break;
                    }
                    catch (Exception e) {
                        throw Context.reportRuntimeError((String)("The function call loadFileContent throw an error : " + e.toString()));
                    }
                }
                default: {
                    throw Context.reportRuntimeError((String)"The function call loadFileContentrequires 1 ou 2 arguments.");
                }
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)e.toString());
        }
        return oRC;
    }

    public static int getOcuranceString(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        int nr = 0;
        if (ArgList.length == 2) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return 0;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (Integer)Context.getUndefinedValue();
                }
                if (ScriptValuesAddedFunctions.isNull(ArgList[1])) {
                    return 0;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[1])) {
                    return (Integer)Context.getUndefinedValue();
                }
                String string = Context.toString((Object)ArgList[0]);
                String searchFor = Context.toString((Object)ArgList[1]);
                nr = Const.getOcuranceString((String)string, (String)searchFor);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)"The function call getOcuranceString is not valid");
            }
        } else {
            throw Context.reportRuntimeError((String)"The function call getOcuranceString is not valid");
        }
        return nr;
    }

    public static String removeCRLF(Context actualContext, Scriptable actualObject, Object[] ArgList, Function FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptValuesAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptValuesAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)Context.getUndefinedValue();
                }
                return Const.removeCRLF((String)Context.toString((Object)ArgList[0]));
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)"The function call removeCRLF is not valid");
            }
        }
        throw Context.reportRuntimeError((String)"The function call removeCRLF is not valid");
    }

    static enum VariableScope {
        SYSTEM,
        ROOT,
        PARENT,
        GRAND_PARENT;

    }
}

