/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.socketwriter;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.socketwriter.SocketWriterData;
import org.pentaho.di.trans.steps.socketwriter.SocketWriterMeta;

public class SocketWriter
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SocketWriterMeta.class;
    private SocketWriterMeta meta;
    private SocketWriterData data;

    public SocketWriter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SocketWriterMeta)smi;
        this.data = (SocketWriterData)sdi;
        try {
            if (this.first) {
                int bufferSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBufferSize()), (int)1000);
                this.data.clientSocket = this.data.serverSocket.accept();
                this.data.outputStream = this.meta.isCompressed() ? new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(this.data.clientSocket.getOutputStream()), bufferSize)) : new DataOutputStream(new BufferedOutputStream(this.data.clientSocket.getOutputStream(), bufferSize));
                this.data.flushInterval = Const.toInt((String)this.environmentSubstitute(this.meta.getFlushInterval()), (int)4000);
            }
        }
        catch (Exception e) {
            this.logError("Error accepting from socket : " + e.toString());
            this.logError("Stack trace: " + Const.CR + Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            if (this.data.clientSocket != null) {
                try {
                    this.data.clientSocket.shutdownInput();
                    this.data.clientSocket.shutdownOutput();
                    this.data.clientSocket.close();
                    this.logError("Closed connection to SocketWriter");
                }
                catch (IOException e1) {
                    this.logError("Failed to close connection to SocketWriter");
                }
            }
            return false;
        }
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            if (this.first) {
                this.getInputRowMeta().writeMeta(this.data.outputStream);
                this.first = false;
            }
            this.getInputRowMeta().writeData(this.data.outputStream, r);
            this.incrementLinesOutput();
            if (this.getLinesOutput() > 0L && this.data.flushInterval > 0 && this.getLinesOutput() % (long)this.data.flushInterval == 0L) {
                this.data.outputStream.flush();
            }
        }
        catch (Exception e) {
            this.logError("Error writing to socket : " + e.toString());
            this.logError("Failing row : " + this.getInputRowMeta().getString(r));
            this.logError("Stack trace: " + Const.CR + Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SocketWriter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SocketWriterMeta)smi;
        this.data = (SocketWriterData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.serverSocketPort = Integer.parseInt(this.environmentSubstitute(this.meta.getPort()));
                this.data.serverSocket = this.getTrans().getSocketRepository().openServerSocket(this.data.serverSocketPort, this.getTransMeta().getName() + " - " + this.toString());
                return true;
            }
            catch (Exception e) {
                this.logError("Error creating server socket: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.outputStream != null) {
            try {
                this.data.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.clientSocket != null && !this.data.clientSocket.isClosed()) {
            try {
                this.data.clientSocket.shutdownInput();
                this.data.clientSocket.shutdownOutput();
                this.data.clientSocket.close();
                if (this.log.isDetailed()) {
                    this.logDetailed("Closed connection to SocketWriter");
                }
            }
            catch (IOException e1) {
                this.logError("Failed to close connection to SocketWriter");
            }
        }
        if (this.data.serverSocket != null && !this.data.serverSocket.isClosed()) {
            try {
                this.data.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.getTrans().getSocketRepository().releaseSocket(this.data.serverSocketPort);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

