/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sort.SortRows;
import org.pentaho.di.trans.steps.sort.SortRowsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SortRows.Injection.", groups={"FIELDS"})
public class SortRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SortRowsMeta.class;
    @Injection(name="NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="SORT_ASCENDING", group="FIELDS")
    private boolean[] ascending;
    @Injection(name="IGNORE_CASE", group="FIELDS")
    private boolean[] caseSensitive;
    @Injection(name="COLLATOR_ENABLED", group="FIELDS")
    private boolean[] collatorEnabled;
    @Injection(name="COLLATOR_STRENGTH", group="FIELDS")
    private int[] collatorStrength;
    @Injection(name="PRESORTED", group="FIELDS")
    private boolean[] preSortedField;
    private List<String> groupFields;
    @Injection(name="SORT_DIRECTORY")
    private String directory;
    @Injection(name="SORT_FILE_PREFIX")
    private String prefix;
    @Injection(name="SORT_SIZE_ROWS")
    private String sortSize;
    @Injection(name="FREE_MEMORY_TRESHOLD")
    private String freeMemoryLimit;
    @Injection(name="ONLY_PASS_UNIQUE_ROWS")
    private boolean onlyPassingUniqueRows;
    @Injection(name="COMPRESS_TEMP_FILES")
    private boolean compressFiles;
    private String compressFilesVariable;

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.ascending = new boolean[nrfields];
        this.caseSensitive = new boolean[nrfields];
        this.collatorEnabled = new boolean[nrfields];
        this.collatorStrength = new int[nrfields];
        this.preSortedField = new boolean[nrfields];
        this.groupFields = null;
    }

    @Override
    public Object clone() {
        SortRowsMeta retval = (SortRowsMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrfields);
        System.arraycopy(this.ascending, 0, retval.ascending, 0, nrfields);
        System.arraycopy(this.caseSensitive, 0, retval.caseSensitive, 0, nrfields);
        System.arraycopy(this.collatorEnabled, 0, retval.collatorEnabled, 0, nrfields);
        System.arraycopy(this.collatorStrength, 0, retval.collatorStrength, 0, nrfields);
        System.arraycopy(this.preSortedField, 0, retval.preSortedField, 0, nrfields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.directory = XMLHandler.getTagValue((Node)stepnode, (String)"directory");
            this.prefix = XMLHandler.getTagValue((Node)stepnode, (String)"prefix");
            this.sortSize = XMLHandler.getTagValue((Node)stepnode, (String)"sort_size");
            this.freeMemoryLimit = XMLHandler.getTagValue((Node)stepnode, (String)"free_memory");
            this.compressFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"compress"));
            this.compressFilesVariable = XMLHandler.getTagValue((Node)stepnode, (String)"compress_variable");
            this.onlyPassingUniqueRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"unique_rows"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            String defaultStrength = Integer.toString(this.getDefaultCollationStrength());
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                String asc = XMLHandler.getTagValue((Node)fnode, (String)"ascending");
                this.ascending[i] = "Y".equalsIgnoreCase(asc);
                String sens = XMLHandler.getTagValue((Node)fnode, (String)"case_sensitive");
                String coll = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"collator_enabled"), (String)"N");
                this.caseSensitive[i] = Utils.isEmpty((CharSequence)sens) || "Y".equalsIgnoreCase(sens);
                this.collatorEnabled[i] = "Y".equalsIgnoreCase(coll);
                this.collatorStrength[i] = Integer.parseInt(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"collator_strength"), (String)defaultStrength));
                String presorted = XMLHandler.getTagValue((Node)fnode, (String)"presorted");
                this.preSortedField[i] = "Y".equalsIgnoreCase(presorted);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        this.sortSize = "1000000";
        this.freeMemoryLimit = null;
        this.compressFiles = false;
        this.compressFilesVariable = null;
        this.onlyPassingUniqueRows = false;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.caseSensitive[i] = true;
            this.collatorEnabled[i] = false;
            this.collatorStrength[i] = 0;
            this.preSortedField[i] = false;
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(256);
        retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sort_size", (String)this.sortSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"free_memory", (String)this.freeMemoryLimit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compress", (boolean)this.compressFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compress_variable", (String)this.compressFilesVariable));
        retval.append("      ").append(XMLHandler.addTagValue((String)"unique_rows", (boolean)this.onlyPassingUniqueRows));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ascending", (boolean)this.ascending[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"case_sensitive", (boolean)this.caseSensitive[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"collator_enabled", (boolean)this.collatorEnabled[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"collator_strength", (int)this.collatorStrength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"presorted", (boolean)this.preSortedField[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            this.sortSize = rep.getStepAttributeString(id_step, "sort_size");
            this.freeMemoryLimit = rep.getStepAttributeString(id_step, "free_memory");
            this.compressFiles = rep.getStepAttributeBoolean(id_step, "compress");
            this.compressFilesVariable = rep.getStepAttributeString(id_step, "compress_variable");
            this.onlyPassingUniqueRows = rep.getStepAttributeBoolean(id_step, "unique_rows");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            String defaultStrength = Integer.toString(this.getDefaultCollationStrength());
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.ascending[i] = rep.getStepAttributeBoolean(id_step, i, "field_ascending");
                this.caseSensitive[i] = rep.getStepAttributeBoolean(id_step, i, "field_case_sensitive", true);
                this.collatorEnabled[i] = rep.getStepAttributeBoolean(id_step, i, "field_collator_enabled", false);
                this.collatorStrength[i] = Integer.parseInt(Const.NVL((String)rep.getStepAttributeString(id_step, i, "field_collator_strength"), (String)defaultStrength));
                this.preSortedField[i] = rep.getStepAttributeBoolean(id_step, i, "field_presorted", false);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    int getDefaultCollationStrength() {
        return this.getDefaultCollationStrength(Locale.getDefault());
    }

    int getDefaultCollationStrength(Locale aLocale) {
        Collator curDefCollator;
        int defaultStrength = 3;
        if (aLocale != null && (curDefCollator = Collator.getInstance(aLocale)) != null) {
            defaultStrength = curDefCollator.getStrength();
        }
        return defaultStrength;
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            rep.saveStepAttribute(id_transformation, id_step, "sort_size", this.sortSize);
            rep.saveStepAttribute(id_transformation, id_step, "free_memory", this.freeMemoryLimit);
            rep.saveStepAttribute(id_transformation, id_step, "compress", this.compressFiles);
            rep.saveStepAttribute(id_transformation, id_step, "compress_variable", this.compressFilesVariable);
            rep.saveStepAttribute(id_transformation, id_step, "unique_rows", this.onlyPassingUniqueRows);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ascending", this.ascending[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_case_sensitive", this.caseSensitive[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_collator_enabled", this.collatorEnabled[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_collator_strength", this.collatorStrength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_presorted", this.preSortedField[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            int idx = inputRowMeta.indexOfValue(this.fieldName[i]);
            if (idx < 0) continue;
            ValueMetaInterface valueMeta = inputRowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(!this.ascending[i]);
            valueMeta.setCaseInsensitive(!this.caseSensitive[i]);
            valueMeta.setCollatorDisabled(!this.collatorEnabled[i]);
            valueMeta.setCollatorStrength(this.collatorStrength[i]);
            valueMeta.setStorageType(0);
            valueMeta.setStorageMetadata(null);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.SortKeysNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.AllSortKeysFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoSortKeysEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            String realDirectory = transMeta.environmentSubstitute(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryExists", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExistsButNoDirectory", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryNotExists", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SortRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SortRowsData();
    }

    public String getSortSize() {
        return this.sortSize;
    }

    public void setSortSize(String sortSize) {
        this.sortSize = sortSize;
    }

    public boolean getCompressFiles() {
        return this.compressFiles;
    }

    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    public boolean isOnlyPassingUniqueRows() {
        return this.onlyPassingUniqueRows;
    }

    public void setOnlyPassingUniqueRows(boolean onlyPassingUniqueRows) {
        this.onlyPassingUniqueRows = onlyPassingUniqueRows;
    }

    public String getCompressFilesVariable() {
        return this.compressFilesVariable;
    }

    public void setCompressFilesVariable(String compressFilesVariable) {
        this.compressFilesVariable = compressFilesVariable;
    }

    public boolean[] getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean[] caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean[] getCollatorEnabled() {
        return this.collatorEnabled;
    }

    public void setCollatorEnabled(boolean[] collatorEnabled) {
        this.collatorEnabled = collatorEnabled;
    }

    public int[] getCollatorStrength() {
        return this.collatorStrength;
    }

    public void setCollatorStrength(int[] collatorStrength) {
        this.collatorStrength = collatorStrength;
    }

    public String getFreeMemoryLimit() {
        return this.freeMemoryLimit;
    }

    public void setFreeMemoryLimit(String freeMemoryLimit) {
        this.freeMemoryLimit = freeMemoryLimit;
    }

    public boolean[] getPreSortedField() {
        return this.preSortedField;
    }

    public void setPreSortedField(boolean[] preSorted) {
        this.preSortedField = preSorted;
    }

    public List<String> getGroupFields() {
        if (this.groupFields == null) {
            for (int i = 0; i < this.preSortedField.length; ++i) {
                if (!this.preSortedField[i]) continue;
                if (this.groupFields == null) {
                    this.groupFields = new ArrayList<String>();
                }
                this.groupFields.add(this.fieldName[i]);
            }
        }
        return this.groupFields;
    }

    public boolean isGroupSortEnabled() {
        return this.getGroupFields() != null;
    }
}

