/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableagilemart;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.OrderedFileRegistry;
import org.pentaho.metadata.registry.RegistryFactory;
import org.pentaho.metadata.registry.util.RegistryUtil;

public class AgileMartUtil {
    public void updateMetadata(ProvidesDatabaseConnectionInformation dpci, long rowCount) {
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        if (registry == null) {
            try {
                registry = new OrderedFileRegistry();
                ((OrderedFileRegistry)registry).setFilePath(Const.getKettleDirectory() + File.separator + "registry.xml");
                factory.setMetadataRegistry(registry);
                registry.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RegistryUtil util = new RegistryUtil();
        String databaseName = dpci.getDatabaseMeta().getName();
        String schemaName = dpci.getSchemaName();
        String tableName = dpci.getTableName();
        Entity entity = util.getTableEntity(databaseName.toLowerCase(), schemaName == null ? null : schemaName.toLowerCase(), tableName.toLowerCase(), false);
        if (entity != null) {
            System.out.println("Util.updateMetadata writing " + util.generateTableId(dpci.getDatabaseMeta().getName(), dpci.getSchemaName(), dpci.getTableName()) + " rowCount=" + rowCount);
            if (rowCount == -1L) {
                util.setAttribute(entity, "rowcount", 0L);
            } else {
                util.updateAttribute(entity, "rowcount", rowCount);
            }
            SimpleDateFormat fmt = new SimpleDateFormat();
            Date now = new Date();
            util.setAttribute(entity, "lastupdate", fmt.format(now));
            util.setAttribute(entity, "lastupdatetick", now.getTime());
        } else {
            System.out.println("Util.updateMetadata failed writing " + util.generateTableId(dpci.getDatabaseMeta().getName(), dpci.getSchemaName(), dpci.getTableName()));
        }
        try {
            registry.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

