/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionTypeConverter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class Validation
implements Cloneable {
    public static final String XML_TAG = "validator_field";
    public static final String XML_TAG_ALLOWED = "allowed_value";
    @Injection(name="NAME", group="VALIDATIONS")
    private String name;
    @Injection(name="FIELD_NAME", group="VALIDATIONS")
    private String fieldName;
    @Injection(name="MAX_LENGTH", group="VALIDATIONS")
    private String maximumLength;
    @Injection(name="MIN_LENGTH", group="VALIDATIONS")
    private String minimumLength;
    @Injection(name="NULL_ALLOWED", group="VALIDATIONS")
    private boolean nullAllowed;
    @Injection(name="ONLY_NULL_ALLOWED", group="VALIDATIONS")
    private boolean onlyNullAllowed;
    @Injection(name="ONLY_NUMERIC_ALLOWED", group="VALIDATIONS")
    private boolean onlyNumericAllowed;
    @Injection(name="DATA_TYPE", group="VALIDATIONS", converter=DataTypeConverter.class)
    private int dataType;
    @Injection(name="DATA_TYPE_VERIFIED", group="VALIDATIONS")
    private boolean dataTypeVerified;
    @Injection(name="CONVERSION_MASK", group="VALIDATIONS")
    private String conversionMask;
    @Injection(name="DECIMAL_SYMBOL", group="VALIDATIONS")
    private String decimalSymbol;
    @Injection(name="GROUPING_SYMBOL", group="VALIDATIONS")
    private String groupingSymbol;
    @Injection(name="MIN_VALUE", group="VALIDATIONS")
    private String minimumValue;
    @Injection(name="MAX_VALUE", group="VALIDATIONS")
    private String maximumValue;
    private String[] allowedValues;
    @Injection(name="SOURCING_VALUES", group="VALIDATIONS")
    private boolean sourcingValues;
    @Injection(name="SOURCING_STEP_NAME", group="VALIDATIONS")
    private String sourcingStepName;
    private StepMeta sourcingStep;
    @Injection(name="SOURCING_FIELD", group="VALIDATIONS")
    private String sourcingField;
    @Injection(name="START_STRING", group="VALIDATIONS")
    private String startString;
    @Injection(name="START_STRING_NOT_ALLOWED", group="VALIDATIONS")
    private String startStringNotAllowed;
    @Injection(name="END_STRING", group="VALIDATIONS")
    private String endString;
    @Injection(name="END_STRING_NOT_ALLOWED", group="VALIDATIONS")
    private String endStringNotAllowed;
    @Injection(name="REGULAR_EXPRESSION_EXPECTED", group="VALIDATIONS")
    private String regularExpression;
    @Injection(name="REGULAR_EXPRESSION_NOT_ALLOWED", group="VALIDATIONS")
    private String regularExpressionNotAllowed;
    @Injection(name="ERROR_CODE", group="VALIDATIONS")
    private String errorCode;
    @Injection(name="ERROR_CODE_DESCRIPTION", group="VALIDATIONS")
    private String errorDescription;

    public Validation() {
        this.maximumLength = "";
        this.minimumLength = "";
        this.nullAllowed = true;
        this.onlyNullAllowed = false;
        this.onlyNumericAllowed = false;
    }

    public Validation(String name) {
        this();
        this.fieldName = name;
    }

    public Validation clone() {
        try {
            return (Validation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Validation validation) {
        return validation.getName().equalsIgnoreCase(this.name);
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        xml.append(XMLHandler.addTagValue((String)"validation_name", (String)this.name));
        xml.append(XMLHandler.addTagValue((String)"max_length", (String)this.maximumLength));
        xml.append(XMLHandler.addTagValue((String)"min_length", (String)this.minimumLength));
        xml.append(XMLHandler.addTagValue((String)"null_allowed", (boolean)this.nullAllowed));
        xml.append(XMLHandler.addTagValue((String)"only_null_allowed", (boolean)this.onlyNullAllowed));
        xml.append(XMLHandler.addTagValue((String)"only_numeric_allowed", (boolean)this.onlyNumericAllowed));
        xml.append(XMLHandler.addTagValue((String)"data_type", (String)ValueMeta.getTypeDesc((int)this.dataType)));
        xml.append(XMLHandler.addTagValue((String)"data_type_verified", (boolean)this.dataTypeVerified));
        xml.append(XMLHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask));
        xml.append(XMLHandler.addTagValue((String)"decimal_symbol", (String)this.decimalSymbol));
        xml.append(XMLHandler.addTagValue((String)"grouping_symbol", (String)this.groupingSymbol));
        xml.append(XMLHandler.addTagValue((String)"max_value", (String)this.maximumValue));
        xml.append(XMLHandler.addTagValue((String)"min_value", (String)this.minimumValue));
        xml.append(XMLHandler.addTagValue((String)"start_string", (String)this.startString));
        xml.append(XMLHandler.addTagValue((String)"end_string", (String)this.endString));
        xml.append(XMLHandler.addTagValue((String)"start_string_not_allowed", (String)this.startStringNotAllowed));
        xml.append(XMLHandler.addTagValue((String)"end_string_not_allowed", (String)this.endStringNotAllowed));
        xml.append(XMLHandler.addTagValue((String)"regular_expression", (String)this.regularExpression));
        xml.append(XMLHandler.addTagValue((String)"regular_expression_not_allowed", (String)this.regularExpressionNotAllowed));
        xml.append(XMLHandler.addTagValue((String)"error_code", (String)this.errorCode));
        xml.append(XMLHandler.addTagValue((String)"error_description", (String)this.errorDescription));
        xml.append(XMLHandler.addTagValue((String)"is_sourcing_values", (boolean)this.sourcingValues));
        xml.append(XMLHandler.addTagValue((String)"sourcing_step", (String)(this.sourcingStep == null ? this.sourcingStepName : this.sourcingStep.getName())));
        xml.append(XMLHandler.addTagValue((String)"sourcing_field", (String)this.sourcingField));
        xml.append(XMLHandler.openTag((String)XML_TAG_ALLOWED));
        if (this.allowedValues != null) {
            for (String allowedValue : this.allowedValues) {
                xml.append(XMLHandler.addTagValue((String)"value", (String)allowedValue));
            }
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG_ALLOWED));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public Validation(Node calcnode) throws KettleXMLException {
        this();
        this.fieldName = XMLHandler.getTagValue((Node)calcnode, (String)"name");
        this.name = XMLHandler.getTagValue((Node)calcnode, (String)"validation_name");
        if (Utils.isEmpty((CharSequence)this.name)) {
            this.name = this.fieldName;
        }
        this.maximumLength = XMLHandler.getTagValue((Node)calcnode, (String)"max_length");
        this.minimumLength = XMLHandler.getTagValue((Node)calcnode, (String)"min_length");
        this.nullAllowed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"null_allowed"));
        this.onlyNullAllowed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"only_null_allowed"));
        this.onlyNumericAllowed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"only_numeric_allowed"));
        this.dataType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)calcnode, (String)"data_type"));
        this.dataTypeVerified = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"data_type_verified"));
        this.conversionMask = XMLHandler.getTagValue((Node)calcnode, (String)"conversion_mask");
        this.decimalSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"decimal_symbol");
        this.groupingSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"grouping_symbol");
        this.minimumValue = XMLHandler.getTagValue((Node)calcnode, (String)"min_value");
        this.maximumValue = XMLHandler.getTagValue((Node)calcnode, (String)"max_value");
        this.startString = XMLHandler.getTagValue((Node)calcnode, (String)"start_string");
        this.endString = XMLHandler.getTagValue((Node)calcnode, (String)"end_string");
        this.startStringNotAllowed = XMLHandler.getTagValue((Node)calcnode, (String)"start_string_not_allowed");
        this.endStringNotAllowed = XMLHandler.getTagValue((Node)calcnode, (String)"end_string_not_allowed");
        this.regularExpression = XMLHandler.getTagValue((Node)calcnode, (String)"regular_expression");
        this.regularExpressionNotAllowed = XMLHandler.getTagValue((Node)calcnode, (String)"regular_expression_not_allowed");
        this.errorCode = XMLHandler.getTagValue((Node)calcnode, (String)"error_code");
        this.errorDescription = XMLHandler.getTagValue((Node)calcnode, (String)"error_description");
        this.sourcingValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"is_sourcing_values"));
        this.sourcingStepName = XMLHandler.getTagValue((Node)calcnode, (String)"sourcing_step");
        this.sourcingField = XMLHandler.getTagValue((Node)calcnode, (String)"sourcing_field");
        Node allowedValuesNode = XMLHandler.getSubNode((Node)calcnode, (String)XML_TAG_ALLOWED);
        int nrValues = XMLHandler.countNodes((Node)allowedValuesNode, (String)"value");
        this.allowedValues = new String[nrValues];
        for (int i = 0; i < nrValues; ++i) {
            Node allowedNode = XMLHandler.getSubNodeByNr((Node)allowedValuesNode, (String)"value", (int)i);
            this.allowedValues[i] = XMLHandler.getNodeValue((Node)allowedNode);
        }
    }

    public Validation(Repository rep, ObjectId id_step, int i) throws KettleException {
        this.fieldName = rep.getStepAttributeString(id_step, i, "validator_field_name");
        this.name = rep.getStepAttributeString(id_step, i, "validator_field_validation_name");
        if (Utils.isEmpty((CharSequence)this.name)) {
            this.name = this.fieldName;
        }
        this.maximumLength = rep.getStepAttributeString(id_step, i, "validator_field_max_length");
        this.minimumLength = rep.getStepAttributeString(id_step, i, "validator_field_min_length");
        this.nullAllowed = rep.getStepAttributeBoolean(id_step, i, "validator_field_null_allowed");
        this.onlyNullAllowed = rep.getStepAttributeBoolean(id_step, i, "validator_field_only_null_allowed");
        this.onlyNumericAllowed = rep.getStepAttributeBoolean(id_step, i, "validator_field_only_numeric_allowed");
        this.dataType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "validator_field_data_type"));
        this.dataTypeVerified = rep.getStepAttributeBoolean(id_step, i, "validator_field_data_type_verified");
        this.conversionMask = rep.getStepAttributeString(id_step, i, "validator_field_conversion_mask");
        this.decimalSymbol = rep.getStepAttributeString(id_step, i, "validator_field_decimal_symbol");
        this.groupingSymbol = rep.getStepAttributeString(id_step, i, "validator_field_grouping_symbol");
        this.minimumValue = rep.getStepAttributeString(id_step, i, "validator_field_min_value");
        this.maximumValue = rep.getStepAttributeString(id_step, i, "validator_field_max_value");
        this.startString = rep.getStepAttributeString(id_step, i, "validator_field_start_string");
        this.endString = rep.getStepAttributeString(id_step, i, "validator_field_end_string");
        this.startStringNotAllowed = rep.getStepAttributeString(id_step, i, "validator_field_start_string_not_allowed");
        this.endStringNotAllowed = rep.getStepAttributeString(id_step, i, "validator_field_end_string_not_allowed");
        this.regularExpression = rep.getStepAttributeString(id_step, i, "validator_field_regular_expression");
        this.regularExpressionNotAllowed = rep.getStepAttributeString(id_step, i, "validator_field_regular_expression_not_allowed");
        this.errorCode = rep.getStepAttributeString(id_step, i, "validator_field_error_code");
        this.errorDescription = rep.getStepAttributeString(id_step, i, "validator_field_error_description");
        this.sourcingValues = rep.getStepAttributeBoolean(id_step, i, "validator_field_is_sourcing_values");
        this.sourcingStepName = rep.getStepAttributeString(id_step, i, "validator_field_sourcing_step");
        this.sourcingField = rep.getStepAttributeString(id_step, i, "validator_field_sourcing_field");
        ArrayList<String> allowed = new ArrayList<String>();
        int nr = 1;
        String value = rep.getStepAttributeString(id_step, i, "validator_field_value_" + nr);
        while (value != null) {
            allowed.add(value);
            value = rep.getStepAttributeString(id_step, i, "validator_field_value_" + ++nr);
        }
        this.allowedValues = allowed.toArray(new String[allowed.size()]);
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step, int i) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_validation_name", this.name);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_max_length", this.maximumLength);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_min_length", this.minimumLength);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_null_allowed", this.nullAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_only_null_allowed", this.onlyNullAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_only_numeric_allowed", this.onlyNumericAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_data_type", ValueMeta.getTypeDesc((int)this.dataType));
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_data_type_verified", this.dataTypeVerified);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_conversion_mask", this.conversionMask);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_decimal_symbol", this.decimalSymbol);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_grouping_symbol", this.groupingSymbol);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_max_value", this.maximumValue);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_min_value", this.minimumValue);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_start_string", this.startString);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_end_string", this.endString);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_start_string_not_allowed", this.startStringNotAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_end_string_not_allowed", this.endStringNotAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_regular_expression", this.regularExpression);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_regular_expression_not_allowed", this.regularExpressionNotAllowed);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_error_code", this.errorCode);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_error_description", this.errorDescription);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_is_sourcing_values", this.sourcingValues);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_sourcing_step", this.sourcingStepName);
        rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_sourcing_field", this.sourcingField);
        if (this.allowedValues != null) {
            for (int nr = 1; nr <= this.allowedValues.length; ++nr) {
                rep.saveStepAttribute(id_transformation, id_step, i, "validator_field_value_" + nr, this.allowedValues[nr - 1]);
            }
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(String maximumLength) {
        this.maximumLength = maximumLength;
    }

    public String getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(String minimumLength) {
        this.minimumLength = minimumLength;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(String minimumValue) {
        this.minimumValue = minimumValue;
    }

    public String getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(String maximumValue) {
        this.maximumValue = maximumValue;
    }

    public String[] getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(String[] allowedValues) {
        this.allowedValues = allowedValues;
    }

    public boolean isDataTypeVerified() {
        return this.dataTypeVerified;
    }

    public void setDataTypeVerified(boolean dataTypeVerified) {
        this.dataTypeVerified = dataTypeVerified;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public boolean isOnlyNumericAllowed() {
        return this.onlyNumericAllowed;
    }

    public String getStartString() {
        return this.startString;
    }

    public void setStartString(String startString) {
        this.startString = startString;
    }

    public String getStartStringNotAllowed() {
        return this.startStringNotAllowed;
    }

    public void setStartStringNotAllowed(String startStringNotAllowed) {
        this.startStringNotAllowed = startStringNotAllowed;
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.endString = endString;
    }

    public String getEndStringNotAllowed() {
        return this.endStringNotAllowed;
    }

    public void setEndStringNotAllowed(String endStringNotAllowed) {
        this.endStringNotAllowed = endStringNotAllowed;
    }

    public void setOnlyNumericAllowed(boolean onlyNumericAllowed) {
        this.onlyNumericAllowed = onlyNumericAllowed;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegularExpressionNotAllowed() {
        return this.regularExpressionNotAllowed;
    }

    public void setRegularExpressionNotAllowed(String regularExpressionNotAllowed) {
        this.regularExpressionNotAllowed = regularExpressionNotAllowed;
    }

    public static Validation findValidation(List<Validation> validations, String name) {
        for (Validation validation : validations) {
            if (!validation.getName().equalsIgnoreCase(name)) continue;
            return validation;
        }
        return null;
    }

    public boolean isOnlyNullAllowed() {
        return this.onlyNullAllowed;
    }

    public void setOnlyNullAllowed(boolean onlyNullAllowed) {
        this.onlyNullAllowed = onlyNullAllowed;
    }

    public boolean isSourcingValues() {
        return this.sourcingValues;
    }

    public void setSourcingValues(boolean sourcingValues) {
        this.sourcingValues = sourcingValues;
    }

    public String getSourcingField() {
        return this.sourcingField;
    }

    public void setSourcingField(String sourcingField) {
        this.sourcingField = sourcingField;
    }

    public String getSourcingStepName() {
        return this.sourcingStepName;
    }

    public void setSourcingStepName(String sourcingStepName) {
        this.sourcingStepName = sourcingStepName;
    }

    public StepMeta getSourcingStep() {
        return this.sourcingStep;
    }

    public void setSourcingStep(StepMeta sourcingStep) {
        this.sourcingStep = sourcingStep;
    }

    public static class DataTypeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws KettleValueException {
            return ValueMetaFactory.getIdForValueMeta((String)v);
        }
    }
}

