/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.yamlinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.yamlinput.YamlInputMeta;
import org.w3c.dom.Node;

public class YamlInputField
implements Cloneable {
    private static Class<?> PKG = YamlInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"YamlInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputField.TrimType.Both", (String[])new String[0])};
    private String name;
    private String path;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;

    public YamlInputField(String fieldname) {
        this.name = fieldname;
        this.path = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
    }

    public YamlInputField() {
        this("");
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(400);
        retval.append("      <field>").append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)this.getPath()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("      </field>").append(Const.CR);
        return retval.toString();
    }

    public YamlInputField(Node fnode) throws KettleValueException {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
        this.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(YamlInputField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            YamlInputField retval = (YamlInputField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String fieldpath) {
        this.path = fieldpath;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return YamlInputField.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return YamlInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

