/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.SwingGC;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainter;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;

public class GetTransImageServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = -4365372274638005929L;
    private static Class<?> PKG = GetTransImageServlet.class;
    public static final String CONTEXT_PATH = "/kettle/transImage";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            Trans trans;
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetTransImageServlet.Log.TransImageRequested", (String[])new String[0]));
            }
            String transName = request.getParameter("name");
            String id = request.getParameter("id");
            if (Utils.isEmpty((CharSequence)id)) {
                CarteObjectEntry entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
                if (entry == null) {
                    trans = null;
                } else {
                    id = entry.getId();
                    trans = this.getTransformationMap().getTransformation(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(transName, id);
                trans = this.getTransformationMap().getTransformation(entry);
            }
            try {
                if (trans == null) break block11;
                response.setStatus(200);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("image/png");
                BufferedImage image = this.generateTransformationImage(trans.getTransMeta());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", os);
                }
                finally {
                    os.flush();
                }
                response.setContentLength(os.size());
                ServletOutputStream out = response.getOutputStream();
                out.write(os.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage generateTransformationImage(TransMeta transMeta) throws Exception {
        float magnification = 1.0f;
        Point maximum = transMeta.getMaximum();
        maximum.multiply(magnification);
        SwingGC gc = new SwingGC(null, maximum, 32, 0, 0);
        TransPainter transPainter = new TransPainter(gc, transMeta, maximum, null, null, null, null, null, new ArrayList<AreaOwner>(), new ArrayList<StepMeta>(), 32, 1, 0, 0, true, "Arial", 10);
        transPainter.setMagnification(magnification);
        transPainter.buildTransformationImage();
        BufferedImage image = (BufferedImage)gc.getImage();
        return image;
    }

    public String toString() {
        return "Trans Image Handler";
    }

    @Override
    public String getService() {
        return "/kettle/transImage (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

