/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class PauseTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = PauseTransServlet.class;
    private static final long serialVersionUID = -2598233582435767691L;
    public static final String CONTEXT_PATH = "/kettle/pauseTrans";

    public PauseTransServlet() {
    }

    public PauseTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PauseTransServlet.PauseOfTransRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        try {
            Trans trans;
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PauseTransServlet.PauseTrans", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            if (Utils.isEmpty((CharSequence)id)) {
                CarteObjectEntry entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
                if (entry == null) {
                    trans = null;
                } else {
                    id = entry.getId();
                    trans = this.getTransformationMap().getTransformation(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(transName, id);
                trans = this.getTransformationMap().getTransformation(entry);
            }
            Encoder encoder = ESAPI.encoder();
            if (trans != null) {
                String message;
                if (trans.isPaused()) {
                    trans.resumeRunning();
                    message = BaseMessages.getString(PKG, (String)"PauseTransServlet.TransResumeRequested", (String[])new String[]{transName});
                } else {
                    trans.pauseRunning();
                    message = BaseMessages.getString(PKG, (String)"PauseTransServlet.TransPauseRequested", (String[])new String[]{transName});
                }
                if (useXML) {
                    out.println(new WebResult("OK", message).getXML());
                } else {
                    out.println("<H1>" + encoder.encodeForHTML(message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToTransStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"PauseTransServlet.CanNotFindTrans", (String[])new String[]{transName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message).getXML());
                } else {
                    out.println("<H1>" + encoder.encodeForHTML(message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXML());
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Const.getStackTracker((Throwable)ex));
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Pause transformation";
    }

    @Override
    public String getService() {
        return "/kettle/pauseTrans (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

