/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.GetTransStatusServlet;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class SniffStepServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetTransStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/sniffStep";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_OUTPUT = "output";
    public static final String XML_TAG = "step-sniff";

    public SniffStepServlet() {
    }

    public SniffStepServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trans trans;
        CarteObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.SniffStepRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("trans");
        String id = request.getParameter("id");
        String stepName = request.getParameter("step");
        int copyNr = Const.toInt((String)request.getParameter("copynr"), (int)0);
        final int nrLines = Const.toInt((String)request.getParameter("lines"), (int)0);
        String type = Const.NVL((String)request.getParameter("type"), (String)TYPE_OUTPUT);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
            if (entry == null) {
                trans = null;
            } else {
                id = entry.getId();
                trans = this.getTransformationMap().getTransformation(entry);
            }
        } else {
            entry = new CarteObjectEntry(transName, id);
            trans = this.getTransformationMap().getTransformation(entry);
        }
        Encoder encoder = ESAPI.encoder();
        if (trans != null) {
            StepInterface step = null;
            List<StepInterface> stepInterfaces = trans.findBaseSteps(stepName);
            for (int i = 0; i < stepInterfaces.size(); ++i) {
                StepInterface look = stepInterfaces.get(i);
                if (look.getCopy() != copyNr) continue;
                step = look;
            }
            if (step != null) {
                final boolean read = type.equalsIgnoreCase(TYPE_INPUT);
                final boolean written = type.equalsIgnoreCase(TYPE_OUTPUT) || !read;
                final MetaAndData metaData = new MetaAndData();
                metaData.bufferRowMeta = null;
                metaData.bufferRowData = new ArrayList<Object[]>();
                RowListener rowListener = new RowListener(){

                    @Override
                    public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        if (read && metaData.bufferRowData.size() < nrLines) {
                            metaData.bufferRowMeta = rowMeta;
                            metaData.bufferRowData.add(row);
                        }
                    }

                    @Override
                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        if (written && metaData.bufferRowData.size() < nrLines) {
                            metaData.bufferRowMeta = rowMeta;
                            metaData.bufferRowData.add(row);
                        }
                    }

                    @Override
                    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    }
                };
                step.addRowListener(rowListener);
                while (metaData.bufferRowData.size() < nrLines && step.isRunning() && !trans.isFinished() && !trans.isStopped()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                step.removeRowListener(rowListener);
                if (useXML) {
                    response.setContentType("text/xml");
                    response.setCharacterEncoding("UTF-8");
                    out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                    out.println(XMLHandler.openTag((String)XML_TAG));
                    if (metaData.bufferRowMeta != null) {
                        out.println(metaData.bufferRowMeta.getMetaXML());
                        out.println(XMLHandler.addTagValue((String)"nr_rows", (int)metaData.bufferRowData.size()));
                        for (int i = 0; i < metaData.bufferRowData.size(); ++i) {
                            Object[] rowData = metaData.bufferRowData.get(i);
                            out.println(metaData.bufferRowMeta.getDataXML(rowData));
                        }
                    }
                    out.println(XMLHandler.closeTag((String)XML_TAG));
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                    out.println("<HTML>");
                    out.println("<HEAD>");
                    out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"SniffStepServlet.SniffResults", (String[])new String[0]) + "</TITLE>");
                    out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
                    out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                    out.println("</HEAD>");
                    out.println("<BODY>");
                    out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"SniffStepServlet.SniffResultsForStep", (String[])new String[]{stepName})) + "</H1>");
                    try {
                        out.println("<table border=\"1\">");
                        if (metaData.bufferRowMeta != null) {
                            out.print("<tr><th>#</th>");
                            for (ValueMetaInterface valueMeta : metaData.bufferRowMeta.getValueMetaList()) {
                                out.print("<th>" + valueMeta.getName() + "</th>");
                            }
                            out.println("</tr>");
                            for (int r = 0; r < metaData.bufferRowData.size(); ++r) {
                                Object[] rowData = metaData.bufferRowData.get(r);
                                out.print("<tr>");
                                out.println("<td>" + (r + 1) + "</td>");
                                for (int v = 0; v < metaData.bufferRowMeta.size(); ++v) {
                                    ValueMetaInterface valueMeta = metaData.bufferRowMeta.getValueMeta(v);
                                    Object valueData = rowData[v];
                                    out.println("<td>" + valueMeta.getString(valueData) + "</td>");
                                }
                                out.println("</tr>");
                            }
                        }
                        out.println("</table>");
                        out.println("<p>");
                    }
                    catch (Exception ex) {
                        out.println("<p>");
                        out.println("<pre>");
                        out.println(encoder.encodeForHTML(Const.getStackTracker((Throwable)ex)));
                        out.println("</pre>");
                    }
                    out.println("<p>");
                    out.println("</BODY>");
                    out.println("</HTML>");
                }
            } else if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"SniffStepServlet.Log.CoundNotFindSpecStep", (String[])new String[]{stepName})).getXML());
            } else {
                out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"SniffStepServlet.Log.CoundNotFindSpecStep", (String[])new String[]{stepName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"SniffStepServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})).getXML());
        } else {
            out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"SniffStepServlet.Log.CoundNotFindTrans", (String[])new String[]{transName})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Trans Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/sniffStep (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    final class MetaAndData {
        public RowMetaInterface bufferRowMeta;
        public List<Object[]> bufferRowData;

        MetaAndData() {
        }
    }
}

