/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.impl.cluster.NamedClusterImpl;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterManager
implements NamedClusterService {
    private Map<IMetaStore, MetaStoreFactory<NamedClusterImpl>> factoryMap = new HashMap<IMetaStore, MetaStoreFactory<NamedClusterImpl>>();
    private NamedCluster clusterTemplate;

    private MetaStoreFactory<NamedClusterImpl> getMetaStoreFactory(IMetaStore metastore) {
        MetaStoreFactory namedClusterMetaStoreFactory = this.factoryMap.get(metastore);
        if (namedClusterMetaStoreFactory == null) {
            namedClusterMetaStoreFactory = new MetaStoreFactory(NamedClusterImpl.class, metastore, "pentaho");
            this.factoryMap.put(metastore, (MetaStoreFactory<NamedClusterImpl>)namedClusterMetaStoreFactory);
        }
        return namedClusterMetaStoreFactory;
    }

    @VisibleForTesting
    void putMetaStoreFactory(IMetaStore metastore, MetaStoreFactory<NamedClusterImpl> metaStoreFactory) {
        this.factoryMap.put(metastore, metaStoreFactory);
    }

    public NamedCluster getClusterTemplate() {
        if (this.clusterTemplate == null) {
            this.clusterTemplate = new NamedClusterImpl();
            this.clusterTemplate.setName("");
            this.clusterTemplate.setHdfsHost("localhost");
            this.clusterTemplate.setHdfsPort("8020");
            this.clusterTemplate.setHdfsUsername("user");
            this.clusterTemplate.setHdfsPassword("password");
            this.clusterTemplate.setJobTrackerHost("localhost");
            this.clusterTemplate.setJobTrackerPort("8032");
            this.clusterTemplate.setZooKeeperHost("localhost");
            this.clusterTemplate.setZooKeeperPort("2181");
            this.clusterTemplate.setOozieUrl("http://localhost:8080/oozie");
        }
        return this.clusterTemplate.clone();
    }

    public void setClusterTemplate(NamedCluster clusterTemplate) {
        this.clusterTemplate = clusterTemplate;
    }

    public void create(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        this.getMetaStoreFactory(metastore).saveElement((Object)new NamedClusterImpl(namedCluster));
    }

    public NamedCluster read(String clusterName, IMetaStore metastore) throws MetaStoreException {
        return (NamedCluster)this.getMetaStoreFactory(metastore).loadElement(clusterName);
    }

    public void update(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedClusterImpl> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(namedCluster.getName());
        factory.saveElement((Object)new NamedClusterImpl(namedCluster));
    }

    public void delete(String clusterName, IMetaStore metastore) throws MetaStoreException {
        this.getMetaStoreFactory(metastore).deleteElement(clusterName);
    }

    public List<NamedCluster> list(IMetaStore metastore) throws MetaStoreException {
        return new ArrayList<NamedCluster>(this.getMetaStoreFactory(metastore).getElements());
    }

    public List<String> listNames(IMetaStore metastore) throws MetaStoreException {
        return this.getMetaStoreFactory(metastore).getElementNames();
    }

    public boolean contains(String clusterName, IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return false;
        }
        return this.listNames(metastore).contains(clusterName);
    }

    public NamedCluster getNamedClusterByName(String namedCluster, IMetaStore metastore) {
        if (metastore == null) {
            return null;
        }
        try {
            List<NamedCluster> namedClusters = this.list(metastore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equals(namedCluster)) continue;
                return nc;
            }
        }
        catch (MetaStoreException e) {
            return null;
        }
        return null;
    }
}

