/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.math.NumberUtils;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.KeyValueClosure;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasuresCollection;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AnnotationType
implements Serializable {
    protected static final String OLAP_CUBES_PROPERTY = "olap_cubes";
    protected static final String MEASURES_DIMENSION = "Measures";
    protected static final String MEASURE_ELEMENT_NAME = "Measure";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String COLUMN_ATTRIBUTE = "column";
    protected static final String CALCULATED_MEMBER_ELEMENT_NAME = "CalculatedMember";
    protected static final Class<?> MSG_CLASS = BaseModelerWorkspaceHelper.class;
    private static final long serialVersionUID = 3952409344571242884L;
    private static transient Logger logger = Logger.getLogger(AnnotationType.class.getName());

    protected Logger getLogger() {
        return logger;
    }

    protected List<Field> findAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = this.findAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public List<String> getModelPropertyIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            if (!f.isAnnotationPresent(ModelProperty.class)) continue;
            ModelProperty mp = f.getAnnotation(ModelProperty.class);
            ids.add(mp.id());
        }
        return ids;
    }

    public void setModelPropertyValueById(String id, Object value) throws Exception {
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            ModelProperty mp;
            if (!f.isAnnotationPresent(ModelProperty.class) || !StringUtils.equals((String)(mp = f.getAnnotation(ModelProperty.class)).id(), (String)id)) continue;
            this.attemptAutoConvertAndAssign(f, value);
        }
    }

    public Object getModelPropertyValueById(String id) throws Exception {
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            ModelProperty mp;
            if (!f.isAnnotationPresent(ModelProperty.class) || !StringUtils.equals((String)(mp = f.getAnnotation(ModelProperty.class)).id(), (String)id)) continue;
            return PropertyUtils.getProperty((Object)this, (String)f.getName());
        }
        return null;
    }

    public Object getModelPropertyValueByName(String name) throws Exception {
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            ModelProperty mp;
            if (!f.isAnnotationPresent(ModelProperty.class) || !StringUtils.equals((String)(mp = f.getAnnotation(ModelProperty.class)).name(), (String)name)) continue;
            return PropertyUtils.getProperty((Object)this, (String)f.getName());
        }
        return null;
    }

    public Class getModelPropertyNameClassType(String name) {
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            ModelProperty mp;
            if (!f.isAnnotationPresent(ModelProperty.class) || !StringUtils.equals((String)(mp = f.getAnnotation(ModelProperty.class)).name(), (String)name)) continue;
            return f.getType();
        }
        return null;
    }

    public List<String> getModelPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (ModelProperty p : this.getModelProperties()) {
            propertyNames.add(p.name());
        }
        return propertyNames;
    }

    public List<ModelProperty> getModelProperties() {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            if (!f.isAnnotationPresent(ModelProperty.class)) continue;
            ModelProperty mp = f.getAnnotation(ModelProperty.class);
            properties.add(mp);
        }
        Collections.sort(properties, new Comparator<ModelProperty>(){

            @Override
            public int compare(ModelProperty m1, ModelProperty m2) {
                if (m1.order() <= m2.order()) {
                    return -1;
                }
                return 1;
            }
        });
        return properties;
    }

    public void setModelPropertyByName(String modelPropertyName, Object value) throws Exception {
        List<Field> fields = this.findAllFields(new ArrayList<Field>(), this.getClass());
        for (Field f : fields) {
            ModelProperty mp;
            if (!f.isAnnotationPresent(ModelProperty.class) || !StringUtils.equals((String)(mp = f.getAnnotation(ModelProperty.class)).name(), (String)modelPropertyName)) continue;
            this.attemptAutoConvertAndAssign(f, value);
        }
    }

    protected void attemptAutoConvertAndAssign(Field field, Object value) throws Exception {
        if (field == null) {
            return;
        }
        if (value == null) {
            try {
                PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (value != null && ClassUtils.isAssignable(value.getClass(), field.getType(), (boolean)true)) {
            PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)value);
        } else {
            try {
                if (ClassUtils.isAssignable(field.getType(), Boolean.class, (boolean)true)) {
                    PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)BooleanUtils.toBoolean((String)value.toString()));
                    return;
                }
                if (ClassUtils.isAssignable(field.getType(), AggregationType.class, (boolean)true)) {
                    AggregationType type = AggregationType.valueOf((String)value.toString());
                    if (type != null) {
                        PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)type);
                    }
                    return;
                }
                if (ClassUtils.isAssignable(field.getType(), ModelAnnotation.TimeType.class, (boolean)true)) {
                    ModelAnnotation.TimeType type = ModelAnnotation.TimeType.valueOf(value.toString());
                    if (type != null) {
                        PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)((Object)type));
                    }
                    return;
                }
                if (ClassUtils.isAssignable(field.getType(), ModelAnnotation.GeoType.class, (boolean)true)) {
                    ModelAnnotation.GeoType type = ModelAnnotation.GeoType.valueOf(value.toString());
                    if (type != null) {
                        PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)((Object)type));
                    }
                    return;
                }
                if (NumberUtils.isNumber((String)value.toString())) {
                    Number number = NumberUtils.createNumber((String)value.toString());
                    PropertyUtils.setProperty((Object)this, (String)field.getName(), (Object)number);
                }
            }
            catch (Exception e) {
                if (value == null || StringUtils.isBlank((String)value.toString())) {
                    return;
                }
                this.getLogger().warning("Unable to convert " + value.toString() + " in to " + field.getType());
            }
        }
    }

    public Map<String, Serializable> describe() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        List<String> ids = this.getModelPropertyIds();
        for (String id : ids) {
            try {
                Object value = this.getModelPropertyValueById(id);
                if (value == null || !this.isSerializable(value.getClass())) continue;
                map.put(id, (Serializable)value);
            }
            catch (Exception e) {
                this.getLogger().warning("Unable to set value for id: " + id);
            }
        }
        return map;
    }

    protected void removeAutoLevel(ModelerWorkspace workspace, LevelMetaData levelMetaData) {
        if (levelMetaData == null) {
            return;
        }
        HierarchyMetaData hierarchy = levelMetaData.getHierarchyMetaData();
        DimensionMetaData dimension = hierarchy.getDimensionMetaData();
        if (hierarchy.getLevels().size() > 1) {
            return;
        }
        if (dimension.contains(hierarchy)) {
            dimension.remove(hierarchy);
        }
        if (dimension.size() > 0) {
            return;
        }
        DimensionMetaDataCollection dimensions = workspace.getModel().getDimensions();
        if (dimensions.contains(dimension)) {
            dimensions.remove(dimension);
        }
    }

    protected LevelMetaData locateLevel(ModelerWorkspace workspace, String column) throws ModelerException {
        String locale = workspace.getWorkspaceHelper().getLocale();
        workspace.getModel().getDimensions();
        Iterator iterator = workspace.getModel().getDimensions().iterator();
        while (iterator.hasNext()) {
            DimensionMetaData dimensionMetaData = (DimensionMetaData)iterator.next();
            Iterator iterator2 = dimensionMetaData.iterator();
            while (iterator2.hasNext()) {
                HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)iterator2.next();
                Iterator iterator3 = hierarchyMetaData.iterator();
                while (iterator3.hasNext()) {
                    LevelMetaData levelMetaData = (LevelMetaData)iterator3.next();
                    if (!levelMetaData.getLogicalColumn().getName(locale).equalsIgnoreCase(column) && !levelMetaData.getLogicalColumn().getName(locale).equals(this.beautify(column))) continue;
                    return levelMetaData;
                }
            }
        }
        return null;
    }

    protected LogicalColumn locateLogicalColumn(ModelerWorkspace workspace, String columnName) {
        String locale = workspace.getWorkspaceHelper().getLocale();
        LogicalModel logicalModel = workspace.getLogicalModel(ModelerPerspective.ANALYSIS);
        logicalModel.getLogicalTables();
        for (LogicalTable logicalTable : logicalModel.getLogicalTables()) {
            for (LogicalColumn logicalColumn : logicalTable.getLogicalColumns()) {
                if (!logicalColumn.getName(locale).equalsIgnoreCase(columnName) && !logicalColumn.getName(locale).equalsIgnoreCase(this.beautify(columnName))) continue;
                return logicalColumn;
            }
        }
        return null;
    }

    protected void removeAutoMeasure(ModelerWorkspace workspace, String column) {
        MeasureMetaData measure = this.locateMeasure(workspace, column);
        if (measure != null) {
            workspace.getModel().getMeasures().remove(measure);
        }
    }

    private MeasureMetaData locateMeasure(ModelerWorkspace workspace, String column) {
        MeasuresCollection measures = workspace.getModel().getMeasures();
        Iterator iterator = measures.iterator();
        while (iterator.hasNext()) {
            MeasureMetaData measure = (MeasureMetaData)iterator.next();
            if (!measure.getLogicalColumn().getName(workspace.getWorkspaceHelper().getLocale()).equals(column) && !measure.getLogicalColumn().getName(workspace.getWorkspaceHelper().getLocale()).equals(this.beautify(column))) continue;
            return measure;
        }
        return null;
    }

    protected String beautify(String column) {
        return column == null ? null : PhysicalTableImporter.beautifyName((String)column);
    }

    public void populate(Map<String, Serializable> propertiesMap) {
        if (propertiesMap != null && propertiesMap.keySet() != null) {
            for (String id : propertiesMap.keySet()) {
                try {
                    this.setModelPropertyValueById(id, propertiesMap.get(id));
                }
                catch (Exception e) {
                    this.getLogger().warning("Unable to set value for id: " + id);
                }
            }
        }
    }

    private OlapCube getOlapCube(ModelerWorkspace modelerWorkspace, String cubeName) {
        LogicalModel businessModel = modelerWorkspace.getLogicalModel(ModelerPerspective.ANALYSIS);
        List olapCubes = (List)businessModel.getProperty(OLAP_CUBES_PROPERTY);
        OlapCube olapCube = null;
        for (int c = 0; c < olapCubes.size(); ++c) {
            if (!((OlapCube)olapCubes.get(c)).getName().equals(cubeName)) continue;
            olapCube = (OlapCube)olapCubes.get(c);
            break;
        }
        return olapCube;
    }

    protected String resolveFieldFromLevel(ModelerWorkspace modelerWorkspace, String levelName, String cubeName) throws ModelerException {
        if (StringUtils.isBlank((String)levelName) || StringUtils.isBlank((String)cubeName) || modelerWorkspace == null) {
            throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_LEVEL", (String)levelName));
        }
        String locale = Locale.getDefault().toString();
        OlapCube olapCube = this.getOlapCube(modelerWorkspace, cubeName);
        if (olapCube == null) {
            throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_CUBE", (String)cubeName));
        }
        List usages = olapCube.getOlapDimensionUsages();
        for (int u = 0; u < usages.size(); ++u) {
            OlapDimensionUsage usage = (OlapDimensionUsage)usages.get(u);
            OlapDimension olapDimension = usage.getOlapDimension();
            List olapHierarchies = olapDimension.getHierarchies();
            for (int h = 0; h < olapHierarchies.size(); ++h) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[");
                buffer.append(usage.getName());
                OlapHierarchy olapHierarchy = (OlapHierarchy)olapHierarchies.get(h);
                if (StringUtils.isNotEmpty((String)olapHierarchy.getName()) && !StringUtils.equals((String)olapHierarchy.getName(), (String)usage.getName())) {
                    buffer.append(".").append(olapHierarchy.getName());
                }
                buffer.append("].[");
                List hierarchyLevels = olapHierarchy.getHierarchyLevels();
                for (int hl = 0; hl < hierarchyLevels.size(); ++hl) {
                    OlapHierarchyLevel olapHierarchyLevel = (OlapHierarchyLevel)hierarchyLevels.get(hl);
                    if (!levelName.equals(buffer.toString() + olapHierarchyLevel.getName() + "]")) continue;
                    return olapHierarchyLevel.getReferenceColumn().getName(locale);
                }
            }
        }
        throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_LEVEL", (String)levelName));
    }

    protected String resolveFieldFromMeasure(ModelerWorkspace modelerWorkspace, String measureName, String cubeName) throws ModelerException {
        if (StringUtils.isBlank((String)measureName) || StringUtils.isBlank((String)cubeName) || modelerWorkspace == null) {
            throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_MEASURE", (String)measureName));
        }
        String locale = Locale.getDefault().toString();
        OlapCube olapCube = this.getOlapCube(modelerWorkspace, cubeName);
        if (olapCube == null) {
            throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_CUBE", (String)cubeName));
        }
        List measures = olapCube.getOlapMeasures();
        for (int m = 0; m < measures.size(); ++m) {
            OlapMeasure measure = (OlapMeasure)measures.get(m);
            if (!measureName.equals("[Measures].[" + measure.getLogicalColumn().getName(locale) + "]")) continue;
            return measure.getLogicalColumn().getName(locale);
        }
        throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_MEASURE", (String)measureName));
    }

    protected String resolveFieldFromMeasure(Document schema, String measure) throws ModelerException {
        if (schema != null && !StringUtils.isBlank((String)measure)) {
            NodeList measures = schema.getElementsByTagName(MEASURE_ELEMENT_NAME);
            if (measures == null || measures.getLength() <= 0) {
                throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_MEASURE", (String)measure));
            }
            for (int x = 0; x <= measures.getLength(); ++x) {
                Node columnNode;
                Node nameNode;
                Node measureNode = measures.item(x);
                if (measureNode == null || (nameNode = measureNode.getAttributes().getNamedItem(NAME_ATTRIBUTE)) == null || !nameNode.getNodeValue().equals(measure.substring(measure.lastIndexOf("[") + 1).replace("]", "")) || (columnNode = measureNode.getAttributes().getNamedItem(COLUMN_ATTRIBUTE)) == null) continue;
                return columnNode.getNodeValue();
            }
            throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_MEASURE", (String)measure));
        }
        throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_MEASURE", (String)measure));
    }

    public void iterateProperties(KeyValueClosure closure) {
        Map<String, Serializable> properties = this.describe();
        if (closure == null || properties == null || properties.keySet() == null) {
            return;
        }
        for (String key : properties.keySet()) {
            Serializable value;
            if (!StringUtils.isNotBlank((String)key) || (value = properties.get(key)) == null) continue;
            closure.execute(key, value);
        }
    }

    private boolean isSerializable(Class<?> classToCheck) {
        return Serializable.class.isAssignableFrom(classToCheck);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public abstract boolean apply(ModelerWorkspace var1, IMetaStore var2) throws ModelerException;

    public abstract boolean apply(Document var1) throws ModelerException;

    public abstract void validate() throws ModelerException;

    public abstract ModelAnnotation.Type getType();

    public abstract String getSummary();

    public abstract String getName();

    public abstract String getField();

    public boolean equalsLogically(AnnotationType obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EqualsBuilder eq = new EqualsBuilder();
        String thatName = obj.getName() == null ? null : obj.getName().toLowerCase();
        String myName = this.getName() == null ? null : this.getName().toLowerCase();
        eq.append((Object)myName, (Object)thatName);
        return eq.isEquals();
    }
}

