/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.data.InlineFormatAnnotation;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class CreateAttribute
extends AnnotationType {
    private static final long serialVersionUID = 5169827225345800226L;
    public static final String MDI_GROUP = "ATTRIBUTE";
    private static transient Logger logger = Logger.getLogger(AnnotationType.class.getName());
    private static final String DEFAULT_AUTO_GEO_DIMENSION_NAME = "Geography";
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "Attribute Name";
    public static final int NAME_ORDER = 0;
    public static final String TIME_TYPE_ID = "timeType";
    public static final String TIME_TYPE_NAME = "Time Level Type";
    public static final int TIME_TYPE_ORDER = 1;
    public static final String TIME_FORMAT_ID = "timeFormat";
    public static final String TIME_FORMAT_NAME = "Time Source Format";
    public static final int TIME_FORMAT_ORDER = 2;
    public static final String GEO_TYPE_ID = "geoType";
    public static final String GEO_TYPE_NAME = "Geo Type";
    public static final int GEO_TYPE_ORDER = 3;
    public static final String ORDINAL_FIELD_ID = "ordinalField";
    public static final String ORDINAL_FIELD_NAME = "Ordinal Field";
    public static final int ORDINAL_FIELD_ORDER = 4;
    public static final String FORMAT_STRING_ID = "formatString";
    public static final String FORMAT_STRING_NAME = "Format";
    public static final int FORMAT_STRING_ORDER = 5;
    public static final String DESCRIPTION_ID = "description";
    public static final String DESCRIPTION_NAME = "Description";
    public static final int DESCRIPTION_ORDER = 6;
    public static final String BUSINESS_GROUP_ID = "businessGroup";
    public static final String BUSINESS_GROUP_NAME = "Business Group";
    public static final int BUSINESS_GROUP_ORDER = 7;
    public static final String PARENT_ATTRIBUTE_ID = "parentAttribute";
    public static final String PARENT_ATTRIBUTE_NAME = "Parent Attribute";
    public static final int PARENT_ATTRIBUTE_ORDER = 8;
    public static final String DIMENSION_ID = "dimension";
    public static final String DIMENSION_NAME = "Dimension";
    public static final int DIMENSION_ORDER = 9;
    public static final String HIERARCHY_ID = "hierarchy";
    public static final String HIERARCHY_NAME = "Hierarchy";
    public static final int HIERARCHY_ORDER = 10;
    public static final String UNIQUE_ID = "unique";
    public static final String UNIQUE_NAME = "Is Unique";
    public static final int UNIQUE_ORDER = 11;
    public static final String FIELD_ID = "field";
    public static final String FIELD_NAME = "Field";
    public static final int FIELD_ORDER = 12;
    public static final String LEVEL_ID = "level";
    public static final String LEVEL_NAME = "Level";
    public static final int LEVEL_ORDER = 13;
    public static final String CUBE_ID = "cube";
    public static final String CUBE_NAME = "Cube";
    public static final int CUBE_ORDER = 14;
    public static final String HIDDEN_ID = "hidden";
    public static final String HIDDEN_NAME = "Hidden";
    public static final int HIDDEN_ORDER = 15;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Attribute Name", order=0)
    @Injection(name="ATTRIBUTE_NAME", group="ATTRIBUTE")
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="unique", name="Is Unique", order=11)
    @Injection(name="ATTRIBUTE_IS_UNIQUE", group="ATTRIBUTE")
    private boolean unique;
    @MetaStoreAttribute
    @ModelProperty(id="timeFormat", name="Time Source Format", order=2)
    @Injection(name="ATTRIBUTE_TIME_FORMAT", group="ATTRIBUTE")
    private String timeFormat;
    @MetaStoreAttribute
    @ModelProperty(id="timeType", name="Time Level Type", order=1)
    @Injection(name="ATTRIBUTE_TIME_TYPE", group="ATTRIBUTE")
    private ModelAnnotation.TimeType timeType;
    @MetaStoreAttribute
    @ModelProperty(id="geoType", name="Geo Type", order=3)
    @Injection(name="ATTRIBUTE_GEO_TYPE", group="ATTRIBUTE")
    private ModelAnnotation.GeoType geoType;
    @MetaStoreAttribute
    @ModelProperty(id="ordinalField", name="Ordinal Field", order=4)
    @Injection(name="ATTRIBUTE_ORDINAL_FIELD", group="ATTRIBUTE")
    private String ordinalField;
    @MetaStoreAttribute
    @ModelProperty(id="formatString", name="Format", order=5, appliesTo={ModelProperty.AppliesTo.Numeric, ModelProperty.AppliesTo.Time})
    @Injection(name="ATTRIBUTE_FORMAT_STRING", group="ATTRIBUTE")
    private String formatString;
    @MetaStoreAttribute
    @ModelProperty(id="parentAttribute", name="Parent Attribute", order=8)
    @Injection(name="ATTRIBUTE_PARENT", group="ATTRIBUTE")
    private String parentAttribute;
    @MetaStoreAttribute
    @ModelProperty(id="dimension", name="Dimension", order=9)
    @Injection(name="ATTRIBUTE_DIMENSION", group="ATTRIBUTE")
    private String dimension;
    @MetaStoreAttribute
    @ModelProperty(id="hierarchy", name="Hierarchy", order=10)
    @Injection(name="ATTRIBUTE_HIERARCHY", group="ATTRIBUTE")
    private String hierarchy;
    @MetaStoreAttribute
    @ModelProperty(id="description", name="Description", order=6)
    @Injection(name="ATTRIBUTE_DESCRIPTION", group="ATTRIBUTE")
    private String description;
    @MetaStoreAttribute
    private String businessGroup;
    @MetaStoreAttribute
    @ModelProperty(id="field", name="Field", order=12, hideUI=true)
    @Injection(name="ATTRIBUTE_FIELD", group="ATTRIBUTE")
    private String field;
    @MetaStoreAttribute
    @ModelProperty(id="level", name="Level", order=13, hideUI=true)
    private String level;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube", order=14, hideUI=true)
    private String cube;
    @MetaStoreAttribute
    @ModelProperty(id="hidden", name="Hidden", order=15)
    @Injection(name="ATTRIBUTE_IS_HIDDEN", group="ATTRIBUTE")
    private boolean hidden;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public ModelAnnotation.TimeType getTimeType() {
        return this.timeType;
    }

    public void setTimeType(ModelAnnotation.TimeType timeType) {
        this.timeType = timeType;
    }

    public ModelAnnotation.GeoType getGeoType() {
        return this.geoType;
    }

    public void setGeoType(ModelAnnotation.GeoType geoType) {
        this.geoType = geoType;
    }

    public String getOrdinalField() {
        return this.ordinalField;
    }

    public void setOrdinalField(String ordinalField) {
        this.ordinalField = ordinalField;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getParentAttribute() {
        return this.parentAttribute;
    }

    public void setParentAttribute(String parentAttribute) {
        this.parentAttribute = parentAttribute;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBusinessGroup() {
        return this.businessGroup;
    }

    public void setBusinessGroup(String businessGroup) {
        this.businessGroup = businessGroup;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        HierarchyMetaData existingHierarchy = this.locateHierarchy(workspace, this.getHierarchy());
        if (existingHierarchy == null && !Const.isEmpty((String)this.getParentAttribute())) {
            return false;
        }
        if (existingHierarchy != null && Const.isEmpty((String)this.getParentAttribute())) {
            this.removeHierarchy(existingHierarchy);
            return this.createNewHierarchy(workspace, this.resolveField(workspace));
        }
        if (existingHierarchy == null) {
            return this.createNewHierarchy(workspace, this.resolveField(workspace));
        }
        return this.attachLevel(workspace, existingHierarchy, this.resolveField(workspace));
    }

    private String resolveField(ModelerWorkspace workspace) throws ModelerException {
        String field = this.getField();
        if (StringUtils.isBlank((String)field)) {
            if (!StringUtils.isBlank((String)this.getLevel()) && !StringUtils.isBlank((String)this.getCube())) {
                field = this.resolveFieldFromLevel(workspace, this.getLevel(), this.getCube());
                this.setField(field);
            } else {
                throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_FIELD"));
            }
        }
        return field;
    }

    private void removeHierarchy(HierarchyMetaData hierarchy) {
        DimensionMetaData dimension = hierarchy.getDimensionMetaData();
        if (dimension.contains(hierarchy)) {
            dimension.remove(hierarchy);
        }
    }

    private HierarchyMetaData locateHierarchy(ModelerWorkspace workspace, String name) {
        Iterator iterator = workspace.getModel().getDimensions().iterator();
        while (iterator.hasNext()) {
            DimensionMetaData dimensionMetaData = (DimensionMetaData)iterator.next();
            if (!dimensionMetaData.getName().equals(this.getDimension())) continue;
            Iterator iterator2 = dimensionMetaData.iterator();
            while (iterator2.hasNext()) {
                HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)iterator2.next();
                if (!hierarchyMetaData.getName().equals(Const.isEmpty((String)name) ? this.getDimension() : name)) continue;
                return hierarchyMetaData;
            }
        }
        return null;
    }

    private boolean isAutoModeled(ModelerWorkspace workspace) {
        try {
            if (this.getGeoType() != null && StringUtils.equals((String)workspace.getGeoContext().getDimensionName(), (String)this.getDimension())) {
                return true;
            }
            HierarchyMetaData hierarchy = this.locateHierarchy(workspace, this.getDimension());
            return hierarchy != null && hierarchy.size() == 1 && hierarchy.getLevels().get(0).getName().equals(hierarchy.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean createNewHierarchy(ModelerWorkspace workspace, String column) throws ModelerException {
        HierarchyMetaData hierarchyMetaData = new HierarchyMetaData(Const.isEmpty((String)this.getHierarchy()) ? this.getDimension() : this.getHierarchy());
        Iterator iterator = workspace.getModel().getDimensions().iterator();
        while (iterator.hasNext()) {
            DimensionMetaData dimensionMetaData = (DimensionMetaData)iterator.next();
            if (!dimensionMetaData.getName().equals(this.getDimension()) || this.isAutoModeled(workspace)) continue;
            hierarchyMetaData.setParent(dimensionMetaData);
            if (dimensionMetaData.isEmpty()) {
                dimensionMetaData.setDimensionType(this.dimensionType());
            }
            dimensionMetaData.add(hierarchyMetaData);
        }
        if (hierarchyMetaData.getParent() == null) {
            DimensionMetaData dimensionMetaData = new DimensionMetaData(this.getDimension(), this.dimensionType());
            dimensionMetaData.setTimeDimension(this.getTimeType() != null);
            workspace.getModel().getDimensions().add(dimensionMetaData);
            hierarchyMetaData.setParent(dimensionMetaData);
            dimensionMetaData.add(hierarchyMetaData);
        }
        LevelMetaData existingLevel = this.locateLevel(workspace, column);
        LevelMetaData ordinalAutoLevel = this.locateLevel(workspace, this.getOrdinalField());
        LogicalColumn logicalColumn = this.locateLogicalColumn(workspace, column);
        if (logicalColumn == null) {
            return false;
        }
        LevelMetaData levelMetaData = new LevelMetaData(hierarchyMetaData, this.getName());
        hierarchyMetaData.add(levelMetaData);
        this.fillLevelProperties(workspace, logicalColumn, levelMetaData);
        this.removeAutoLevel(workspace, existingLevel);
        this.removeAutoMeasure(workspace, column);
        this.removeAutoLevel(workspace, ordinalAutoLevel);
        this.removeAutoMeasure(workspace, this.getOrdinalField());
        workspace.getWorkspaceHelper().populateDomain(workspace);
        return true;
    }

    private String dimensionType() {
        if (this.getTimeType() != null) {
            return "TimeDimension";
        }
        return "StandardDimension";
    }

    private void fillLevelProperties(ModelerWorkspace workspace, LogicalColumn logicalColumn, LevelMetaData levelMetaData) {
        LogicalColumn ordinalColumn;
        levelMetaData.setLogicalColumn(logicalColumn);
        levelMetaData.setUniqueMembers(this.isUnique());
        levelMetaData.setHidden(this.isHidden());
        if (this.getTimeType() != null) {
            levelMetaData.setDataRole(TimeRole.fromMondrianAttributeValue(this.getTimeType().name()));
        }
        if (!Const.isEmpty((String)this.getTimeFormat())) {
            levelMetaData.setTimeLevelFormat(this.getTimeFormat());
        }
        if ((ordinalColumn = this.locateLogicalColumn(workspace, this.getOrdinalField())) != null) {
            levelMetaData.setLogicalOrdinalColumn(ordinalColumn);
        }
        if (this.getGeoType() != null) {
            if (Const.isEmpty((String)this.getParentAttribute())) {
                this.removeAutoGeo(workspace);
            }
            GeoRole geoRole = workspace.getGeoContext().getGeoRoleByName(this.getGeoType().name());
            levelMetaData.getMemberAnnotations().put("Data.Role", geoRole);
        }
        if (this.getDescription() != null) {
            levelMetaData.setDescription(this.getDescription());
        }
        if (!StringUtils.isBlank((String)this.getFormatString())) {
            levelMetaData.getMemberAnnotations().put("InlineMemberFormatString", new InlineFormatAnnotation(this.getFormatString()));
        }
    }

    private void removeAutoGeo(ModelerWorkspace workspace) {
        DimensionMetaDataCollection dimensions = workspace.getModel().getDimensions();
        DimensionMetaData toRemove = null;
        GeoContext geoContext = workspace.getGeoContext();
        Iterator iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            DimensionMetaData dimensionMetaData = (DimensionMetaData)iterator.next();
            if (geoContext == null || !dimensionMetaData.getName().equals(geoContext.getDimensionName())) continue;
            Iterator iterator2 = dimensionMetaData.iterator();
            block1: while (iterator2.hasNext()) {
                HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)iterator2.next();
                if (!hierarchyMetaData.getName().equals(geoContext.getDimensionName())) continue;
                Iterator iterator3 = hierarchyMetaData.iterator();
                while (iterator3.hasNext()) {
                    LevelMetaData levelMetaData = (LevelMetaData)iterator3.next();
                    if (levelMetaData.getMemberAnnotations().get("Data.Role") == null) continue;
                    toRemove = dimensionMetaData;
                    continue block1;
                }
            }
        }
        if (toRemove != null) {
            dimensions.remove(toRemove);
        }
    }

    private boolean attachLevel(ModelerWorkspace workspace, HierarchyMetaData existingHierarchy, String column) throws ModelerException {
        int parentIndex = this.parentIndex(existingHierarchy);
        if (parentIndex < 0) {
            return false;
        }
        LevelMetaData existingLevel = this.locateLevel(workspace, column);
        LevelMetaData ordinalAutoLevel = this.locateLevel(workspace, this.getOrdinalField());
        LogicalColumn logicalColumn = this.locateLogicalColumn(workspace, column);
        if (logicalColumn == null) {
            return false;
        }
        LevelMetaData levelMetaData = new LevelMetaData(existingHierarchy, this.getName());
        existingHierarchy.add(parentIndex + 1, levelMetaData);
        this.fillLevelProperties(workspace, logicalColumn, levelMetaData);
        this.removeAutoLevel(workspace, existingLevel);
        this.removeAutoMeasure(workspace, column);
        this.removeAutoLevel(workspace, ordinalAutoLevel);
        this.removeAutoMeasure(workspace, this.getOrdinalField());
        workspace.getWorkspaceHelper().populateDomain(workspace);
        return true;
    }

    private int parentIndex(HierarchyMetaData existingHierarchy) {
        List<LevelMetaData> levels = existingHierarchy.getLevels();
        for (int i = 0; i < levels.size(); ++i) {
            LevelMetaData levelMetaData = levels.get(i);
            if (!levelMetaData.getName().equals(this.getParentAttribute())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void populate(Map<String, Serializable> propertiesMap) {
        super.populate(propertiesMap);
        try {
            Serializable value;
            if (propertiesMap.containsKey(TIME_TYPE_ID) && (value = propertiesMap.get(TIME_TYPE_ID)) != null) {
                this.setTimeType(ModelAnnotation.TimeType.valueOf(value.toString()));
            }
            if (propertiesMap.containsKey(GEO_TYPE_ID) && (value = propertiesMap.get(GEO_TYPE_ID)) != null) {
                this.setGeoType(ModelAnnotation.GeoType.valueOf(value.toString()));
            }
        }
        catch (Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.CREATE_ATTRIBUTE;
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString((Class)MSG_CLASS, (String)this.summaryMsgKey(), (String[])new String[]{this.getName(), Const.isEmpty((String)this.getHierarchy()) ? "" : " " + this.getHierarchy(), this.getParentAttribute()});
    }

    private String summaryMsgKey() {
        if (Const.isEmpty((String)this.getParentAttribute())) {
            return "Modeler.CreateAttribute.Summary.noparent";
        }
        return "Modeler.CreateAttribute.Summary";
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateAttribute.validation.ATTRIBUTE_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getField()) && (StringUtils.isBlank((String)this.getLevel()) || StringUtils.isBlank((String)this.getCube()))) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateAttribute.validation.FIELD_OR_LEVEL_NOT_PROVIDED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getDimension())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateAttribute.validation.PARENT_PROVIDED_MISSING_DIMENSION", (String[])new String[0]));
        }
        if (StringUtils.isNotBlank((String)this.getParentAttribute()) && StringUtils.isBlank((String)this.getDimension())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateAttribute.validation.PARENT_PROVIDED_MISSING_DIMENSION", (String[])new String[0]));
        }
    }

    @Override
    public boolean equalsLogically(AnnotationType obj) {
        String myHierarchy;
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CreateAttribute that = (CreateAttribute)obj;
        EqualsBuilder eq = new EqualsBuilder();
        String thatName = that.getName() == null ? null : that.getName().toLowerCase();
        String myName = this.getName() == null ? null : this.getName().toLowerCase();
        eq.append((Object)myName, (Object)thatName);
        String thatDimension = that.getDimension() == null ? null : that.getDimension().toLowerCase();
        String myDimension = this.getDimension() == null ? null : this.getDimension().toLowerCase();
        eq.append((Object)myDimension, (Object)thatDimension);
        String thatHierarchy = that.getHierarchy() == null ? null : that.getHierarchy().toLowerCase();
        String string = myHierarchy = this.getHierarchy() == null ? null : this.getHierarchy().toLowerCase();
        if (thatHierarchy == null) {
            thatHierarchy = thatDimension;
        }
        if (myHierarchy == null) {
            myHierarchy = myDimension;
        }
        eq.append((Object)myHierarchy, (Object)thatHierarchy);
        return eq.isEquals();
    }
}

