/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations.util;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLUtil {
    public static String compactPrint(String xml) throws Exception {
        OutputFormat format = OutputFormat.createCompactFormat();
        return XMLUtil.print(xml, format);
    }

    public static String prettyPrint(String xml) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        return XMLUtil.print(xml, format);
    }

    private static String print(String xml, OutputFormat format) throws Exception {
        format.setSuppressDeclaration(true);
        Document document = DocumentHelper.parseText((String)xml);
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)sw, format);
        writer.write(document);
        return sw.toString();
    }

    public static Node asDOMNode(String xml) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        org.w3c.dom.Document doc = dBuilder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        return doc.getFirstChild();
    }

    public static void addOrUpdateAttribute(Element element, String name, String value) {
        NamedNodeMap measureAttrs = element.getAttributes();
        Node attrNode = measureAttrs.getNamedItem(name);
        if (attrNode != null) {
            attrNode.setNodeValue(value);
        } else {
            element.setAttribute(name, value);
        }
    }
}

