/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.osgi.BundleClassloaderWrapper;
import org.pentaho.di.osgi.OSGIKettleLifecycleListener;
import org.pentaho.di.osgi.OSGIPlugin;
import org.pentaho.di.osgi.OSGIPluginTrackerException;
import org.pentaho.di.osgi.ServiceReferenceListener;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.lifecycle.OSGIServiceLifecycleListener;
import org.pentaho.di.osgi.service.listener.BundleContextServiceListener;
import org.pentaho.di.osgi.service.notifier.AggregatingNotifierListener;
import org.pentaho.di.osgi.service.notifier.DelayedInstanceNotifierFactory;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifier;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.di.osgi.service.tracker.OSGIServiceTracker;
import org.pentaho.osgi.api.BeanFactory;
import org.pentaho.osgi.api.BeanFactoryLocator;
import org.pentaho.osgi.api.ProxyUnwrapper;

public class OSGIPluginTracker {
    private static OSGIPluginTracker INSTANCE = new OSGIPluginTracker();
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("OSGIPluginTracker pool");
            return thread;
        }
    });
    private final AggregatingNotifierListener aggregatingNotifierListener;
    private BundleContext context;
    private BeanFactoryLocator lookup;
    private ProxyUnwrapper proxyUnwrapper;
    private Map<Class, OSGIServiceTracker> trackers = new WeakHashMap<Class, OSGIServiceTracker>();
    private Map<Class, List<OSGIServiceLifecycleListener>> listeners = new WeakHashMap<Class, List<OSGIServiceLifecycleListener>>();
    private Map<Object, List<ServiceReferenceListener>> instanceListeners = new WeakHashMap<Object, List<ServiceReferenceListener>>();
    private Map<Object, ServiceReference> instanceToReferenceMap = new MapMaker().weakKeys().weakValues().makeMap();
    private Map<ServiceReference, Object> referenceToInstanceMap = new MapMaker().weakKeys().weakValues().makeMap();
    private Map<BeanFactory, Bundle> beanFactoryToBundleMap = new MapMaker().weakKeys().weakValues().makeMap();
    private Map<Object, BeanFactory> beanToFactoryMap = new MapMaker().weakKeys().weakValues().makeMap();
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private List<Class<? extends PluginTypeInterface>> queuedClasses = new ArrayList<Class<? extends PluginTypeInterface>>();

    @VisibleForTesting
    protected OSGIPluginTracker() {
        this(new AggregatingNotifierListener());
    }

    @VisibleForTesting
    protected OSGIPluginTracker(AggregatingNotifierListener aggregatingNotifierListener) {
        this.aggregatingNotifierListener = aggregatingNotifierListener;
    }

    public static OSGIPluginTracker getInstance() {
        return INSTANCE;
    }

    public <T> List<T> getServiceObjects(Class<T> clazz, Map<String, String> props) {
        ArrayList<Object> services = new ArrayList<Object>();
        String propsString = this.createFilterString(props);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(clazz.getName(), propsString);
            if (refs == null) {
                return Collections.emptyList();
            }
            for (ServiceReference ref : refs) {
                Object instance = null;
                try {
                    instance = this.context.getService(ref);
                    instance = this.getProxyUnwrapper().unwrap(instance);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.instanceToReferenceMap.put(instance, ref);
                this.referenceToInstanceMap.put(ref, instance);
                services.add(instance);
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return services;
    }

    private String createFilterString(Map<String, String> props) {
        StringBuffer sb = new StringBuffer();
        boolean firstProp = true;
        for (Map.Entry<String, String> prop : props.entrySet()) {
            if (firstProp) {
                sb.append("(");
            }
            sb.append("&");
            sb.append("(" + prop.getKey() + "=" + prop.getValue() + ")");
            if (firstProp) {
                sb.append(")");
            }
            firstProp = false;
        }
        return sb.toString();
    }

    public <T> T getBean(Class<T> clazz, Object serviceClass, String id) {
        BeanFactory factory = null;
        try {
            factory = this.findOrCreateBeanFactoryFor(serviceClass);
        }
        catch (OSGIPluginTrackerException e) {
            this.logger.error((Object)e);
            return null;
        }
        if (factory == null) {
            return null;
        }
        Object instance = factory.getInstance(id, clazz);
        this.beanToFactoryMap.put(instance, factory);
        return (T)instance;
    }

    public <T extends PluginTypeInterface> Object getBeanPluginProperty(Class<? extends PluginTypeInterface> pluginType, Object instance, String prop) {
        try {
            BeanFactory beanFactory = this.beanToFactoryMap.get(instance);
            if (beanFactory == null) {
                return null;
            }
            Bundle bundle = this.beanFactoryToBundleMap.get(beanFactory);
            BundleContext cxt = bundle.getBundleContext();
            ServiceReference[] registeredServices = bundle.getRegisteredServices();
            if (registeredServices == null) {
                return null;
            }
            for (ServiceReference registeredService : registeredServices) {
                String proVal;
                Object registeredServiceProperty = registeredService.getProperty("objectClass");
                String string = proVal = registeredServiceProperty instanceof String ? (String)registeredServiceProperty : ((String[])registeredServiceProperty)[0];
                if (!proVal.equals(PluginInterface.class.getName()) || !registeredService.getProperty("PluginType").equals(pluginType.getName())) continue;
                Object service = cxt.getService(registeredService);
                if (service instanceof OSGIPlugin && "ID".equalsIgnoreCase(prop)) {
                    return ((OSGIPlugin)service).getID();
                }
                return BeanUtils.getProperty((Object)service, (String)prop);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ClassLoader getClassLoader(Object instance) {
        try {
            ServiceReference ref = this.instanceToReferenceMap.get(instance);
            if (ref == null) {
                return null;
            }
            Bundle bundle = ref.getBundle();
            return new BundleClassloaderWrapper(bundle);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setBeanFactoryLookup(BeanFactoryLocator lookup) {
        this.lookup = lookup;
    }

    public ProxyUnwrapper getProxyUnwrapper() {
        if (this.proxyUnwrapper == null) {
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(this.context, ProxyUnwrapper.class, null);){
                tracker.waitForService(30000L);
                this.proxyUnwrapper = (ProxyUnwrapper)tracker.getService();
            }
        }
        return this.proxyUnwrapper;
    }

    public void setProxyUnwrapper(ProxyUnwrapper proxyUnwrapper) {
        this.proxyUnwrapper = proxyUnwrapper;
    }

    public BeanFactory findOrCreateBeanFactoryFor(Object serviceObject) throws OSGIPluginTrackerException {
        if (this.lookup == null) {
            this.logger.debug((Object)"BeanFactoryLookup is currently not set, returning null");
            return null;
        }
        ServiceReference reference = this.instanceToReferenceMap.get(serviceObject);
        if (reference == null) {
            throw new OSGIPluginTrackerException("Service Reference is null. This is fatal.");
        }
        Bundle objectBundle = reference.getBundle();
        if (objectBundle == null) {
            throw new OSGIPluginTrackerException("Service's Bundle is null, service no longer valid.");
        }
        BeanFactory factory = this.lookup.getBeanFactory(objectBundle);
        if (factory == null) {
            return null;
        }
        this.beanFactoryToBundleMap.put(factory, objectBundle);
        return factory;
    }

    public void shutdown() {
        for (Map.Entry<Class, OSGIServiceTracker> entry : this.trackers.entrySet()) {
            entry.getValue().close();
        }
    }

    public void addPluginLifecycleListener(Class clazzToTrack, OSGIServiceLifecycleListener listener) {
        List<OSGIServiceLifecycleListener> list = this.listeners.get(clazzToTrack);
        if (list == null) {
            list = new ArrayList<OSGIServiceLifecycleListener>();
            this.listeners.put(clazzToTrack, list);
        }
        list.add(listener);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
        for (OSGIServiceTracker oSGIServiceTracker : this.trackers.values()) {
            oSGIServiceTracker.close();
        }
        this.trackers.clear();
        context.addServiceListener((ServiceListener)new BundleContextServiceListener(this.referenceToInstanceMap, new DelayedInstanceNotifierFactory(this.instanceListeners, scheduler, this)));
        for (Class clazz : this.queuedClasses) {
            this.registerPluginClass(clazz);
        }
        OSGIKettleLifecycleListener.setDoneInitializing();
    }

    public boolean registerPluginClass(Class clazz) {
        if (this.trackers.get(clazz) != null) {
            return true;
        }
        if (this.getBundleContext() == null) {
            this.queuedClasses.add(clazz);
            return false;
        }
        if (this.listeners.get(clazz) == null) {
            this.listeners.put(clazz, new ArrayList());
        }
        OSGIServiceTracker tracker = new OSGIServiceTracker(this, clazz);
        tracker.open();
        tracker = new OSGIServiceTracker(this, clazz, true);
        tracker.open();
        this.trackers.put(clazz, tracker);
        return true;
    }

    public void serviceChanged(Class<?> cls, LifecycleEvent evt, ServiceReference serviceObject) {
        Object instance = null;
        try {
            instance = this.context.getService(serviceObject);
            instance = this.getProxyUnwrapper().unwrap(instance);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (instance == null) {
            instance = this.referenceToInstanceMap.get(serviceObject);
        }
        if (instance == null) {
            return;
        }
        this.instanceToReferenceMap.put(instance, serviceObject);
        this.referenceToInstanceMap.put(serviceObject, instance);
        this.aggregatingNotifierListener.incrementCount();
        new DelayedServiceNotifier(this, cls, evt, instance, this.listeners, scheduler, this.aggregatingNotifierListener).run();
    }

    public boolean addDelayedServiceNotifierListener(DelayedServiceNotifierListener delayedServiceNotifierListener) {
        return this.aggregatingNotifierListener.addListener(delayedServiceNotifierListener);
    }

    public boolean removeDelayedServiceNotifierListener(DelayedServiceNotifierListener delayedServiceNotifierListener) {
        return this.aggregatingNotifierListener.removeListener(delayedServiceNotifierListener);
    }

    public int getOutstandingServiceNotifierListeners() {
        return this.aggregatingNotifierListener.getCount();
    }

    protected void setLogger(Log logger) {
        this.logger = logger;
    }

    protected Map<Class, OSGIServiceTracker> getTrackers() {
        return this.trackers;
    }
}

