/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.tracker;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIServiceTracker
extends ServiceTracker {
    private final Class clazzToTrack;
    private final List<ServiceReference> references = new ArrayList<ServiceReference>();
    private final BundleContext context;
    private final OSGIPluginTracker tracker;
    private static final Logger logger = LoggerFactory.getLogger(OSGIServiceTracker.class);

    public OSGIServiceTracker(OSGIPluginTracker tracker, Class clazzToTrack) {
        this(tracker, clazzToTrack, false);
    }

    public OSGIServiceTracker(OSGIPluginTracker osgiPluginTracker, Class clazzToTrack, boolean asPluginInterface) {
        super(osgiPluginTracker.getBundleContext(), OSGIServiceTracker.createFilter(osgiPluginTracker.getBundleContext(), clazzToTrack, asPluginInterface), null);
        this.tracker = osgiPluginTracker;
        this.clazzToTrack = clazzToTrack;
        this.context = this.tracker.getBundleContext();
    }

    private static Filter createFilter(BundleContext context, Class<?> clazzToTrack, boolean asPluginInterface) {
        try {
            return context.createFilter(asPluginInterface ? "(&(objectClass=" + PluginInterface.class.getName() + ")(PluginType=" + clazzToTrack.getName() + "))" : "(objectClass=" + clazzToTrack.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            logger.error("Error creating Service Filter", (Throwable)e);
            return null;
        }
    }

    public Object addingService(ServiceReference reference) {
        this.references.add(reference);
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.START, reference);
        Object retVal = super.addingService(reference);
        return retVal;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.references.remove(reference);
        try {
            this.notifySuperOfRemoval(reference, service);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.STOP, reference);
    }

    void notifySuperOfRemoval(ServiceReference reference, Object service) {
        super.removedService(reference, service);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.MODIFY, reference);
        super.modifiedService(reference, service);
    }
}

