/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.hive.job;

import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.log4j.Appender;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="HiveJobExecutorPlugin", image="AWS-HIVE.svg", name="HiveJobExecutorPlugin.Name", description="HiveJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", documentationUrl="http://wiki.pentaho.com/display/EAI/Amazon+Hive+Job+Executor", i18nPackageName="org.pentaho.amazon.hive.job")
public class AmazonHiveJobExecutor
extends AbstractAmazonJobEntry
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = AmazonHiveJobExecutor.class;
    protected String qUrl = "";
    protected String bootstrapActions = "";
    protected boolean alive;

    public String getQUrl() {
        return this.qUrl;
    }

    public void setQUrl(String qUrl) {
        this.qUrl = qUrl;
    }

    public String getBootstrapActions() {
        return this.bootstrapActions;
    }

    public void setBootstrapActions(String bootstrapActions) {
        this.bootstrapActions = bootstrapActions;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Result execute(Result result, int arg1) throws KettleException {
        Log4jFileAppender appender;
        block22: {
            appender = null;
            String logFileName = "pdi-" + this.getName();
            try {
                appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
                LogWriter.getInstance().addAppender((Appender)appender);
                this.log.setLogLevel(this.parentJob.getLogLevel());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            try {
                AmazonElasticMapReduceClient emrClient = new AmazonElasticMapReduceClient(this.awsCredentials);
                AmazonS3Client s3Client = new AmazonS3Client(this.awsCredentials);
                String stagingBucketName = this.GetBucketName(this.stagingDir);
                String stagingS3BucketUrl = "s3://" + stagingBucketName;
                String stagingS3qUrl = "";
                if (this.qUrl.startsWith("s3://")) {
                    stagingS3qUrl = this.qUrl.indexOf("@s3") > 0 ? "s3://" + this.qUrl.substring(this.qUrl.indexOf("@s3") + 4) : this.qUrl;
                } else {
                    if (!this.qUrl.startsWith("file:") && this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.HiveScriptFilename.Error", (String[])new String[0]) + this.qUrl);
                    }
                    FileObject qFile = KettleVFS.getFileObject((String)this.buildFilename(this.qUrl));
                    File tmpFile = File.createTempFile("customEMR", "q");
                    tmpFile.deleteOnExit();
                    FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
                    IOUtils.copy((InputStream)qFile.getContent().getInputStream(), (OutputStream)tmpFileOut);
                    String key = this.GetKeyFromS3Url(this.stagingDir);
                    key = key == null ? qFile.getName().getBaseName() : key + "/" + qFile.getName().getBaseName();
                    try {
                        s3Client.deleteObject(stagingBucketName, key);
                    }
                    catch (Exception ex) {
                        this.logError(Const.getStackTracker((Throwable)ex));
                    }
                    s3Client.putObject(new PutObjectRequest(stagingBucketName, key, tmpFile));
                    stagingS3qUrl = stagingS3BucketUrl + "/" + key;
                }
                this.jarUrl = "s3://elasticmapreduce/libs/script-runner/script-runner.jar";
                RunJobFlowRequest runJobFlowRequest = null;
                RunJobFlowResult runJobFlowResult = null;
                if (StringUtil.isEmpty((String)this.hadoopJobFlowId)) {
                    runJobFlowRequest = this.createJobFlow();
                    runJobFlowResult = emrClient.runJobFlow(runJobFlowRequest);
                    this.hadoopJobFlowId = runJobFlowResult.getJobFlowId();
                }
                ArrayList<String> jobFlowIds = new ArrayList<String>();
                jobFlowIds.add(this.hadoopJobFlowId);
                String args = "s3://elasticmapreduce/libs/hive/hive-script --base-path s3://elasticmapreduce/libs/hive/ --hive-version 0.7 --run-hive-script --args -f " + this.environmentSubstitute(stagingS3qUrl) + " " + this.environmentSubstitute(this.cmdLineArgs);
                List<StepConfig> steps = this.ConfigHadoopJarStep(this.hadoopJobName, this.jarUrl, args);
                AddJobFlowStepsRequest addJobFlowStepsRequest = new AddJobFlowStepsRequest();
                addJobFlowStepsRequest.setJobFlowId(this.hadoopJobFlowId);
                addJobFlowStepsRequest.setSteps(steps);
                emrClient.addJobFlowSteps(addJobFlowStepsRequest);
                String loggingIntervalS = this.environmentSubstitute(this.loggingInterval);
                int logIntv = 10;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.LoggingInterval.Error", (String[])new String[]{loggingIntervalS}));
                }
                if (!this.blocking) break block22;
                try {
                    if (this.log.isBasic()) {
                        String executionState = "RUNNING";
                        while (AmazonHiveJobExecutor.isRunning(executionState)) {
                            DescribeJobFlowsRequest describeJobFlowsRequest = new DescribeJobFlowsRequest();
                            describeJobFlowsRequest.setJobFlowIds(jobFlowIds);
                            DescribeJobFlowsResult describeJobFlowsResult = emrClient.describeJobFlows(describeJobFlowsRequest);
                            boolean found = false;
                            for (JobFlowDetail jobFlowDetail : describeJobFlowsResult.getJobFlows()) {
                                if (!jobFlowDetail.getJobFlowId().equals(this.hadoopJobFlowId)) continue;
                                executionState = jobFlowDetail.getExecutionStatusDetail().getState();
                                found = true;
                            }
                            if (!found) break;
                            this.logBasic(this.hadoopJobName + " " + BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.JobFlowExecutionStatus", (String[])new String[]{this.hadoopJobFlowId}) + executionState);
                            if (this.parentJob.isStopped()) {
                                if (this.alive) break;
                                TerminateJobFlowsRequest terminateJobFlowsRequest = new TerminateJobFlowsRequest();
                                terminateJobFlowsRequest.withJobFlowIds(new String[]{this.hadoopJobFlowId});
                                emrClient.terminateJobFlows(terminateJobFlowsRequest);
                                break;
                            }
                            try {
                                if (!AmazonHiveJobExecutor.isRunning(executionState)) continue;
                                Thread.sleep(logIntv * 1000);
                            }
                            catch (InterruptedException ie) {
                                this.logError(Const.getStackTracker((Throwable)ie));
                            }
                        }
                        if ("FAILED".equalsIgnoreCase(executionState)) {
                            result.setStopped(true);
                            result.setNrErrors(1L);
                            result.setResult(false);
                            S3Object outObject = s3Client.getObject(stagingBucketName, this.hadoopJobFlowId + "/steps/1/stdout");
                            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)outObject.getObjectContent(), (OutputStream)outStream);
                            this.logError(outStream.toString());
                            S3Object errorObject = s3Client.getObject(stagingBucketName, this.hadoopJobFlowId + "/steps/1/stderr");
                            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)errorObject.getObjectContent(), (OutputStream)errorStream);
                            this.logError(errorStream.toString());
                        }
                    }
                }
                catch (Exception e) {
                    this.logError(e.getMessage(), e);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(t.getMessage(), t);
            }
        }
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
            ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    public RunJobFlowRequest createJobFlow() {
        RunJobFlowRequest runJobFlowRequest = new RunJobFlowRequest();
        runJobFlowRequest.setName(this.hadoopJobName);
        String logUrl = this.stagingDir;
        if (this.stagingDir.indexOf("@s3") > 0) {
            logUrl = "s3://" + this.stagingDir.substring(this.stagingDir.indexOf("@s3") + 4);
        }
        runJobFlowRequest.setLogUri(logUrl);
        String numInstancesS = this.environmentSubstitute(this.numInstances);
        int numInsts = 2;
        try {
            numInsts = Integer.parseInt(numInstancesS);
        }
        catch (NumberFormatException e) {
            this.logError(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.InstanceNumber.Error", (String[])new String[]{numInstancesS}));
        }
        JobFlowInstancesConfig instances = new JobFlowInstancesConfig();
        instances.setInstanceCount(Integer.valueOf(numInsts));
        instances.setMasterInstanceType(AmazonHiveJobExecutor.getInstanceType(this.masterInstanceType));
        instances.setSlaveInstanceType(AmazonHiveJobExecutor.getInstanceType(this.slaveInstanceType));
        instances.setHadoopVersion("0.20");
        instances.setKeepJobFlowAliveWhenNoSteps(Boolean.valueOf(this.alive));
        runJobFlowRequest.setInstances(instances);
        runJobFlowRequest.setBootstrapActions(this.ConfigBootstrapActions());
        String args = "s3://elasticmapreduce/libs/hive/hive-script --base-path s3://elasticmapreduce/libs/hive/ --hive-versions 0.7 --install-hive";
        List<StepConfig> steps = this.ConfigHadoopJarStep("Setup Hive", this.jarUrl, args);
        runJobFlowRequest.setSteps(steps);
        return runJobFlowRequest;
    }

    public List<BootstrapActionConfig> ConfigBootstrapActions() {
        ArrayList<BootstrapActionConfig> bootstrapActionConfigs = new ArrayList<BootstrapActionConfig>();
        if (!StringUtil.isEmpty((String)this.bootstrapActions)) {
            StringTokenizer st = new StringTokenizer(this.bootstrapActions, " ");
            String path = "";
            String name = "";
            List<String> args = null;
            int actionCount = 0;
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String value = st.nextToken();
                if (value.startsWith("\"")) {
                    while (!value.endsWith("\"")) {
                        if (st.hasMoreTokens()) {
                            value = value + " " + st.nextToken();
                            continue;
                        }
                        if (this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.BootstrapActionArgument.Error", (String[])new String[]{key, value}));
                        }
                        return null;
                    }
                    value = value.substring(1, value.length() - 1);
                }
                if (key.equals("--bootstrap-action")) {
                    if (!Const.isEmpty((String)path)) {
                        ++actionCount;
                        if (name.equals("")) {
                            name = "Bootstrap Action " + actionCount;
                        }
                        BootstrapActionConfig bootstrapActionConfig = this.ConfigureBootstrapAction(path, name, args);
                        bootstrapActionConfigs.add(bootstrapActionConfig);
                        name = "";
                        args = null;
                    }
                    if (value.startsWith("s3://")) {
                        path = value;
                    } else {
                        if (this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.BootstrapActionPath.Error", (String[])new String[]{key, value}));
                        }
                        return null;
                    }
                }
                if (key.equals("--bootstrap-name")) {
                    name = value;
                }
                if (!key.equals("--args")) continue;
                args = this.ConfigArgs(value, ",");
            }
            if (!Const.isEmpty((String)path)) {
                ++actionCount;
                if (name.equals("")) {
                    name = "Bootstrap Action " + actionCount;
                }
                BootstrapActionConfig bootstrapActionConfig = this.ConfigureBootstrapAction(path, name, args);
                bootstrapActionConfigs.add(bootstrapActionConfig);
            }
        }
        return bootstrapActionConfigs;
    }

    BootstrapActionConfig ConfigureBootstrapAction(String path, String name, List<String> args) {
        ScriptBootstrapActionConfig scriptBootstrapActionConfig = new ScriptBootstrapActionConfig();
        BootstrapActionConfig bootstrapActionConfig = new BootstrapActionConfig();
        scriptBootstrapActionConfig.setPath(path);
        scriptBootstrapActionConfig.setArgs(args);
        bootstrapActionConfig.setName(name);
        bootstrapActionConfig.setScriptBootstrapAction(scriptBootstrapActionConfig);
        return bootstrapActionConfig;
    }

    public List<StepConfig> ConfigHadoopJarStep(String stepName, String stagingS3JarUrl, String args) {
        List<Object> jarStepArgs = new ArrayList();
        jarStepArgs = this.ConfigArgs(args, " ");
        HadoopJarStepConfig hadoopJarStep = new HadoopJarStepConfig();
        hadoopJarStep.setJar(stagingS3JarUrl);
        hadoopJarStep.setArgs(jarStepArgs);
        StepConfig stepConfig = new StepConfig();
        stepConfig.setName(stepName);
        stepConfig.setHadoopJarStep(hadoopJarStep);
        if (this.isAlive()) {
            stepConfig.setActionOnFailure("CANCEL_AND_WAIT");
        } else {
            stepConfig.setActionOnFailure("TERMINATE_JOB_FLOW");
        }
        ArrayList<StepConfig> steps = new ArrayList<StepConfig>();
        steps.add(stepConfig);
        return steps;
    }

    public List<String> ConfigArgs(String args, String separator) {
        ArrayList<String> argList = new ArrayList<String>();
        if (!StringUtil.isEmpty((String)args)) {
            StringTokenizer st = new StringTokenizer(args, separator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.AddingArgument", (String[])new String[0]) + token);
                }
                argList.add(token);
            }
        }
        return argList;
    }

    public static String getInstanceType(String unparsedInstanceType) {
        return unparsedInstanceType.substring(unparsedInstanceType.lastIndexOf("[") + 1, unparsedInstanceType.lastIndexOf("]"));
    }

    public static boolean isRunning(String state) {
        if ("COMPLETED".equalsIgnoreCase(state)) {
            return false;
        }
        if ("FAILED".equalsIgnoreCase(state)) {
            return false;
        }
        return !"TERMINATED".equalsIgnoreCase(state);
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.hadoopJobFlowId = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_flow_id");
        this.qUrl = XMLHandler.getTagValue((Node)entrynode, (String)"q_url");
        this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"access_key"));
        this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"secret_key"));
        this.bootstrapActions = XMLHandler.getTagValue((Node)entrynode, (String)"bootstrap_actions");
        this.stagingDir = XMLHandler.getTagValue((Node)entrynode, (String)"staging_dir");
        this.numInstances = XMLHandler.getTagValue((Node)entrynode, (String)"num_instances");
        this.masterInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"master_instance_type");
        this.slaveInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"slave_instance_type");
        this.cmdLineArgs = XMLHandler.getTagValue((Node)entrynode, (String)"command_line_args");
        this.alive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"alive"));
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_flow_id", (String)this.hadoopJobFlowId));
        retval.append("      ").append(XMLHandler.addTagValue((String)"q_url", (String)this.qUrl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"access_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"secret_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bootstrap_actions", (String)this.bootstrapActions));
        retval.append("      ").append(XMLHandler.addTagValue((String)"staging_dir", (String)this.stagingDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_instances", (String)this.numInstances));
        retval.append("      ").append(XMLHandler.addTagValue((String)"master_instance_type", (String)this.masterInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_instance_type", (String)this.slaveInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"command_line_args", (String)this.cmdLineArgs));
        retval.append("      ").append(XMLHandler.addTagValue((String)"alive", (boolean)this.alive));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        return retval.toString();
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.LoadFromRepository.Error", (String[])new String[0]));
        }
        super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
        this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
        this.setHadoopJobFlowId(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_flow_id"));
        this.setQUrl(rep.getJobEntryAttributeString(id_jobentry, "q_url"));
        this.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "access_key")));
        this.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "secret_key")));
        this.setBootstrapActions(rep.getJobEntryAttributeString(id_jobentry, "bootstrap_actions"));
        this.setStagingDir(rep.getJobEntryAttributeString(id_jobentry, "staging_dir"));
        this.setNumInstances(rep.getJobEntryAttributeString(id_jobentry, "num_instances"));
        this.setMasterInstanceType(rep.getJobEntryAttributeString(id_jobentry, "master_instance_type"));
        this.setSlaveInstanceType(rep.getJobEntryAttributeString(id_jobentry, "slave_instance_type"));
        this.setCmdLineArgs(rep.getJobEntryAttributeString(id_jobentry, "command_line_args"));
        this.setAlive(rep.getJobEntryAttributeBoolean(id_jobentry, "alive"));
        this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
        this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        if (rep == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.SaveToRepository.Error", (String[])new String[0]));
        }
        super.saveRep(rep, metaStore, id_job);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_flow_id", this.hadoopJobFlowId);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "q_url", this.qUrl);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "secret_key", Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "access_key", Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "bootstrap_actions", this.bootstrapActions);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "staging_dir", this.stagingDir);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_instances", this.numInstances);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "master_instance_type", this.masterInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "slave_instance_type", this.slaveInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "command_line_args", this.cmdLineArgs);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "alive", this.alive);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
    }

    public String buildFilename(String filename) {
        if ((filename = this.environmentSubstitute(filename)).startsWith("s3")) {
            String authPart = filename.substring("s3".length() + 3, filename.indexOf("@s3")).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
            filename = "s3://" + authPart + "@s3" + filename.substring(filename.indexOf("@s3") + 3);
        }
        return filename;
    }

    public String buildFullS3Url(String filename) {
        if (filename.startsWith("s3://") && !filename.startsWith("s3:///")) {
            String authPart = this.accessKey + ":" + this.secretKey;
            authPart = authPart.replaceAll("\\+", "%2B").replaceAll("/", "%2F");
            filename = "s3://" + authPart + "@s3" + filename.substring(5);
        }
        return filename;
    }

    public String GetBucketName(String filename) {
        int i = filename.indexOf("@s3/") + 4;
        if (i > 4) {
            int j = filename.indexOf("/", i);
            if (i < j) {
                return filename.substring(i, j);
            }
            return filename.substring(i);
        }
        i = filename.indexOf("/", 5);
        if (i > 5) {
            return filename.substring(5, i);
        }
        return filename.substring(5);
    }

    public String GetKeyFromS3Url(String filename) {
        int i = filename.indexOf("@s3/") + 4;
        filename = i > 4 ? filename.substring(filename.indexOf("/", i) + 1) : filename.substring(filename.indexOf("/", 5) + 1);
        return filename;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.job\\.", ".ui.");
        className = className + "Dialog";
        return className;
    }
}

