/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.namedcluster.HadoopClusterDelegate;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.spoon.SelectionTreeExtension;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

@ExtensionPoint(id="HadoopClusterViewTreeExtension", description="Refreshes named cluster subtree", extensionPointId="SpoonViewTreeExtension")
public class HadoopClusterViewTreeExtension
implements ExtensionPointInterface {
    private Spoon spoon = null;
    private Future<HadoopClusterDelegate> ncDelegate = null;
    private Image hadoopClusterImage = null;
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(HadoopClusterViewTreeExtension.class, (String)"NamedClusterDialog.STRING_NAMED_CLUSTERS", (String[])new String[0]);
    private LogChannelInterface log = new LogChannel((Object)HadoopClusterViewTreeExtension.class.getName());

    public HadoopClusterViewTreeExtension() {
        this.spoon = Spoon.getInstance();
        this.ncDelegate = ExecutorUtil.getExecutor().submit(new Callable<HadoopClusterDelegate>(){

            @Override
            public HadoopClusterDelegate call() throws Exception {
                return NamedClusterUIHelper.getNamedClusterUIFactory().createHadoopClusterDelegate(HadoopClusterViewTreeExtension.this.spoon);
            }
        });
        this.hadoopClusterImage = this.getHadoopClusterImage(this.spoon.getDisplay());
    }

    public void callExtensionPoint(LogChannelInterface log, Object extension) throws KettleException {
        SelectionTreeExtension selectionTreeExtension = (SelectionTreeExtension)extension;
        if (selectionTreeExtension.getAction().equals("REFRESH_SELECTION_EXTENSION")) {
            this.refreshNamedClusterSubtree(selectionTreeExtension);
        }
        if (selectionTreeExtension.getAction().equals("EDIT_SELECTION_EXTENSION")) {
            this.editNamedCluster(selectionTreeExtension);
        }
    }

    private void editNamedCluster(SelectionTreeExtension selectionTreeExtension) throws KettleException {
        Object selection = selectionTreeExtension.getSelection();
        if (selection instanceof NamedCluster) {
            NamedCluster selectedNamedCluster = (NamedCluster)selection;
            try {
                this.ncDelegate.get().editNamedCluster((IMetaStore)this.spoon.metaStore, selectedNamedCluster, this.spoon.getShell());
            }
            catch (InterruptedException e) {
                throw new KettleException("Interrupted while waiting on " + HadoopClusterDelegate.class.getCanonicalName(), (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new KettleException("Execution exception getting " + HadoopClusterDelegate.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    private void refreshNamedClusterSubtree(SelectionTreeExtension selectionTreeExtension) {
        List<NamedCluster> namedClusters;
        TreeItem tiRootName = selectionTreeExtension.getTiRootName();
        GUIResource guiResource = selectionTreeExtension.getGuiResource();
        TreeItem tiNcTitle = this.createTreeItem(tiRootName, STRING_NAMED_CLUSTERS, guiResource.getImageFolder());
        try {
            namedClusters = NamedClusterManager.getInstance().list((IMetaStore)this.spoon.metaStore);
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.NamedCluster", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (NamedCluster namedCluster : namedClusters) {
            if (!this.filterMatch(namedCluster.getName())) continue;
            this.createTreeItem(tiNcTitle, namedCluster.getName(), this.hadoopClusterImage);
        }
    }

    private TreeItem createTreeItem(TreeItem parent, String text, Image image) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        item.setImage(image);
        return item;
    }

    boolean filterMatch(String string) {
        if (Const.isEmpty((String)string)) {
            return true;
        }
        String filter = this.spoon.selectionFilter.getText();
        if (Const.isEmpty((String)filter)) {
            return true;
        }
        try {
            if (string.matches(filter)) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.logError("Not a valid pattern [" + filter + "] : " + e.getMessage());
        }
        return string.toUpperCase().contains(filter.toUpperCase());
    }

    private Image getHadoopClusterImage(Display display) {
        final SwtUniversalImage swtImage = SwtSvgImageUtil.getUniversalImage((Display)display, (ClassLoader)this.getClass().getClassLoader(), (String)"hadoop_clusters.svg");
        Image image = swtImage.getAsBitmapForSize((Device)display, 24, 24);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                swtImage.dispose();
            }
        });
        return image;
    }
}

