/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.oozie;

import java.util.Properties;
import org.apache.oozie.client.OozieClient;
import org.pentaho.di.job.entries.oozie.OozieJobInfoImpl;
import org.pentaho.oozie.shim.api.OozieClientException;
import org.pentaho.oozie.shim.api.OozieJob;

public class OozieClientImpl
implements org.pentaho.oozie.shim.api.OozieClient {
    private final OozieClient delegate;

    public OozieClientImpl(OozieClient delegate) {
        this.delegate = delegate;
    }

    public String getClientBuildVersion() {
        return this.delegate.getClientBuildVersion();
    }

    public OozieJob getJob(String jobId) {
        return new OozieJobInfoImpl(jobId, this.delegate);
    }

    public String getProtocolUrl() throws OozieClientException {
        try {
            return this.delegate.getProtocolUrl();
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException(e.getCause(), e.getErrorCode());
        }
    }

    public boolean hasAppPath(Properties props) {
        return props.containsKey("oozie.wf.application.path") || props.containsKey("oozie.coord.application.path") || props.containsKey("oozie.bundle.application.path");
    }

    public OozieJob run(Properties props) throws OozieClientException {
        try {
            String jobId = this.delegate.run(props);
            return new OozieJobInfoImpl(jobId, this.delegate);
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException(e.getCause(), e.getErrorCode());
        }
    }

    public void validateWSVersion() throws OozieClientException {
        try {
            this.delegate.validateWSVersion();
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException(e.getCause(), e.getErrorCode());
        }
    }
}

