/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.couchdbinput;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInputData;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInputMeta;

public class CouchDbInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CouchDbInputMeta.class;
    private final HttpClientFactory httpClientFactory;
    private final GetMethodFactory getMethodFactory;
    private CouchDbInputMeta meta;
    private CouchDbInputData data;

    public CouchDbInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        this(stepMeta, stepDataInterface, copyNr, transMeta, trans, new HttpClientFactory(), new GetMethodFactory());
    }

    public CouchDbInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, HttpClientFactory httpClientFactory, GetMethodFactory getMethodFactory) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.httpClientFactory = httpClientFactory;
        this.getMethodFactory = getMethodFactory;
    }

    public static String buildUrl(String hostname, int port, String db, String design, String view) {
        String url = "http://" + hostname;
        if (port >= 0) {
            url = url + ":" + port;
        }
        url = url + "/" + db;
        url = url + "/_design/" + design;
        url = url + "/_view/" + view;
        return url;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            int c;
            boolean cont;
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                this.data.buffer = new StringBuilder(1000);
                this.data.open = 0;
                cont = true;
                c = this.data.bufferedInputStream.read();
                while (c >= 0 && cont && !this.isStopped()) {
                    this.data.buffer.append((char)c);
                    switch ((char)c) {
                        case '{': {
                            ++this.data.open;
                            if (this.data.open != 2) break;
                            this.logBasic("Read header: >>" + this.data.buffer.substring(0, this.data.buffer.length() - 1) + "<<");
                            this.data.buffer.delete(0, this.data.buffer.length() - 1);
                            cont = false;
                            break;
                        }
                        case '}': {
                            --this.data.open;
                            break;
                        }
                        case '\"': {
                            int prev = c;
                            c = this.data.bufferedInputStream.read();
                            while (c != 34 && prev != 92 && c >= 0) {
                                this.data.buffer.append((char)c);
                                prev = c;
                                c = this.data.bufferedInputStream.read();
                            }
                            break;
                        }
                    }
                    if (!cont) continue;
                    c = this.data.bufferedInputStream.read();
                }
                if (c < 0) {
                    this.setOutputDone();
                    return false;
                }
            }
            cont = true;
            c = this.data.bufferedInputStream.read();
            while (c >= 0 && cont && !this.isStopped()) {
                this.data.buffer.append((char)c);
                switch ((char)c) {
                    case '{': {
                        ++this.data.open;
                        if (this.data.open != 2) break;
                        this.sendBufferRow(false);
                        cont = false;
                        break;
                    }
                    case '}': {
                        --this.data.open;
                    }
                }
                if (!cont) continue;
                c = this.data.bufferedInputStream.read();
            }
            if (c < 0) {
                if (this.data.buffer.length() > 0) {
                    this.sendBufferRow(true);
                }
                this.setOutputDone();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new KettleException("Unable to read from the CouchDB REST web service", (Throwable)e);
        }
    }

    private void sendBufferRow(boolean lastRow) throws KettleStepException {
        int pos = this.data.buffer.length() - 2;
        if (lastRow) {
            pos = this.removeTrailingSpaces(this.data.buffer, pos);
            pos = this.removeTrailingCharacter(this.data.buffer, pos, '}');
            pos = this.removeTrailingSpaces(this.data.buffer, pos);
            pos = this.removeTrailingCharacter(this.data.buffer, pos, ']');
        }
        pos = this.removeTrailingSpaces(this.data.buffer, pos);
        pos = this.removeTrailingCharacter(this.data.buffer, pos, ',');
        String json = this.data.buffer.substring(0, pos + 1);
        this.data.buffer.delete(0, this.data.buffer.length() - 1);
        if (this.log.isDebug()) {
            this.logDebug("Read row: " + json);
        }
        Object[] row = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        int index = 0;
        row[index++] = json;
        this.putRow(this.data.outputRowMeta, row);
    }

    private int removeTrailingCharacter(StringBuilder buffer, int pos, char c) {
        if (this.data.buffer.charAt(pos) == c) {
            --pos;
        }
        return pos;
    }

    private int removeTrailingSpaces(StringBuilder buffer, int pos) {
        while (pos >= 0 && Const.isSpace((char)this.data.buffer.charAt(pos))) {
            --pos;
        }
        return pos;
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.meta = (CouchDbInputMeta)stepMetaInterface;
            this.data = (CouchDbInputData)stepDataInterface;
            String hostname = this.environmentSubstitute(this.meta.getHostname());
            int port = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)5984);
            String db = this.environmentSubstitute(this.meta.getDbName());
            String design = this.environmentSubstitute(this.meta.getDesignDocument());
            String view = this.environmentSubstitute(this.meta.getViewName());
            if (Const.isEmpty((String)design)) {
                this.log.logError("Please provide a design document to use");
                return false;
            }
            if (Const.isEmpty((String)view)) {
                this.log.logError("Please provide a view name to look at");
                return false;
            }
            String realUser = this.environmentSubstitute(this.meta.getAuthenticationUser());
            String realPass = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getAuthenticationPassword()));
            String url = CouchDbInput.buildUrl(hostname, port, db, design, view);
            this.logBasic("Querying CouchDB view on URL: " + url);
            try {
                HttpClient client = this.httpClientFactory.createHttpClient();
                if (!Const.isEmpty((String)realUser)) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(realUser, realPass);
                    client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
                    client.getParams().setAuthenticationPreemptive(true);
                }
                HttpMethod method = this.getMethodFactory.create(url);
                this.data.inputStream = null;
                this.data.bufferedInputStream = null;
                int result = client.executeMethod(method);
                this.data.inputStream = method.getResponseBodyAsStream();
                this.data.bufferedInputStream = new BufferedInputStream(this.data.inputStream, 1000);
                if (result < 200 || result >= 300) {
                    int c;
                    StringBuilder err = new StringBuilder();
                    while ((c = this.data.bufferedInputStream.read()) >= 0) {
                        err.append((char)c);
                    }
                    this.logError("Web request returned code " + result + " : " + err.toString());
                    return false;
                }
                this.data.counter = 0;
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CouchDbInput.ErrorConnectingToCouchDb.Exception", (String[])new String[]{hostname, "" + port, db, view}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.bufferedInputStream != null) {
            try {
                this.data.bufferedInputStream.close();
            }
            catch (Exception e) {
                this.setErrors(1L);
                this.logError("Error closing data stream", e);
            }
        }
        super.dispose(smi, sdi);
    }

    static class GetMethodFactory {
        GetMethodFactory() {
        }

        public HttpMethod create(String url) {
            return new GetMethod(url);
        }
    }

    static class HttpClientFactory {
        HttpClientFactory() {
        }

        public HttpClient createHttpClient() {
            return SlaveConnectionManager.getInstance().createHttpClient();
        }
    }
}

