/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.hadoop.configuration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationInfo;
import org.pentaho.di.ui.hadoop.configuration.HadoopConfigurationRestartXulDialog;
import org.pentaho.di.ui.hadoop.configuration.HadoopConfigurationsXulDialog;
import org.pentaho.di.ui.hadoop.configuration.NoHadoopConfigurationsXulDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class HadoopConfigurationsController
extends AbstractXulEventHandler {
    public static final String HADOOP_CONFIGURATIONS_CONTROLLER = "hadoopConfigurationsController";
    private static final Log logger = LogFactory.getLog(HadoopConfigurationRestartXulDialog.class);

    public HadoopConfigurationsController() {
        this.setName(HADOOP_CONFIGURATIONS_CONTROLLER);
    }

    public void promptForShim() {
        final Spoon spoon = Spoon.getInstance();
        spoon.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    List<HadoopConfigurationInfo> hadoopConfigurationInfos = HadoopConfigurationBootstrap.getInstance().getHadoopConfigurationInfos();
                    Shell shell = spoon.getShell();
                    if (hadoopConfigurationInfos.size() == 0) {
                        new NoHadoopConfigurationsXulDialog(shell).open();
                    } else {
                        String shimId = new HadoopConfigurationsXulDialog(shell, hadoopConfigurationInfos).open();
                        if (!Const.isEmpty((String)shimId)) {
                            try {
                                HadoopConfigurationBootstrap.getInstance().setActiveShim(shimId);
                            }
                            catch (ConfigurationException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

