/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.LocalExecType;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRExecType;
import org.apache.pig.impl.util.PropertiesUtil;

public class ExecTypeProvider {
    private static final Log log = LogFactory.getLog(ExecTypeProvider.class);

    public static ExecType selectExecType(Properties properties) throws PigException {
        ServiceLoader<ExecType> frameworkLoader = ServiceLoader.load(ExecType.class);
        for (ExecType execType : frameworkLoader) {
            log.info((Object)("Trying ExecType : " + execType));
            if (execType.accepts(properties)) {
                log.info((Object)("Picked " + execType + " as the ExecType"));
                return ExecTypeProvider.getSingleton(execType);
            }
            log.debug((Object)("Cannot pick " + execType + " as the ExecType"));
        }
        throw new PigException("Unknown exec type: " + properties.getProperty("exectype"), 2040);
    }

    private static ExecType getSingleton(ExecType execType) {
        if (execType instanceof MRExecType) {
            return ExecType.MAPREDUCE;
        }
        if (execType instanceof LocalExecType) {
            return ExecType.LOCAL;
        }
        return execType;
    }

    public static ExecType fromString(String execType) throws PigException {
        Properties properties = PropertiesUtil.loadDefaultProperties();
        properties.setProperty("exectype", execType);
        return ExecTypeProvider.selectExecType(properties);
    }
}

