/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.AccumulativeTupleBuffer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.util.AccumulatorOptimizerUtil;
import org.apache.pig.data.AccumulativeBag;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;

public class POShuffleTezLoad
extends POPackage
implements TezInput {
    private static final long serialVersionUID = 1L;
    protected List<String> inputKeys = new ArrayList<String>();
    private boolean isSkewedJoin = false;
    private transient List<LogicalInput> inputs;
    private transient List<KeyValuesReader> readers;
    private transient int numTezInputs;
    private transient boolean[] finished;
    private transient boolean[] readOnce;
    private transient WritableComparator comparator = null;
    private transient Configuration conf;
    private transient int accumulativeBatchSize;

    public POShuffleTezLoad(POPackage pack) {
        super(pack);
    }

    @Override
    public String[] getTezInputs() {
        return this.inputKeys.toArray(new String[this.inputKeys.size()]);
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (this.inputKeys.remove(oldInputKey)) {
            this.inputKeys.add(newInputKey);
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        this.inputs = new ArrayList<LogicalInput>();
        this.readers = new ArrayList<KeyValuesReader>();
        this.comparator = (WritableComparator)ConfigUtils.getInputKeySecondaryGroupingComparator((Configuration)conf);
        this.accumulativeBatchSize = AccumulatorOptimizerUtil.getAccumulativeBatchSize();
        try {
            int i;
            for (String inputKey : this.inputKeys) {
                LogicalInput input = inputs.get(inputKey);
                if (this.inputs.contains(input)) continue;
                this.inputs.add(input);
                this.readers.add((KeyValuesReader)input.getReader());
            }
            this.numInputs = this.pkgr.getKeyInfo().size();
            this.numTezInputs = this.inputs.size();
            this.readOnce = new boolean[this.numInputs];
            for (i = 0; i < this.numInputs; ++i) {
                this.readOnce[i] = false;
            }
            this.finished = new boolean[this.numTezInputs];
            for (i = 0; i < this.numTezInputs; ++i) {
                this.finished[i] = !this.readers.get(i).next();
            }
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result res = this.pkgr.getNext();
        TezAccumulativeTupleBuffer buffer = null;
        if (this.isAccumulative()) {
            buffer = new TezAccumulativeTupleBuffer(this.accumulativeBatchSize);
        }
        while (res.returnStatus == 3) {
            boolean hasData = false;
            Object cur = null;
            PigNullableWritable min = null;
            int minIndex = -1;
            try {
                for (int i = 0; i < this.numTezInputs; ++i) {
                    if (this.finished[i]) continue;
                    hasData = true;
                    cur = this.readers.get(i).getCurrentKey();
                    if (min != null && this.comparator.compare((Object)min, cur) <= 0) continue;
                    min = ((PigNullableWritable)cur).clone();
                    minIndex = i;
                }
            }
            catch (Exception e) {
                throw new ExecException(e);
            }
            if (!hasData) {
                if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                    this.parentPlan.endOfAllInput = true;
                }
                return new Result(3, null);
            }
            this.key = this.pkgr.getKey(min);
            this.keyWritable = min;
            try {
                int i;
                DataBag[] bags = new DataBag[this.numInputs];
                if (this.isAccumulative()) {
                    buffer.setCurrentKey(min);
                    buffer.setCurrentKeyIndex(minIndex);
                    for (i = 0; i < this.numInputs; ++i) {
                        bags[i] = new AccumulativeBag(buffer, i);
                    }
                } else {
                    for (i = 0; i < this.numInputs; ++i) {
                        bags[i] = new InternalCachedBag(this.numInputs);
                    }
                    block8: for (i = 0; i < this.numTezInputs; ++i) {
                        if (this.finished[i]) continue;
                        cur = this.readers.get(i).getCurrentKey();
                        while (this.comparator.compare((Object)min, cur) == 0 && (!min.isNull() || min.isNull() && i == minIndex)) {
                            Iterable vals = this.readers.get(i).getCurrentValues();
                            for (Object val : vals) {
                                NullableTuple nTup = (NullableTuple)val;
                                byte index = nTup.getIndex();
                                Tuple tup = this.pkgr.getValueTuple(this.keyWritable, nTup, index);
                                bags[index].add(tup);
                            }
                            boolean bl = this.finished[i] = !this.readers.get(i).next();
                            if (this.finished[i]) continue block8;
                            cur = this.readers.get(i).getCurrentKey();
                        }
                    }
                }
                this.pkgr.attachInput(this.key, bags, this.readOnce);
                res = this.pkgr.getNext();
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
        }
        return res;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public void addInputKey(String inputKey) {
        this.inputKeys.add(inputKey);
    }

    public void setSkewedJoins(boolean isSkewedJoin) {
        this.isSkewedJoin = isSkewedJoin;
    }

    public boolean isSkewedJoin() {
        return this.isSkewedJoin;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    private class TezAccumulativeTupleBuffer
    implements AccumulativeTupleBuffer {
        private int batchSize;
        private List<Tuple>[] bags;
        private PigNullableWritable min;
        private int minIndex;
        private boolean clearedCurrent = true;

        public TezAccumulativeTupleBuffer(int batchSize) {
            this.batchSize = batchSize;
            this.bags = new List[POShuffleTezLoad.this.numInputs];
            for (int i = 0; i < POShuffleTezLoad.this.numInputs; ++i) {
                this.bags[i] = new ArrayList<Tuple>(batchSize);
            }
        }

        public void setCurrentKey(PigNullableWritable curKey) {
            if (!this.clearedCurrent) {
                this.clear();
            }
            this.min = curKey;
            this.clearedCurrent = false;
        }

        public void setCurrentKeyIndex(int curKeyIndex) {
            this.minIndex = curKeyIndex;
        }

        @Override
        public boolean hasNextBatch() {
            Object cur = null;
            try {
                for (int i = 0; i < POShuffleTezLoad.this.numTezInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentKey();
                    if (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) != 0 || this.min.isNull() && (!this.min.isNull() || i != this.minIndex)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while checking for next Accumulator batch", e);
            }
            return false;
        }

        @Override
        public void nextBatch() throws IOException {
            int i;
            Object cur = null;
            for (i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            try {
                block3: for (i = 0; i < POShuffleTezLoad.this.numTezInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentKey();
                    int batchCount = 0;
                    while (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) == 0 && (!this.min.isNull() || this.min.isNull() && i == this.minIndex)) {
                        Iterator iter = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentValues().iterator();
                        while (iter.hasNext() && batchCount < this.batchSize) {
                            NullableTuple nTup = (NullableTuple)iter.next();
                            byte index = nTup.getIndex();
                            this.bags[index].add(POShuffleTezLoad.this.pkgr.getValueTuple(POShuffleTezLoad.this.keyWritable, nTup, index));
                            ++batchCount;
                        }
                        if (batchCount == this.batchSize) {
                            if (iter.hasNext()) continue block3;
                            ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).next();
                            continue block3;
                        }
                        boolean bl = ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).next();
                        if (POShuffleTezLoad.this.finished[i]) continue block3;
                        cur = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentKey();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading next Accumulator batch", e);
            }
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            Object cur = null;
            try {
                block3: for (int i = 0; i < POShuffleTezLoad.this.numTezInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentKey();
                    while (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) == 0 && (!this.min.isNull() || this.min.isNull() && i == this.minIndex)) {
                        boolean bl = ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).next();
                        if (POShuffleTezLoad.this.finished[i]) continue block3;
                        cur = ((KeyValuesReader)POShuffleTezLoad.this.readers.get(i)).getCurrentKey();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while cleaning up for next Accumulator batch", e);
            }
            this.clearedCurrent = true;
        }

        @Override
        public Iterator<Tuple> getTuples(int index) {
            return this.bags[index].iterator();
        }
    }
}

