/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.util.GroupingSpillable;
import org.apache.pig.impl.util.Spillable;

public class SpillableMemoryManager
implements NotificationListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private LinkedList<WeakReference<Spillable>> spillables = new LinkedList();
    private LinkedList<SpillablePtr> spillablesSR = null;
    private Object spillLock = new Object();
    private static long gcActivationSize = 40000000L;
    private static long spillFileSizeThreshold = 5000000L;
    private long accumulatedFreeSize = 0L;
    private double memoryThresholdFraction = 0.7;
    private double collectionMemoryThresholdFraction = 0.5;
    private boolean firstUsageThreshExceededLogged = false;
    private boolean firstCollectionThreshExceededLogged = false;
    private double extraGCThresholdFraction = 0.05;
    private long extraGCSpillSizeThreshold = 0L;
    private volatile boolean blockRegisterOnSpill = false;
    private static volatile SpillableMemoryManager manager = new SpillableMemoryManager();

    private SpillableMemoryManager() {
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this, null, null);
        List<MemoryPoolMXBean> mpbeans = ManagementFactory.getMemoryPoolMXBeans();
        MemoryPoolMXBean tenuredHeap = null;
        long tenuredHeapSize = 0L;
        long totalSize = 0L;
        for (MemoryPoolMXBean pool : mpbeans) {
            this.log.debug((Object)("Found heap (" + pool.getName() + ") of type " + (Object)((Object)pool.getType())));
            if (pool.getType() != MemoryType.HEAP) continue;
            long size = pool.getUsage().getMax();
            totalSize += size;
            if (!pool.isUsageThresholdSupported()) continue;
            tenuredHeapSize = size;
            tenuredHeap = pool;
        }
        this.extraGCSpillSizeThreshold = (long)((double)totalSize * this.extraGCThresholdFraction);
        if (tenuredHeap == null) {
            throw new RuntimeException("Couldn't find heap");
        }
        this.log.debug((Object)("Selected heap to monitor (" + tenuredHeap.getName() + ")"));
        tenuredHeap.setCollectionUsageThreshold((long)((double)tenuredHeapSize * this.collectionMemoryThresholdFraction));
        tenuredHeap.setUsageThreshold((long)((double)tenuredHeapSize * this.memoryThresholdFraction));
    }

    public static SpillableMemoryManager getInstance() {
        return manager;
    }

    public static void configure(Properties properties) {
        try {
            spillFileSizeThreshold = Long.parseLong(properties.getProperty("pig.spill.size.threshold"));
            gcActivationSize = Long.parseLong(properties.getProperty("pig.spill.gc.activation.size"));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Error while converting system configurationsspill.size.threshold, spill.gc.activation.size", nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification n, Object o) {
        String msg;
        long threshold;
        CompositeData cd = (CompositeData)n.getUserData();
        MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
        long toFree = 0L;
        if (n.getType().equals("java.management.memory.threshold.exceeded")) {
            threshold = (long)((double)info.getUsage().getMax() * this.memoryThresholdFraction);
            toFree = info.getUsage().getUsed() - threshold + (long)((double)threshold * 0.5);
            msg = "memory handler call- Usage threshold " + info.getUsage();
            if (!this.firstUsageThreshExceededLogged) {
                this.log.info((Object)("first " + msg));
                this.firstUsageThreshExceededLogged = true;
            } else {
                this.log.debug((Object)msg);
            }
        } else {
            threshold = (long)((double)info.getUsage().getMax() * this.collectionMemoryThresholdFraction);
            toFree = info.getUsage().getUsed() - threshold + (long)((double)threshold * 0.5);
            msg = "memory handler call - Collection threshold " + info.getUsage();
            if (!this.firstCollectionThreshExceededLogged) {
                this.log.info((Object)("first " + msg));
                this.firstCollectionThreshExceededLogged = true;
            } else {
                this.log.debug((Object)msg);
            }
        }
        if (toFree < 0L) {
            this.log.debug((Object)"low memory handler returning because there is nothing to free");
            return;
        }
        Object object = this.spillLock;
        synchronized (object) {
            LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
            synchronized (linkedList) {
                this.spillablesSR = new LinkedList();
                Iterator i = this.spillables.iterator();
                while (i.hasNext()) {
                    Spillable s = (Spillable)((WeakReference)i.next()).get();
                    if (s == null) {
                        i.remove();
                        continue;
                    }
                    this.spillablesSR.add(new SpillablePtr(s, s.getMemorySize()));
                }
                this.log.debug((Object)("Spillables list size: " + this.spillablesSR.size()));
                Collections.sort(this.spillablesSR, new Comparator<SpillablePtr>(){

                    @Override
                    public int compare(SpillablePtr o1Ref, SpillablePtr o2Ref) {
                        long o2Size;
                        Spillable o1 = o1Ref.get();
                        Spillable o2 = o2Ref.get();
                        long o1Size = o1.getMemorySize();
                        if (o1Size == (o2Size = o2.getMemorySize())) {
                            return 0;
                        }
                        if (o1Size < o2Size) {
                            return 1;
                        }
                        return -1;
                    }
                });
                this.blockRegisterOnSpill = true;
            }
            try {
                long estimatedFreed = 0L;
                int numObjSpilled = 0;
                boolean invokeGC = false;
                boolean extraGCCalled = false;
                boolean isGroupingSpillable = false;
                Iterator i = this.spillablesSR.iterator();
                while (i.hasNext()) {
                    SpillablePtr sPtr = (SpillablePtr)i.next();
                    Spillable s = sPtr.get();
                    if (s == null) {
                        i.remove();
                        continue;
                    }
                    long toBeFreed = sPtr.getMemorySize();
                    this.log.debug((Object)("Memorysize = " + toBeFreed + ", spillFilesizethreshold = " + spillFileSizeThreshold + ", gcactivationsize = " + gcActivationSize));
                    if (toBeFreed < spillFileSizeThreshold) {
                        this.log.debug((Object)"spilling small files - getting out of memory handler");
                        break;
                    }
                    isGroupingSpillable = s instanceof GroupingSpillable;
                    if (!extraGCCalled && this.extraGCSpillSizeThreshold != 0L && toBeFreed > this.extraGCSpillSizeThreshold && !isGroupingSpillable) {
                        this.log.debug((Object)("Single spillable has size " + toBeFreed + "bytes. Calling extra gc()"));
                        s = null;
                        System.gc();
                        extraGCCalled = true;
                        s = sPtr.get();
                        if (s == null) {
                            i.remove();
                            this.accumulatedFreeSize = 0L;
                            invokeGC = false;
                            continue;
                        }
                    }
                    this.blockRegisterOnSpill = !isGroupingSpillable;
                    try {
                        s.spill();
                    }
                    finally {
                        this.blockRegisterOnSpill = true;
                    }
                    ++numObjSpilled;
                    estimatedFreed += toBeFreed;
                    this.accumulatedFreeSize += toBeFreed;
                    if (this.accumulatedFreeSize > gcActivationSize) {
                        invokeGC = true;
                    }
                    if (estimatedFreed <= toFree) continue;
                    this.log.debug((Object)"Freed enough space - getting out of memory handler");
                    invokeGC = true;
                    break;
                }
                this.spillablesSR = null;
                if (invokeGC) {
                    System.gc();
                    this.accumulatedFreeSize = 0L;
                }
                if (estimatedFreed > 0L) {
                    String msg2 = "Spilled an estimate of " + estimatedFreed + " bytes from " + numObjSpilled + " objects. " + info.getUsage();
                    this.log.info((Object)msg2);
                }
            }
            finally {
                this.blockRegisterOnSpill = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSpillables() {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            Iterator i = this.spillables.iterator();
            while (i.hasNext()) {
                Spillable s = (Spillable)((WeakReference)i.next()).get();
                if (s != null) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpillable(Spillable s) {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            WeakReference<Spillable> first = this.spillables.peek();
            while (first != null && first.get() == null) {
                this.spillables.remove();
                first = this.spillables.peek();
            }
            if (this.blockRegisterOnSpill) {
                try {
                    int i;
                    for (i = 6000; i > 0 && this.blockRegisterOnSpill; --i) {
                        Thread.sleep(50L);
                    }
                    if (i == 0) {
                        this.log.warn((Object)"Spill took more than 5 mins. This needs investigation");
                    }
                }
                catch (InterruptedException e) {
                    this.log.warn((Object)"Interrupted exception in registerSpillable while blocked on spill", (Throwable)e);
                }
                this.blockRegisterOnSpill = false;
            }
            this.spillables.add(new WeakReference<Spillable>(s));
        }
    }

    private static class SpillablePtr {
        private WeakReference<Spillable> spillable;
        private long size;

        public SpillablePtr(Spillable p, long s) {
            this.spillable = new WeakReference<Spillable>(p);
            this.size = s;
        }

        public Spillable get() {
            return (Spillable)this.spillable.get();
        }

        public long getMemorySize() {
            return this.size;
        }
    }
}

