/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.main.lock.GenericStatements;
import org.apache.karaf.main.lock.Lock;
import org.apache.karaf.main.util.BootstrapLogManager;

public class GenericJDBCLock
implements Lock {
    final Logger LOG = Logger.getLogger(this.getClass().getName());
    public static final String PROPERTY_LOCK_URL = "karaf.lock.jdbc.url";
    public static final String PROPERTY_LOCK_JDBC_DRIVER = "karaf.lock.jdbc.driver";
    public static final String PROPERTY_LOCK_JDBC_USER = "karaf.lock.jdbc.user";
    public static final String PROPERTY_LOCK_JDBC_PASSWORD = "karaf.lock.jdbc.password";
    public static final String PROPERTY_LOCK_JDBC_TABLE = "karaf.lock.jdbc.table";
    public static final String PROPERTY_LOCK_JDBC_TABLE_ID = "karaf.lock.jdbc.table_id";
    public static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "karaf.lock.jdbc.clustername";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_TABLE = "KARAF_LOCK";
    public static final String DEFAULT_TABLE_ID = "KARAF_NODE_ID";
    public static final String DEFAULT_CLUSTERNAME = "karaf";
    final GenericStatements statements;
    Connection lockConnection;
    String url;
    String driver;
    String user;
    String password;
    String table;
    String clusterName;
    String table_id;
    int lock_delay;
    private int uniqueId = 0;
    private int state = 0;
    private int currentId = 0;
    private int currentState = 0;
    private long currentStateTime;
    private int currentLockDelay;

    public GenericJDBCLock(Properties props) {
        try {
            this.LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.user = props.getProperty(PROPERTY_LOCK_JDBC_USER, "");
        this.password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD, "");
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE, DEFAULT_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME, DEFAULT_CLUSTERNAME);
        this.table_id = props.getProperty(PROPERTY_LOCK_JDBC_TABLE_ID, DEFAULT_TABLE_ID);
        this.lock_delay = Integer.parseInt(props.getProperty("karaf.lock.delay", "1000"));
        this.statements = this.createStatements();
        this.init();
    }

    GenericStatements createStatements() {
        GenericStatements statements = new GenericStatements(this.table, this.table_id, this.clusterName);
        return statements;
    }

    void init() {
        try {
            this.createDatabase();
            this.createSchema();
            this.generateUniqueId();
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error occured while attempting to obtain connection", e);
        }
    }

    void createDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void createSchema() {
        block15: {
            if (this.schemaExists()) {
                return;
            }
            String[] createStatments = this.statements.getLockCreateSchemaStatements(System.currentTimeMillis());
            Statement statement = null;
            Connection connection = null;
            connection = this.getConnection();
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            for (String stmt : createStatments) {
                this.LOG.info("Executing statement: " + stmt);
                statement.execute(stmt);
            }
            connection.commit();
            this.closeSafely(statement);
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException ignored) {
                this.LOG.log(Level.FINE, "Exception while setting the connection auto commit", ignored);
            }
            break block15;
            catch (Exception e) {
                try {
                    this.LOG.log(Level.SEVERE, "Could not create schema", e);
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                    this.closeSafely(statement);
                }
                catch (Throwable throwable) {
                    this.closeSafely(statement);
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException ignored) {
                        this.LOG.log(Level.FINE, "Exception while setting the connection auto commit", ignored);
                    }
                    throw throwable;
                }
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException ignored) {
                    this.LOG.log(Level.FINE, "Exception while setting the connection auto commit", ignored);
                }
            }
        }
    }

    boolean schemaExists() {
        return this.schemaExist(this.statements.getLockTableName()) && this.schemaExist(this.statements.getLockIdTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schemaExist(String tableName) {
        ResultSet rs = null;
        boolean schemaExists = false;
        try {
            rs = this.getConnection().getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            schemaExists = rs.next();
            this.closeSafely(rs);
        }
        catch (Exception ignore) {
            this.LOG.log(Level.SEVERE, "Error testing for db table", ignore);
        }
        finally {
            this.closeSafely(rs);
        }
        return schemaExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateUniqueId() {
        boolean uniqueIdSet = false;
        String selectString = this.statements.getLockIdSelectStatement();
        PreparedStatement selectStatement = null;
        PreparedStatement updateStatement = null;
        try {
            selectStatement = this.getConnection().prepareStatement(selectString);
            while (!uniqueIdSet) {
                ResultSet rs = null;
                try {
                    rs = selectStatement.executeQuery();
                    if (rs.next()) {
                        int currentId = this.statements.getIdFromLockIdSelectStatement(rs);
                        String updateString = this.statements.getLockIdUpdateIdStatement(currentId + 1, currentId);
                        updateStatement = this.getConnection().prepareStatement(updateString);
                        int count = updateStatement.executeUpdate();
                        uniqueIdSet = count > 0;
                        int n = this.uniqueId = uniqueIdSet ? currentId + 1 : 0;
                        if (count <= 1) continue;
                        this.LOG.severe("OOPS there are more than one row within the table ids...");
                        continue;
                    }
                    this.LOG.severe("No rows were found....");
                }
                catch (SQLException e) {
                    this.LOG.log(Level.SEVERE, "Received an SQL exception while processing result set", e);
                }
                finally {
                    this.closeSafely(rs);
                }
            }
        }
        catch (SQLException e) {
            this.LOG.log(Level.SEVERE, "Received an SQL exception while generating a prepate statement", e);
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Received an exception while trying to get a reference to a connection", e);
        }
        finally {
            this.closeSafely(selectStatement);
        }
        this.LOG.info("INSTANCE unique id: " + this.uniqueId);
    }

    boolean isConnected() throws SQLException {
        return this.lockConnection != null && !this.lockConnection.isClosed();
    }

    void closeSafely(Statement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Failed to close statement", e);
            }
        }
    }

    void closeSafely(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Error occured while releasing ResultSet", e);
            }
        }
    }

    protected Connection getConnection() throws Exception {
        if (!this.isConnected()) {
            this.lockConnection = this.createConnection(this.driver, this.url, this.user, this.password);
        }
        return this.lockConnection;
    }

    protected Connection createConnection(String driver, String url, String username, String password) throws Exception {
        if (url.toLowerCase().startsWith("jdbc:derby")) {
            url = url.toLowerCase().contains("create=true") ? url : url + ";create=true";
        }
        try {
            return this.doCreateConnection(driver, url, username, password);
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error occured while setting up JDBC connection", e);
            throw e;
        }
    }

    protected Connection doCreateConnection(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(driver);
        return DriverManager.getConnection(url, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock() throws Exception {
        boolean lockAquired;
        if (!(lockAquired = this.acquireLock(this.statements.getLockUpdateIdStatement(this.uniqueId, ++this.state, this.lock_delay, this.uniqueId)))) {
            String lockSelectStatement = this.statements.getLockSelectStatement();
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                statement = this.getConnection().prepareStatement(lockSelectStatement);
                rs = statement.executeQuery();
                if (rs.next()) {
                    int currentId = this.statements.getIdFromLockSelectStatement(rs);
                    int currentState = this.statements.getStateFromLockSelectStatement(rs);
                    if (this.currentId == currentId) {
                        if (this.currentState == currentState) {
                            if (this.currentStateTime + (long)this.currentLockDelay + (long)this.currentLockDelay < System.currentTimeMillis()) {
                                lockAquired = this.acquireLock(this.statements.getLockUpdateIdStatementToStealLock(this.uniqueId, this.state, this.lock_delay, currentId, currentState));
                            }
                        } else {
                            this.currentStateTime = System.currentTimeMillis();
                            this.currentState = currentState;
                        }
                    } else {
                        this.currentId = currentId;
                        this.currentState = currentState;
                        this.currentStateTime = System.currentTimeMillis();
                        this.currentLockDelay = this.statements.getLockDelayFromLockSelectStatement(rs);
                    }
                }
            }
            catch (Exception e) {
                this.LOG.log(Level.SEVERE, "Unable to determine if the lock was obtain", e);
            }
            finally {
                this.closeSafely(statement);
                this.closeSafely(rs);
            }
        }
        return lockAquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLock(String lockUpdateIdStatement) {
        PreparedStatement preparedStatement = null;
        boolean lockAquired = false;
        try {
            preparedStatement = this.getConnection().prepareStatement(lockUpdateIdStatement);
            lockAquired = preparedStatement.executeUpdate() > 0;
        }
        catch (Exception e) {
            this.LOG.log(Level.WARNING, "Failed to acquire database lock", e);
        }
        finally {
            this.closeSafely(preparedStatement);
        }
        return lockAquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws Exception {
        if (this.isConnected()) {
            String lockResetIdStatement = this.statements.getLockResetIdStatement(this.uniqueId);
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.getConnection().prepareStatement(lockResetIdStatement);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Exception while rollbacking the connection on release", e);
            }
            finally {
                this.closeSafely(preparedStatement);
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignored) {
                    this.LOG.log(Level.FINE, "Exception while closing connection on release", ignored);
                }
            }
        }
        this.lockConnection = null;
    }

    @Override
    public boolean isAlive() throws Exception {
        if (!this.isConnected()) {
            this.LOG.severe("Lost lock!");
            return false;
        }
        return this.lock();
    }
}

