/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputField;
import org.w3c.dom.Node;

public class JsonInputField
extends BaseFileInputField
implements Cloneable {
    @Deprecated
    public static final int TYPE_TRIM_NONE = 0;
    @Deprecated
    public static final int TYPE_TRIM_LEFT = 1;
    @Deprecated
    public static final int TYPE_TRIM_RIGHT = 2;
    @Deprecated
    public static final int TYPE_TRIM_BOTH = 3;
    @Deprecated
    public static final String[] trimTypeCode = ValueMetaBase.trimTypeCode;
    @Deprecated
    public static final String[] trimTypeDesc = ValueMetaBase.trimTypeDesc;
    @Injection(name="FIELD_PATH", group="FIELDS")
    private String path;

    public JsonInputField(String fieldname) {
        this.setName(fieldname);
    }

    public JsonInputField() {
        this("");
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(400);
        retval.append("      <field>").append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)this.getPath()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        retval.append("      </field>").append(Const.CR);
        return retval.toString();
    }

    public JsonInputField(Node fnode) throws KettleValueException {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(JsonInputField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public ValueMetaInterface toValueMeta(String fieldOriginStepName, VariableSpace vspace) throws KettlePluginException {
        int type = this.getType();
        if (type == 0) {
            type = 2;
        }
        ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)(vspace != null ? vspace.environmentSubstitute(this.getName()) : this.getName()), (int)type);
        v.setLength(this.getLength());
        v.setPrecision(this.getPrecision());
        v.setOrigin(fieldOriginStepName);
        v.setConversionMask(this.getFormat());
        v.setDecimalSymbol(this.getDecimalSymbol());
        v.setGroupingSymbol(this.getGroupSymbol());
        v.setCurrencySymbol(this.getCurrencySymbol());
        return v;
    }

    @Deprecated
    public static final int getTrimTypeByCode(String tt) {
        return ValueMetaBase.getTrimTypeByCode((String)tt);
    }

    @Deprecated
    public static final int getTrimTypeByDesc(String tt) {
        return ValueMetaBase.getTrimTypeByDesc((String)tt);
    }

    @Deprecated
    public static final String getTrimTypeCode(int i) {
        return ValueMetaBase.getTrimTypeCode((int)i);
    }

    @Deprecated
    public static final String getTrimTypeDesc(int i) {
        return ValueMetaBase.getTrimTypeDesc((int)i);
    }

    public JsonInputField clone() {
        JsonInputField retval = (JsonInputField)super.clone();
        return retval;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }
}

