/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.reader.IJsonReader;

public class FastJsonReader
implements IJsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JSON_CHARSET = "UTF-8";
    private ReadContext jsonReadContext;
    private Configuration jsonConfiguration = Configuration.defaultConfiguration().addOptions(DEFAULT_OPTIONS);
    private boolean ignoreMissingPath = false;
    private JsonInputField[] fields;
    private JsonPath[] paths = null;
    private LogChannelInterface log;
    private static final Option[] DEFAULT_OPTIONS = new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST, Option.DEFAULT_PATH_LEAF_TO_NULL};

    protected FastJsonReader(LogChannelInterface log) throws KettleException {
        this.log = log;
    }

    public FastJsonReader(JsonInputField[] fields, LogChannelInterface log) throws KettleException {
        this(log);
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public void setIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private ParseContext getParseContext() {
        return JsonPath.using((Configuration)this.jsonConfiguration);
    }

    private ReadContext getReadContext() {
        return this.jsonReadContext;
    }

    private static JsonPath[] compilePaths(JsonInputField[] fields) {
        JsonPath[] paths = new JsonPath[fields.length];
        int i = 0;
        for (JsonInputField field : fields) {
            paths[i++] = JsonPath.compile((String)field.getPath(), (Predicate[])new Predicate[0]);
        }
        return paths;
    }

    protected void readInput(InputStream is) throws KettleException {
        this.jsonReadContext = this.getParseContext().parse(is, JSON_CHARSET);
        if (this.jsonReadContext == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
        }
    }

    @Override
    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    @Override
    public void setFields(JsonInputField[] fields) throws KettleException {
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public RowSet parse(InputStream in) throws KettleException {
        this.readInput(in);
        List<List<?>> results = this.evalCombinedResult();
        if (this.log.isDetailed()) {
            int len = results.isEmpty() ? 0 : results.get(0).size();
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{len}));
        }
        return new TransposedRowSet(results);
    }

    private List<List<?>> evalCombinedResult() throws KettleException {
        int lastSize = -1;
        String prevPath = null;
        ArrayList results = new ArrayList(this.paths.length);
        int i = 0;
        for (JsonPath path : this.paths) {
            List res = (List)this.getReadContext().read(path);
            if (res.size() != lastSize && lastSize > 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{res.size(), this.fields[i].getPath(), prevPath, lastSize}));
            }
            if ((FastJsonReader.isAllNull(res) || res.size() == 0) && !this.isIgnoreMissingPath()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.fields[i].getPath()}));
            }
            results.add(res);
            lastSize = res.size();
            prevPath = this.fields[i].getPath();
            ++i;
        }
        return results;
    }

    public static boolean isAllNull(Iterable<?> list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private static class TransposedRowSet
    extends SingleRowRowSet {
        private List<List<?>> results;
        int rowCount;
        int rowNbr;

        public TransposedRowSet(List<List<?>> results) {
            this.results = results;
            this.rowCount = results.isEmpty() ? 0 : results.get(0).size();
        }

        public Object[] getRow() {
            if (this.rowNbr >= this.rowCount) {
                this.results.clear();
                return null;
            }
            Object[] rowData = new Object[this.results.size()];
            for (int col = 0; col < this.results.size(); ++col) {
                rowData[col] = this.results.get(col).get(this.rowNbr);
            }
            ++this.rowNbr;
            return rowData;
        }

        public int size() {
            return this.rowCount - this.rowNbr;
        }

        public boolean isDone() {
            return true;
        }

        public void clear() {
            this.results.clear();
        }
    }
}

