/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.SubmitTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordActionMaterializeCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.CoordinatorJobException;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class CoordSubmitXCommand
extends SubmitTransitionXCommand {
    protected Configuration conf;
    private final String bundleId;
    private final String coordName;
    protected boolean dryrun;
    protected JPAService jpaService = null;
    private Job.Status prevStatus = Job.Status.PREP;
    public static final String CONFIG_DEFAULT = "coord-config-default.xml";
    public static final String COORDINATOR_XML_FILE = "coordinator.xml";
    public final String COORD_INPUT_EVENTS = "input-events";
    public final String COORD_OUTPUT_EVENTS = "output-events";
    public final String COORD_INPUT_EVENTS_DATA_IN = "data-in";
    public final String COORD_OUTPUT_EVENTS_DATA_OUT = "data-out";
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    protected CoordinatorJobBean coordJob = null;
    public static final String CONF_DEFAULT_TIMEOUT_NORMAL = "oozie.service.coord.normal.default.timeout";
    public static final String CONF_DEFAULT_CONCURRENCY = "oozie.service.coord.default.concurrency";
    public static final String CONF_DEFAULT_THROTTLE = "oozie.service.coord.default.throttle";
    public static final String CONF_MAT_THROTTLING_FACTOR = "oozie.service.coord.materialization.throttling.factor";
    public static final String CONF_DEFAULT_MAX_TIMEOUT = "oozie.service.coord.default.max.timeout";
    public static final String CONF_QUEUE_SIZE = "oozie.service.CallableQueueService.queue.size";
    public static final String CONF_CHECK_MAX_FREQUENCY = "oozie.service.coord.check.maximum.frequency";
    private ELEvaluator evalFreq = null;
    private ELEvaluator evalNofuncs = null;
    private ELEvaluator evalData = null;
    private ELEvaluator evalInst = null;
    private ELEvaluator evalAction = null;
    private ELEvaluator evalSla = null;
    private ELEvaluator evalTimeout = null;

    public CoordSubmitXCommand(Configuration conf) {
        super("coord_submit", "coord_submit", 1);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.bundleId = null;
        this.coordName = null;
    }

    public CoordSubmitXCommand(Configuration conf, String bundleId, String coordName) {
        super("coord_submit", "coord_submit", 1);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.bundleId = ParamChecker.notEmpty(bundleId, "bundleId");
        this.coordName = ParamChecker.notEmpty(coordName, "coordName");
    }

    public CoordSubmitXCommand(boolean dryrun, Configuration conf) {
        this(conf);
        this.dryrun = dryrun;
    }

    @Override
    protected String submit() throws CommandException {
        this.LOG.info("STARTED Coordinator Submit");
        String jobId = this.submitJob();
        this.LOG.info("ENDED Coordinator Submit jobId=" + jobId);
        return jobId;
    }

    protected String submitJob() throws CommandException {
        String jobId;
        block11: {
            jobId = null;
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            boolean exceptionOccured = false;
            try {
                this.mergeDefaultConfig();
                String appXml = this.readAndValidateXml();
                this.coordJob.setOrigJobXml(appXml);
                this.LOG.debug("jobXml after initial validation " + XmlUtils.prettyPrint(appXml).toString());
                Element eXml = XmlUtils.parseXml(appXml);
                String appNamespace = this.readAppNamespace(eXml);
                this.coordJob.setAppNamespace(appNamespace);
                ParameterVerifier.verifyParameters(this.conf, eXml);
                appXml = XmlUtils.removeComments(appXml);
                this.initEvaluators();
                Element eJob = this.basicResolveAndIncludeDS(appXml, this.conf, this.coordJob);
                this.validateCoordinatorJob();
                this.checkMultipleTimeInstances(eJob, "input-events", "data-in");
                this.checkMultipleTimeInstances(eJob, "output-events", "data-out");
                this.LOG.debug("jobXml after all validation " + XmlUtils.prettyPrint(eJob).toString());
                jobId = this.storeToDB(appXml, eJob, this.coordJob);
                LogUtils.setLogInfo(this.coordJob, this.logInfo);
                this.LOG = XLog.resetPrefix(this.LOG);
                if (!this.dryrun) {
                    this.queueMaterializeTransitionXCommand(jobId);
                    break block11;
                }
                String string = this.getDryRun(this.coordJob);
                return string;
            }
            catch (JDOMException jex) {
                exceptionOccured = true;
                this.LOG.warn((Object)"ERROR: ", jex);
                throw new CommandException(ErrorCode.E0700, new Object[]{jex.getMessage(), jex});
            }
            catch (CoordinatorJobException cex) {
                exceptionOccured = true;
                this.LOG.warn((Object)"ERROR:  ", cex);
                throw new CommandException(cex);
            }
            catch (ParameterVerifierException pex) {
                exceptionOccured = true;
                this.LOG.warn((Object)"ERROR: ", pex);
                throw new CommandException(pex);
            }
            catch (IllegalArgumentException iex) {
                exceptionOccured = true;
                this.LOG.warn((Object)"ERROR:  ", iex);
                throw new CommandException(ErrorCode.E1003, iex.getMessage(), iex);
            }
            catch (Exception ex) {
                exceptionOccured = true;
                this.LOG.warn((Object)"ERROR:  ", ex);
                throw new CommandException(ErrorCode.E0803, ex.getMessage(), ex);
            }
            finally {
                if (exceptionOccured && (this.coordJob.getId() == null || this.coordJob.getId().equalsIgnoreCase(""))) {
                    this.coordJob.setStatus(Job.Status.FAILED);
                    this.coordJob.resetPending();
                }
            }
        }
        return jobId;
    }

    protected String getDryRun(CoordinatorJobBean coordJob) throws Exception {
        Date jobEndTime;
        Date startTime = coordJob.getStartTime();
        long startTimeMilli = startTime.getTime();
        long endTimeMilli = startTimeMilli + 3600000L;
        Date endTime = new Date(endTimeMilli);
        if (endTime.compareTo(jobEndTime = coordJob.getEndTime()) > 0) {
            endTime = jobEndTime;
        }
        String jobId = coordJob.getId();
        this.LOG.info("[" + jobId + "]: Update status to RUNNING");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setPending();
        CoordActionMaterializeCommand coordActionMatCom = new CoordActionMaterializeCommand(jobId, startTime, endTime);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration(new StringReader(coordJob.getConf()));
        }
        catch (IOException e1) {
            this.LOG.warn((Object)("Configuration parse error. read from DB :" + coordJob.getConf()), e1);
        }
        String action = coordActionMatCom.materializeJobs(true, coordJob, jobConf, null);
        String output = coordJob.getJobXml() + System.getProperty("line.separator") + "***actions for instance***" + action;
        return output;
    }

    protected void queueMaterializeTransitionXCommand(String jobId) {
        this.queue(new CoordMaterializeTransitionXCommand(jobId, 3600), 100L);
    }

    private void validateCoordinatorJob() throws Exception {
        block5: {
            if (!this.coordJob.getStartTime().before(this.coordJob.getEndTime())) {
                throw new IllegalArgumentException("Coordinator Start Time must be earlier than End Time.");
            }
            try {
                int freq = Integer.parseInt(this.coordJob.getFrequency());
                if (Services.get().getConf().getBoolean(CONF_CHECK_MAX_FREQUENCY, true)) {
                    CoordinatorJob.Timeunit unit = this.coordJob.getTimeUnit();
                    if (freq == 0 || freq < 5 && unit == CoordinatorJob.Timeunit.MINUTE) {
                        throw new IllegalArgumentException("Coordinator job with frequency [" + freq + "] minutes is faster than allowed maximum of 5 minutes (" + CONF_CHECK_MAX_FREQUENCY + " is set to true)");
                    }
                }
            }
            catch (NumberFormatException e) {
                Date start = this.coordJob.getStartTime();
                Calendar cal = Calendar.getInstance();
                cal.setTime(start);
                cal.add(12, -1);
                start = cal.getTime();
                Date nextTime = CoordCommandUtils.getNextValidActionTimeForCronFrequency(start, this.coordJob);
                if (nextTime.before(this.coordJob.getEndTime())) break block5;
                throw new IllegalArgumentException("Coordinator job with frequency '" + this.coordJob.getFrequency() + "' materializes no actions between start and end time.");
            }
        }
    }

    private void checkMultipleTimeInstances(Element eCoordJob, String eventType, String dataType) throws CoordinatorJobException {
        Element dataSpec;
        Namespace ns = eCoordJob.getNamespace();
        Element eventsSpec = eCoordJob.getChild(eventType, ns);
        if (eventsSpec != null && (dataSpec = eventsSpec.getChild(dataType, ns)) != null) {
            boolean isInvalid;
            String instanceValue;
            List instanceSpecList = dataSpec.getChildren("instance", ns);
            for (Element instance : instanceSpecList) {
                if (instance.getContentSize() == 0) {
                    throw new CoordinatorJobException(ErrorCode.E1021, "<instance> tag within " + eventType + " is empty!");
                }
                instanceValue = instance.getContent(0).toString();
                isInvalid = false;
                try {
                    isInvalid = this.evalAction.checkForExistence(instanceValue, ",");
                }
                catch (Exception e) {
                    this.handleELParseException(eventType, dataType, instanceValue);
                }
                if (!isInvalid) continue;
                this.handleExpresionWithMultipleInstances(eventType, dataType, instanceValue);
            }
            instanceSpecList = dataSpec.getChildren("start-instance", ns);
            for (Element instance : instanceSpecList) {
                if (instance.getContentSize() == 0) {
                    throw new CoordinatorJobException(ErrorCode.E1021, "<start-instance> tag within " + eventType + " is empty!");
                }
                instanceValue = instance.getContent(0).toString();
                isInvalid = false;
                try {
                    isInvalid = this.evalAction.checkForExistence(instanceValue, ",");
                }
                catch (Exception e) {
                    this.handleELParseException(eventType, dataType, instanceValue);
                }
                if (!isInvalid) continue;
                this.handleExpresionWithStartMultipleInstances(eventType, dataType, instanceValue);
            }
            instanceSpecList = dataSpec.getChildren("end-instance", ns);
            for (Element instance : instanceSpecList) {
                if (instance.getContentSize() == 0) {
                    throw new CoordinatorJobException(ErrorCode.E1021, "<end-instance> tag within " + eventType + " is empty!");
                }
                instanceValue = instance.getContent(0).toString();
                isInvalid = false;
                try {
                    isInvalid = this.evalAction.checkForExistence(instanceValue, ",");
                }
                catch (Exception e) {
                    this.handleELParseException(eventType, dataType, instanceValue);
                }
                if (!isInvalid) continue;
                this.handleExpresionWithMultipleEndInstances(eventType, dataType, instanceValue);
            }
        }
    }

    private void handleELParseException(String eventType, String dataType, String instanceValue) throws CoordinatorJobException {
        String correctAction = null;
        if (dataType.equals("data-in")) {
            correctAction = "Coordinator app definition should have valid <instance> tag for data-in";
        } else if (dataType.equals("data-out")) {
            correctAction = "Coordinator app definition should have valid <instance> tag for data-out";
        }
        throw new CoordinatorJobException(ErrorCode.E1021, eventType + " instance '" + instanceValue + "' is not valid. Coordinator job NOT SUBMITTED. " + correctAction);
    }

    private void handleExpresionWithMultipleInstances(String eventType, String dataType, String instanceValue) throws CoordinatorJobException {
        String correctAction = null;
        if (dataType.equals("data-in")) {
            correctAction = "Coordinator app definition should have separate <instance> tag per data-in instance";
        } else if (dataType.equals("data-out")) {
            correctAction = "Coordinator app definition can have only one <instance> tag per data-out instance";
        }
        throw new CoordinatorJobException(ErrorCode.E1021, eventType + " instance '" + instanceValue + "' contains more than one date instance. Coordinator job NOT SUBMITTED. " + correctAction);
    }

    private void handleExpresionWithStartMultipleInstances(String eventType, String dataType, String instanceValue) throws CoordinatorJobException {
        String correctAction = "Coordinator app definition should not have multiple start-instances";
        throw new CoordinatorJobException(ErrorCode.E1021, eventType + " start-instance '" + instanceValue + "' contains more than one date start-instance. Coordinator job NOT SUBMITTED. " + correctAction);
    }

    private void handleExpresionWithMultipleEndInstances(String eventType, String dataType, String instanceValue) throws CoordinatorJobException {
        String correctAction = "Coordinator app definition should not have multiple end-instances";
        throw new CoordinatorJobException(ErrorCode.E1021, eventType + " end-instance '" + instanceValue + "' contains more than one date end-instance. Coordinator job NOT SUBMITTED. " + correctAction);
    }

    protected String readAndValidateXml() throws CoordinatorJobException {
        String appPath = ParamChecker.notEmpty(this.conf.get("oozie.coord.application.path"), "oozie.coord.application.path");
        String coordXml = this.readDefinition(appPath);
        this.validateXml(coordXml);
        return coordXml;
    }

    private void validateXml(String xmlContent) throws CoordinatorJobException {
        Schema schema = Services.get().get(SchemaService.class).getSchema(SchemaService.SchemaName.COORDINATOR);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xmlContent)));
        }
        catch (SAXException ex) {
            this.LOG.warn((Object)"SAXException :", ex);
            throw new CoordinatorJobException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            this.LOG.warn((Object)"IOException :", ex);
            throw new CoordinatorJobException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private String readAppNamespace(Element coordXmlElement) throws CoordinatorJobException {
        Namespace ns = coordXmlElement.getNamespace();
        if (ns != null && this.bundleId != null && ns.getURI().equals("uri:oozie:coordinator:0.1")) {
            throw new CoordinatorJobException(ErrorCode.E1319, "bundle app can not submit coordinator namespace uri:oozie:coordinator:0.1, please use 0.2 or later");
        }
        if (ns != null) {
            return ns.getURI();
        }
        throw new CoordinatorJobException(ErrorCode.E0700, "the application xml namespace is not given");
    }

    protected void mergeDefaultConfig() throws CommandException {
        Path configDefault = null;
        try {
            String coordAppPathStr = this.conf.get("oozie.coord.application.path");
            Path coordAppPath = new Path(coordAppPathStr);
            String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(coordAppPath.toUri().getAuthority());
            FileSystem fs = has.createFileSystem(user, coordAppPath.toUri(), (Configuration)fsConf);
            configDefault = !fs.isFile(coordAppPath) ? new Path(coordAppPath, CONFIG_DEFAULT) : new Path(coordAppPath.getParent(), CONFIG_DEFAULT);
            if (fs.exists(configDefault)) {
                XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                XConfiguration.injectDefaults(defaultConf, this.conf);
            } else {
                this.LOG.info("configDefault Doesn't exist " + configDefault);
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            XConfiguration resolvedVarsConf = new XConfiguration();
            for (Map.Entry entry : this.conf) {
                resolvedVarsConf.set((String)entry.getKey(), this.conf.get((String)entry.getKey()));
            }
            this.conf = resolvedVarsConf;
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E0702, e.getMessage() + " : Problem reading default config " + configDefault, e);
        }
        catch (HadoopAccessorException e) {
            throw new CommandException(e);
        }
        this.LOG.debug("Merged CONF :" + XmlUtils.prettyPrint(this.conf).toString());
    }

    public Element basicResolveAndIncludeDS(String appXml, Configuration conf, CoordinatorJobBean coordJob) throws CoordinatorJobException, Exception {
        Element basicResolvedApp = this.resolveInitial(conf, appXml, coordJob);
        this.includeDataSets(basicResolvedApp, conf);
        return basicResolvedApp;
    }

    private void insertDataSet(Element eAppXml, Element eDatasets) {
        Element outputList;
        Element inputList = eAppXml.getChild("input-events", eAppXml.getNamespace());
        if (inputList != null) {
            for (Element dataIn : inputList.getChildren("data-in", eAppXml.getNamespace())) {
                Element eDataset = CoordSubmitXCommand.findDataSet(eDatasets, dataIn.getAttributeValue("dataset"));
                dataIn.getContent().add(0, eDataset);
            }
        }
        if ((outputList = eAppXml.getChild("output-events", eAppXml.getNamespace())) != null) {
            for (Element dataOut : outputList.getChildren("data-out", eAppXml.getNamespace())) {
                Element eDataset = CoordSubmitXCommand.findDataSet(eDatasets, dataOut.getAttributeValue("dataset"));
                dataOut.getContent().add(0, eDataset);
            }
        }
    }

    private static Element findDataSet(Element eDatasets, String name) {
        for (Element eDataset : eDatasets.getChildren("dataset", eDatasets.getNamespace())) {
            if (!eDataset.getAttributeValue("name").equals(name)) continue;
            eDataset = (Element)eDataset.clone();
            eDataset.detach();
            return eDataset;
        }
        throw new RuntimeException("undefined dataset: " + name);
    }

    protected void initEvaluators() {
        this.evalFreq = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-freq");
        this.evalNofuncs = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-nofuncs");
        this.evalInst = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-instances");
        this.evalAction = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-action-start");
        this.evalTimeout = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-wait-timeout");
    }

    protected Element resolveInitial(Configuration conf, String appXml, CoordinatorJobBean coordJob) throws CoordinatorJobException, Exception {
        int defaultThrottle;
        Element eAppXml = XmlUtils.parseXml(appXml);
        String val = this.resolveAttribute("frequency", eAppXml, this.evalFreq);
        int ival = 0;
        val = ParamChecker.checkFrequency(val);
        coordJob.setFrequency(val);
        TimeUnit tmp = this.evalFreq.getVariable("timeunit") == null ? TimeUnit.MINUTE : (TimeUnit)((Object)this.evalFreq.getVariable("timeunit"));
        try {
            Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            tmp = TimeUnit.CRON;
        }
        this.addAnAttribute("freq_timeunit", eAppXml, tmp.toString());
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.valueOf((String)tmp.toString()));
        tmp = this.evalFreq.getVariable("endOfDuration") == null ? TimeUnit.NONE : (TimeUnit)((Object)this.evalFreq.getVariable("endOfDuration"));
        this.addAnAttribute("end_of_duration", eAppXml, tmp.toString());
        if (this.coordName == null) {
            String name = ELUtils.resolveAppName(eAppXml.getAttribute("name").getValue(), conf);
            coordJob.setAppName(name);
        } else {
            coordJob.setAppName(this.coordName);
        }
        val = this.resolveAttribute("start", eAppXml, this.evalNofuncs);
        ParamChecker.checkDateOozieTZ(val, "start");
        coordJob.setStartTime(DateUtils.parseDateOozieTZ(val));
        val = this.resolveAttribute("end", eAppXml, this.evalNofuncs);
        ParamChecker.checkDateOozieTZ(val, "end");
        coordJob.setEndTime(DateUtils.parseDateOozieTZ(val));
        val = this.resolveAttribute("timezone", eAppXml, this.evalNofuncs);
        ParamChecker.checkTimeZone(val, "timezone");
        coordJob.setTimeZone(val);
        val = this.resolveTagContents("timeout", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalTimeout);
        if (val != null && val != "") {
            int t = Integer.parseInt(val);
            tmp = this.evalTimeout.getVariable("timeunit") == null ? TimeUnit.MINUTE : (TimeUnit)((Object)this.evalTimeout.getVariable("timeunit"));
            switch (tmp) {
                case HOUR: {
                    val = String.valueOf(t * 60);
                    break;
                }
                case DAY: {
                    val = String.valueOf(t * 60 * 24);
                    break;
                }
                case MONTH: {
                    val = String.valueOf(t * 60 * 24 * 30);
                    break;
                }
            }
        } else {
            val = Services.get().getConf().get(CONF_DEFAULT_TIMEOUT_NORMAL);
        }
        ival = ParamChecker.checkInteger(val, "timeout");
        if (ival < 0 || ival > Services.get().getConf().getInt(CONF_DEFAULT_MAX_TIMEOUT, 129600)) {
            ival = Services.get().getConf().getInt(CONF_DEFAULT_MAX_TIMEOUT, 129600);
        }
        coordJob.setTimeout(ival);
        val = this.resolveTagContents("concurrency", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        if (val == null || val.isEmpty()) {
            val = Services.get().getConf().get(CONF_DEFAULT_CONCURRENCY, "1");
        }
        ival = ParamChecker.checkInteger(val, "concurrency");
        coordJob.setConcurrency(ival);
        val = this.resolveTagContents("throttle", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        ival = val == null || val.isEmpty() ? (defaultThrottle = Services.get().getConf().getInt(CONF_DEFAULT_THROTTLE, 12)) : ParamChecker.checkInteger(val, "throttle");
        int maxQueue = Services.get().getConf().getInt(CONF_QUEUE_SIZE, 10000);
        float factor = Services.get().getConf().getFloat(CONF_MAT_THROTTLING_FACTOR, 0.1f);
        int maxThrottle = (int)((float)maxQueue * factor);
        if (ival > maxThrottle || ival < 1) {
            ival = maxThrottle;
        }
        this.LOG.debug("max throttle " + ival);
        coordJob.setMatThrottling(ival);
        val = this.resolveTagContents("execution", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        if (val == "") {
            val = CoordinatorJob.Execution.FIFO.toString();
        }
        coordJob.setExecutionOrder(CoordinatorJob.Execution.valueOf((String)val));
        String[] acceptedVals = new String[]{CoordinatorJob.Execution.LIFO.toString(), CoordinatorJob.Execution.FIFO.toString(), CoordinatorJob.Execution.LAST_ONLY.toString(), CoordinatorJob.Execution.NONE.toString()};
        ParamChecker.isMember(val, acceptedVals, "execution");
        this.resolveTagContents("include", eAppXml.getChild("datasets", eAppXml.getNamespace()), this.evalNofuncs);
        this.resolveDataSets(eAppXml);
        HashMap<String, String> dataNameList = new HashMap<String, String>();
        this.resolveIODataset(eAppXml);
        this.resolveIOEvents(eAppXml, dataNameList);
        this.resolveTagContents("app-path", eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()), this.evalNofuncs);
        Element configElem = eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()).getChild("configuration", eAppXml.getNamespace());
        this.evalData = CoordELEvaluator.createELEvaluatorForDataEcho(conf, "coord-job-submit-data", dataNameList);
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                this.resolveTagContents("name", propElem, this.evalData);
                Element tmpProp = (Element)propElem.clone();
                this.resolveTagContents("value", tmpProp, this.evalData);
            }
        }
        this.evalSla = CoordELEvaluator.createELEvaluatorForDataAndConf(conf, "coord-sla-submit", dataNameList);
        this.resolveSLA(eAppXml, coordJob);
        return eAppXml;
    }

    private void resolveSLA(Element eAppXml, CoordinatorJobBean coordJob) throws CommandException {
        Element eSla = XmlUtils.getSLAElement(eAppXml.getChild("action", eAppXml.getNamespace()));
        if (eSla != null) {
            String slaXml = XmlUtils.prettyPrint(eSla).toString();
            try {
                slaXml = this.evalSla.evaluate(slaXml, String.class);
                XmlUtils.validateData(slaXml, SchemaService.SchemaName.SLA_ORIGINAL);
            }
            catch (Exception e) {
                throw new CommandException(ErrorCode.E1004, "Validation ERROR :" + e.getMessage(), e);
            }
        }
    }

    private void resolveIOEvents(Element eJobOrg, HashMap<String, String> dataNameList) throws CoordinatorJobException {
        Element outputList;
        Element eJob = (Element)eJobOrg.clone();
        Element inputList = eJob.getChild("input-events", eJob.getNamespace());
        if (inputList != null) {
            TreeSet<String> eventNameSet = new TreeSet<String>();
            for (Element dataIn : inputList.getChildren("data-in", eJob.getNamespace())) {
                String dataInName = dataIn.getAttributeValue("name");
                dataNameList.put(dataInName, "data-in");
                if (eventNameSet.contains(dataInName)) {
                    throw new RuntimeException("Duplicate dataIn name " + dataInName);
                }
                eventNameSet.add(dataInName);
                this.resolveTagContents("instance", dataIn, this.evalInst);
                this.resolveTagContents("start-instance", dataIn, this.evalInst);
                this.resolveTagContents("end-instance", dataIn, this.evalInst);
            }
        }
        if ((outputList = eJob.getChild("output-events", eJob.getNamespace())) != null) {
            TreeSet<String> eventNameSet = new TreeSet<String>();
            for (Element dataOut : outputList.getChildren("data-out", eJob.getNamespace())) {
                String dataOutName = dataOut.getAttributeValue("name");
                dataNameList.put(dataOutName, "data-out");
                if (eventNameSet.contains(dataOutName)) {
                    throw new RuntimeException("Duplicate dataIn name " + dataOutName);
                }
                eventNameSet.add(dataOutName);
                this.resolveTagContents("instance", dataOut, this.evalInst);
            }
        }
    }

    private void resolveIODataset(Element eAppXml) throws CoordinatorJobException {
        Element outputList;
        Element inputList = eAppXml.getChild("input-events", eAppXml.getNamespace());
        if (inputList != null) {
            for (Element dataIn : inputList.getChildren("data-in", eAppXml.getNamespace())) {
                this.resolveAttribute("dataset", dataIn, this.evalInst);
            }
        }
        if ((outputList = eAppXml.getChild("output-events", eAppXml.getNamespace())) != null) {
            for (Element dataOut : outputList.getChildren("data-out", eAppXml.getNamespace())) {
                this.resolveAttribute("dataset", dataOut, this.evalInst);
            }
        }
    }

    private void addAnAttribute(String attrName, Element elem, String value) {
        elem.setAttribute(attrName, value);
    }

    private void resolveDataSets(Element eAppXml) throws Exception {
        Element datasetList = eAppXml.getChild("datasets", eAppXml.getNamespace());
        if (datasetList != null) {
            List dsElems = datasetList.getChildren("dataset", eAppXml.getNamespace());
            this.resolveDataSets(dsElems);
            this.resolveTagContents("app-path", eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()), this.evalNofuncs);
        }
    }

    private void resolveDataSets(List<Element> dsElems) throws CoordinatorJobException {
        for (Element dsElem : dsElems) {
            this.evalFreq.setVariable("timeunit", (Object)TimeUnit.MINUTE);
            this.evalFreq.setVariable("endOfDuration", (Object)TimeUnit.NONE);
            String val = this.resolveAttribute("frequency", dsElem, this.evalFreq);
            int ival = ParamChecker.checkInteger(val, "frequency");
            ParamChecker.checkGTZero(ival, "frequency");
            this.addAnAttribute("freq_timeunit", dsElem, this.evalFreq.getVariable("timeunit") == null ? TimeUnit.MINUTE.toString() : ((TimeUnit)((Object)this.evalFreq.getVariable("timeunit"))).toString());
            this.addAnAttribute("end_of_duration", dsElem, this.evalFreq.getVariable("endOfDuration") == null ? TimeUnit.NONE.toString() : ((TimeUnit)((Object)this.evalFreq.getVariable("endOfDuration"))).toString());
            val = this.resolveAttribute("initial-instance", dsElem, this.evalNofuncs);
            ParamChecker.checkDateOozieTZ(val, "initial-instance");
            this.checkInitialInstance(val);
            val = this.resolveAttribute("timezone", dsElem, this.evalNofuncs);
            ParamChecker.checkTimeZone(val, "timezone");
            this.resolveTagContents("uri-template", dsElem, this.evalNofuncs);
            this.resolveTagContents("done-flag", dsElem, this.evalNofuncs);
        }
    }

    private String resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws CoordinatorJobException {
        String ret = "";
        if (elem != null) {
            for (Element tagElem : elem.getChildren(tagName, elem.getNamespace())) {
                String updated;
                if (tagElem == null) continue;
                try {
                    updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText().trim());
                }
                catch (Exception e) {
                    throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
                }
                tagElem.removeContent();
                tagElem.addContent(updated);
                ret = ret + updated;
            }
        }
        return ret;
    }

    private String resolveAttribute(String attrName, Element elem, ELEvaluator eval) throws CoordinatorJobException {
        Attribute attr = elem.getAttribute(attrName);
        String val = null;
        if (attr != null) {
            try {
                val = CoordELFunctions.evalAndWrap(eval, attr.getValue().trim());
            }
            catch (Exception e) {
                throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
            }
            attr.setValue(val);
        }
        return val;
    }

    protected void includeDataSets(Element resolvedXml, Configuration conf) throws CoordinatorJobException {
        Element datasets = resolvedXml.getChild("datasets", resolvedXml.getNamespace());
        Element allDataSets = new Element("all_datasets", resolvedXml.getNamespace());
        ArrayList<String> dsList = new ArrayList<String>();
        if (datasets != null) {
            for (Element includeElem : datasets.getChildren("include", datasets.getNamespace())) {
                String incDSFile = includeElem.getTextTrim();
                this.includeOneDSFile(incDSFile, dsList, allDataSets, datasets.getNamespace());
            }
            for (Element e : datasets.getChildren("dataset", datasets.getNamespace())) {
                String dsName = e.getAttributeValue("name");
                if (dsList.contains(dsName)) {
                    CoordSubmitXCommand.removeDataSet(allDataSets, dsName);
                } else {
                    dsList.add(dsName);
                }
                allDataSets.addContent((Content)((Element)e.clone()));
            }
        }
        this.insertDataSet(resolvedXml, allDataSets);
        resolvedXml.removeChild("datasets", resolvedXml.getNamespace());
    }

    private void includeOneDSFile(String incDSFile, List<String> dsList, Element allDataSets, Namespace dsNameSpace) throws CoordinatorJobException {
        Element tmpDataSets = null;
        try {
            String dsXml = this.readDefinition(incDSFile);
            this.LOG.debug("DSFILE :" + incDSFile + "\n" + dsXml);
            tmpDataSets = XmlUtils.parseXml(dsXml);
        }
        catch (JDOMException e) {
            this.LOG.warn("Error parsing included dataset [{0}].  Message [{1}]", incDSFile, e.getMessage());
            throw new CoordinatorJobException(ErrorCode.E0700, e.getMessage());
        }
        this.resolveDataSets(tmpDataSets.getChildren("dataset"));
        for (Element e : tmpDataSets.getChildren("dataset")) {
            String dsName = e.getAttributeValue("name");
            if (dsList.contains(dsName)) {
                throw new RuntimeException("Duplicate Dataset " + dsName);
            }
            dsList.add(dsName);
            Element tmp = (Element)e.clone();
            tmp.setNamespace(dsNameSpace);
            tmp.getChild("uri-template").setNamespace(dsNameSpace);
            if (e.getChild("done-flag") != null) {
                tmp.getChild("done-flag").setNamespace(dsNameSpace);
            }
            allDataSets.addContent((Content)tmp);
        }
        for (Element includeElem : tmpDataSets.getChildren("include", tmpDataSets.getNamespace())) {
            String incFile = includeElem.getTextTrim();
            this.includeOneDSFile(incFile, dsList, allDataSets, dsNameSpace);
        }
    }

    private static void removeDataSet(Element eDatasets, String name) {
        for (Element eDataset : eDatasets.getChildren("dataset", eDatasets.getNamespace())) {
            if (!eDataset.getAttributeValue("name").equals(name)) continue;
            eDataset.detach();
            return;
        }
        throw new RuntimeException("undefined dataset: " + name);
    }

    protected String readDefinition(String appPath) throws CoordinatorJobException {
        String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
        try {
            URI uri = new URI(appPath);
            this.LOG.debug("user =" + user);
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)fsConf);
            Path appDefPath = null;
            Path path = new Path(uri.getPath());
            if (!fs.exists(path)) {
                throw new URISyntaxException(path.toString(), "path not existed : " + path.toString());
            }
            appDefPath = !fs.isFile(path) ? new Path(path, COORDINATOR_XML_FILE) : path;
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(appDefPath));
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            return writer.toString();
        }
        catch (IOException ex) {
            this.LOG.warn((Object)("IOException :" + XmlUtils.prettyPrint(this.conf)), ex);
            throw new CoordinatorJobException(ErrorCode.E1001, ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            this.LOG.warn("URISyException :" + ex.getMessage());
            throw new CoordinatorJobException(ErrorCode.E1002, appPath, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new CoordinatorJobException(ex);
        }
        catch (Exception ex) {
            this.LOG.warn((Object)"Exception :", ex);
            throw new CoordinatorJobException(ErrorCode.E1001, ex.getMessage(), ex);
        }
    }

    protected String storeToDB(String appXML, Element eJob, CoordinatorJobBean coordJob) throws CommandException {
        String jobId = Services.get().get(UUIDService.class).generateId(UUIDService.ApplicationType.COORDINATOR);
        coordJob.setId(jobId);
        coordJob.setAppPath(this.conf.get("oozie.coord.application.path"));
        coordJob.setCreatedTime(new Date());
        coordJob.setUser(this.conf.get("user.name"));
        String group = ConfigUtils.getWithDeprecatedCheck(this.conf, "oozie.job.acl", "group.name", null);
        coordJob.setGroup(group);
        coordJob.setConf(XmlUtils.prettyPrint(this.conf).toString());
        coordJob.setJobXml(XmlUtils.prettyPrint(eJob).toString());
        coordJob.setLastActionNumber(0);
        coordJob.setLastModifiedTime(new Date());
        if (!this.dryrun) {
            coordJob.setLastModifiedTime(new Date());
            try {
                CoordJobQueryExecutor.getInstance().insert(coordJob);
            }
            catch (JPAExecutorException jpaee) {
                coordJob.setId(null);
                coordJob.setStatus(Job.Status.FAILED);
                throw new CommandException(jpaee);
            }
        }
        return jobId;
    }

    private void checkInitialInstance(String val) throws CoordinatorJobException, IllegalArgumentException {
        Date givenInstance;
        Date initialInstance;
        try {
            initialInstance = DateUtils.parseDateUTC("1970-01-01T00:00Z");
            givenInstance = DateUtils.parseDateOozieTZ(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse dataset initial-instance string '" + val + "' to Date object. ", e);
        }
        if (givenInstance.compareTo(initialInstance) < 0) {
            throw new CoordinatorJobException(ErrorCode.E1021, "Dataset initial-instance " + val + " is earlier than the default initial instance " + DateUtils.formatDateOozieTZ(initialInstance));
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        this.coordJob = new CoordinatorJobBean();
        if (this.bundleId != null) {
            this.coordJob.setBundleId(this.bundleId);
            this.logInfo.setParameter("JOB", this.bundleId);
            LogUtils.setLogInfo(this.logInfo);
        }
        if (this.coordName != null) {
            this.coordJob.setAppName(this.coordName);
        }
        this.setJob((Job)this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            this.LOG.debug("Updating bundle record: " + this.coordJob.getBundleId() + " for coord id: " + this.coordJob.getId());
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public void updateJob() throws CommandException {
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }

    @Override
    public void performWrites() throws CommandException {
    }

    static {
        String[] badUserProps = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

