/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.SignalXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.db.SLADbXOperations;
import org.apache.oozie.workflow.WorkflowInstance;

public class ActionEndXCommand
extends ActionXCommand<Void> {
    public static final String COULD_NOT_END = "COULD_NOT_END";
    public static final String END_DATA_MISSING = "END_DATA_MISSING";
    private String jobId = null;
    private String actionId = null;
    private WorkflowJobBean wfJob = null;
    private WorkflowActionBean wfAction = null;
    private JPAService jpaService = null;
    private ActionExecutor executor = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public ActionEndXCommand(String actionId, String type) {
        super("action.end", type, 0);
        this.actionId = actionId;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_ACTION_OP, this.jobId);
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_END, this.actionId);
            LogUtils.setLogInfo(this.wfJob, this.logInfo);
            LogUtils.setLogInfo(this.wfAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJob == null) {
            throw new PreconditionException(ErrorCode.E0604, this.jobId);
        }
        if (this.wfAction == null) {
            throw new PreconditionException(ErrorCode.E0605, this.actionId);
        }
        if (this.wfAction.isPending() && (this.wfAction.getStatus() == WorkflowAction.Status.DONE || this.wfAction.getStatus() == WorkflowAction.Status.END_RETRY || this.wfAction.getStatus() == WorkflowAction.Status.END_MANUAL)) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING) {
                throw new PreconditionException(ErrorCode.E0811, WorkflowJob.Status.RUNNING.toString());
            }
        } else {
            throw new PreconditionException(ErrorCode.E0812, this.wfAction.isPending(), this.wfAction.getStatusStr());
        }
        this.executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType());
        if (this.executor == null) {
            throw new CommandException(ErrorCode.E0802, this.wfAction.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED ActionEndXCommand for action " + this.actionId);
        Configuration conf = this.wfJob.getWorkflowInstance().getConf();
        int maxRetries = 0;
        long retryInterval = 0L;
        if (!(this.executor instanceof ControlNodeActionExecutor)) {
            maxRetries = conf.getInt("oozie.wf.action.max.retries", this.executor.getMaxRetries());
            retryInterval = conf.getLong("oozie.wf.action.retry.interval", this.executor.getRetryInterval());
        }
        this.executor.setMaxRetries(maxRetries);
        this.executor.setRetryInterval(retryInterval);
        boolean isRetry = false;
        if (this.wfAction.getStatus() == WorkflowAction.Status.END_RETRY || this.wfAction.getStatus() == WorkflowAction.Status.END_MANUAL) {
            isRetry = true;
        }
        boolean isUserRetry = false;
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
        try {
            this.LOG.debug("End, name [{0}] type [{1}] status[{2}] external status [{3}] signal value [{4}]", this.wfAction.getName(), this.wfAction.getType(), this.wfAction.getStatus(), this.wfAction.getExternalStatus(), this.wfAction.getSignalValue());
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            this.executor.end(context, this.wfAction);
            cron.stop();
            this.addActionCron(this.wfAction.getType(), cron);
            WorkflowInstance wfInstance = this.wfJob.getWorkflowInstance();
            DagELFunctions.setActionInfo(wfInstance, this.wfAction);
            this.wfJob.setWorkflowInstance(wfInstance);
            this.incrActionCounter(this.wfAction.getType(), 1);
            if (!context.isEnded()) {
                this.LOG.warn(4, "Action Ended, ActionExecutor [{0}] must call setEndData()", this.executor.getType());
                this.wfAction.setErrorInfo(END_DATA_MISSING, "Execution Ended, but End Data Missing from Action");
                this.failJob(context);
            } else {
                SLAEventBean slaEvent;
                this.wfAction.setRetries(0);
                this.wfAction.setEndTime(new Date());
                boolean shouldHandleUserRetry = false;
                SLAEvent.Status slaStatus = null;
                switch (this.wfAction.getStatus()) {
                    case OK: {
                        slaStatus = SLAEvent.Status.SUCCEEDED;
                        break;
                    }
                    case KILLED: {
                        slaStatus = SLAEvent.Status.KILLED;
                        break;
                    }
                    case FAILED: {
                        slaStatus = SLAEvent.Status.FAILED;
                        shouldHandleUserRetry = true;
                        break;
                    }
                    case ERROR: {
                        this.LOG.info("ERROR is considered as FAILED for SLA");
                        slaStatus = SLAEvent.Status.KILLED;
                        shouldHandleUserRetry = true;
                        break;
                    }
                    default: {
                        slaStatus = SLAEvent.Status.FAILED;
                        shouldHandleUserRetry = true;
                    }
                }
                if (!(shouldHandleUserRetry && this.handleUserRetry(this.wfAction) || (slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), slaStatus, SLAEvent.SlaAppType.WORKFLOW_ACTION)) == null)) {
                    this.insertList.add(slaEvent);
                }
            }
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        }
        catch (ActionExecutorException ex) {
            this.LOG.warn("Error ending action [{0}]. ErrorType [{1}], ErrorCode [{2}], Message [{3}]", new Object[]{this.wfAction.getName(), ex.getErrorType(), ex.getErrorCode(), ex.getMessage()});
            this.wfAction.setErrorInfo(ex.getErrorCode(), ex.getMessage());
            this.wfAction.setEndTime(null);
            switch (ex.getErrorType()) {
                case TRANSIENT: {
                    if (!this.handleTransient(context, this.executor, WorkflowAction.Status.END_RETRY)) {
                        this.handleNonTransient(context, this.executor, WorkflowAction.Status.END_MANUAL);
                        this.wfAction.setPendingAge(new Date());
                        this.wfAction.setRetries(0);
                    }
                    this.wfAction.setEndTime(null);
                    break;
                }
                case NON_TRANSIENT: {
                    this.handleNonTransient(context, this.executor, WorkflowAction.Status.END_MANUAL);
                    this.wfAction.setEndTime(null);
                    break;
                }
                case ERROR: {
                    this.handleError(context, this.executor, COULD_NOT_END, false, WorkflowAction.Status.ERROR);
                    break;
                }
                case FAILED: {
                    this.failJob(context);
                }
            }
            WorkflowInstance wfInstance = this.wfJob.getWorkflowInstance();
            DagELFunctions.setActionInfo(wfInstance, this.wfAction);
            this.wfJob.setWorkflowInstance(wfInstance);
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        }
        finally {
            try {
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            if (!(this.executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                this.generateEvent(this.wfAction, this.wfJob.getUser());
            }
            new SignalXCommand(this.jobId, this.actionId).call(this.getEntityKey());
        }
        this.LOG.debug("ENDED ActionEndXCommand for action " + this.actionId);
        return null;
    }
}

