/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsForDatesJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String jobId = null;
    private Date startDate;
    private Date endDate;

    public CoordJobGetActionsForDatesJPAExecutor(String jobId, Date startDate, Date endDate) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsForDatesJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_ACTIONS_FOR_DATES");
            q.setParameter("jobId", (Object)this.jobId);
            q.setParameter("startTime", (Object)new Timestamp(this.startDate.getTime()));
            q.setParameter("endTime", (Object)new Timestamp(this.endDate.getTime()));
            List actions = q.getResultList();
            return actions;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

