/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.event.message.CoordinatorActionMessage;
import org.apache.oozie.client.event.message.JobMessage;
import org.apache.oozie.client.event.message.WorkflowJobMessage;
import org.apache.oozie.event.BundleJobEvent;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.CoordinatorJobEvent;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.event.messaging.MessageFactory;
import org.apache.oozie.event.messaging.MessageSerializer;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class JMSJobEventListener
extends JobEventListener {
    private JMSAccessorService jmsService = Services.get().get(JMSAccessorService.class);
    private JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
    private JMSConnectionInfo connInfo;
    public static final String JMS_CONNECTION_PROPERTIES = "oozie.jms.producer.connection.properties";
    public static final String JMS_SESSION_OPTS = "oozie.jms.producer.session.opts";
    public static final String JMS_DELIVERY_MODE = "oozie.jms.delivery.mode";
    public static final String JMS_EXPIRATION_DATE = "oozie.jms.expiration.date";
    private int jmsSessionOpts;
    private int jmsDeliveryMode;
    private int jmsExpirationDate;
    private ConnectionContext jmsContext;
    private static XLog LOG;

    @Override
    public void init(Configuration conf) {
        LOG = XLog.getLog(this.getClass());
        String jmsProps = conf.get(JMS_CONNECTION_PROPERTIES);
        LOG.info("JMS producer connection properties [{0}]", jmsProps);
        this.connInfo = new JMSConnectionInfo(jmsProps);
        this.jmsSessionOpts = conf.getInt(JMS_SESSION_OPTS, 1);
        this.jmsDeliveryMode = conf.getInt(JMS_DELIVERY_MODE, 2);
        this.jmsExpirationDate = conf.getInt(JMS_EXPIRATION_DATE, 0);
    }

    protected void sendMessage(Map<String, String> messageProperties, String messageBody, String topicName, String messageFormat) {
        this.jmsContext = this.jmsService.createProducerConnectionContext(this.connInfo);
        if (this.jmsContext != null) {
            try {
                Session session = this.jmsContext.createThreadLocalSession(this.jmsSessionOpts);
                TextMessage textMessage = session.createTextMessage(messageBody);
                for (Map.Entry<String, String> property : messageProperties.entrySet()) {
                    textMessage.setStringProperty(property.getKey(), property.getValue());
                }
                textMessage.setStringProperty("msgFormat", messageFormat);
                LOG.trace("Event related JMS text body [{0}]", textMessage.getText());
                LOG.trace("Event related JMS entire message [{0}]", textMessage.toString());
                MessageProducer producer = this.jmsContext.createProducer(session, topicName);
                producer.setDeliveryMode(this.jmsDeliveryMode);
                producer.setTimeToLive((long)this.jmsExpirationDate);
                producer.send((Message)textMessage);
                producer.close();
            }
            catch (JMSException jmse) {
                LOG.error((Object)"Exception happened while sending event related jms message", jmse);
            }
        }
    }

    @Override
    public void onWorkflowJobEvent(WorkflowJobEvent event) {
        WorkflowJobMessage wfJobMessage = MessageFactory.createWorkflowJobMessage(event);
        this.serializeJMSMessage((JobMessage)wfJobMessage, this.getTopic(event));
    }

    @Override
    public void onCoordinatorActionEvent(CoordinatorActionEvent event) {
        CoordinatorActionMessage coordActionMessage = MessageFactory.createCoordinatorActionMessage(event);
        this.serializeJMSMessage((JobMessage)coordActionMessage, this.getTopic(event));
    }

    private void serializeJMSMessage(JobMessage jobMessage, String topicName) {
        MessageSerializer serializer = MessageFactory.getMessageSerializer();
        String messageBody = serializer.getSerializedObject(jobMessage);
        this.sendMessage(jobMessage.getMessageProperties(), messageBody, topicName, serializer.getMessageFormat());
    }

    protected String getTopic(WorkflowJobEvent event) {
        if (this.jmsTopicService != null) {
            return this.jmsTopicService.getTopic(event.getAppType(), event.getUser(), event.getId(), event.getParentId());
        }
        throw new RuntimeException("JMSTopicService is not initialized");
    }

    protected String getTopic(CoordinatorActionEvent event) {
        if (this.jmsTopicService != null) {
            return this.jmsTopicService.getTopic(event.getAppType(), event.getUser(), event.getId(), event.getParentId());
        }
        throw new RuntimeException("JMSTopicService is not initialized");
    }

    @Override
    public void onWorkflowActionEvent(WorkflowActionEvent wae) {
    }

    @Override
    public void onCoordinatorJobEvent(CoordinatorJobEvent wje) {
    }

    @Override
    public void onBundleJobEvent(BundleJobEvent wje) {
    }

    @Override
    public void destroy() {
    }
}

