/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformPluginDeploymentListener
implements ArtifactUrlTransformer {
    public static final String PROTOCOL = "pentaho-platform-plugin-file";
    private Logger logger = LoggerFactory.getLogger(PlatformPluginDeploymentListener.class);
    private URLFactory urlFactory = new URLFactory(){

        @Override
        public URL create(String protocol, String file) throws MalformedURLException {
            return new URL(protocol, null, file);
        }
    };

    protected void setUrlFactory(URLFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    public URL transform(URL artifact) throws Exception {
        return this.urlFactory.create(PROTOCOL, artifact.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        if (artifact == null || artifact.getName() == null || !artifact.getName().endsWith(".zip")) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(artifact);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    String[] splitName = entries.nextElement().getName().split("/");
                    if (splitName.length != 2 || !"plugin.xml".equals(splitName[1])) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static interface URLFactory {
        public URL create(String var1, String var2) throws MalformedURLException;
    }
}

