/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.impl.ExceptionSettable;
import org.pentaho.osgi.platform.plugin.deployer.impl.PluginMetadataImpl;
import org.w3c.dom.Document;

public class PluginZipFileProcessor {
    public static final String BLUEPRINT = "OSGI-INF/blueprint/blueprint.xml";
    public static final String BLUEPRINT_REGEX = ".*\\/OSGI-INF\\/blueprint\\/.*\\.xml";
    public static final String MANIFEST_REGEX = ".*\\/META-INF\\/MANIFEST.MF";
    private final List<PluginFileHandler> pluginFileHandlers;
    private final String name;
    private final String symbolicName;
    private final String version;

    public PluginZipFileProcessor(List<PluginFileHandler> pluginFileHandlers, String name, String symbolicName, String version) {
        this.pluginFileHandlers = pluginFileHandlers;
        this.name = name;
        this.symbolicName = symbolicName;
        this.version = version;
    }

    public Future<Void> processBackground(ExecutorService executorService, final ZipInputStream zipInputStream, final ZipOutputStream zipOutputStream, final ExceptionSettable<IOException> exceptionSettable) {
        return executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    PluginZipFileProcessor.this.process(zipInputStream, zipOutputStream);
                }
                catch (IOException e) {
                    exceptionSettable.setException(e);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        File dir = Files.createTempDir();
        PluginMetadataImpl pluginMetadata = null;
        try {
            pluginMetadata = new PluginMetadataImpl(dir);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Manifest manifest = null;
        try {
            ZipEntry zipEntry = null;
            Document blueprint = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int read;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)Math.max(0L, Math.min(Integer.MAX_VALUE, zipEntry.getSize())));
                byte[] buffer = new byte[1024];
                while ((read = zipInputStream.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, read);
                }
                byte[] zipBytes = byteArrayOutputStream.toByteArray();
                String name = zipEntry.getName();
                boolean shouldOutput = true;
                if (name.matches(MANIFEST_REGEX)) {
                    shouldOutput = false;
                    manifest = new Manifest(new ByteArrayInputStream(zipBytes));
                } else if (name.matches(BLUEPRINT_REGEX)) {
                    shouldOutput = false;
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilderFactory.setNamespaceAware(true);
                        blueprint = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(zipBytes));
                        pluginMetadata.setBlueprint(blueprint);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (!shouldOutput) continue;
                File outFile = new File(dir.getAbsolutePath() + "/" + zipEntry.getName());
                int tries = 100;
                File outParent = outFile.getParentFile();
                while (!outParent.exists() && tries-- > 0) {
                    outParent.mkdirs();
                }
                if (zipEntry.isDirectory()) {
                    tries = 100;
                    while (!outFile.exists() && tries-- > 0) {
                        outFile.mkdir();
                    }
                    continue;
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(outFile);
                    boolean len = false;
                    fileOutputStream.write(zipBytes);
                }
                finally {
                    if (fileOutputStream == null) continue;
                    fileOutputStream.close();
                }
            }
            if (this.pluginFileHandlers != null) {
                Stack<File> fileStack = new Stack<File>();
                fileStack.push(dir);
                while (fileStack.size() > 0) {
                    File[] dirFiles;
                    File currentFile;
                    File searchFile = currentFile = (File)fileStack.pop();
                    Stack<String> dirStack = new Stack<String>();
                    while (!searchFile.equals(dir)) {
                        dirStack.push(searchFile.getName());
                        searchFile = searchFile.getParentFile();
                    }
                    Object currentFileName = null;
                    StringBuilder sb = new StringBuilder();
                    while (dirStack.size() > 0) {
                        sb.append((String)dirStack.pop());
                        sb.append("/");
                    }
                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    String currentPath = sb.toString();
                    for (PluginFileHandler pluginFileHandler : this.pluginFileHandlers) {
                        if (!pluginFileHandler.handles(currentPath)) continue;
                        try {
                            pluginFileHandler.handle(currentPath, currentFile, pluginMetadata);
                        }
                        catch (PluginHandlingException e) {
                            throw new IOException(e);
                        }
                    }
                    if (!currentFile.isDirectory()) continue;
                    for (File file : dirFiles = currentFile.listFiles()) {
                        fileStack.push(file);
                    }
                }
            }
            int tries = 100;
            File blueprintDir = new File(dir.getAbsolutePath() + "/" + BLUEPRINT.substring(0, BLUEPRINT.lastIndexOf(47)));
            while (!blueprintDir.exists() && tries-- > 0) {
                blueprintDir.mkdirs();
            }
            try (FileOutputStream blueprintOutputStream = null;){
                blueprintOutputStream = new FileOutputStream(dir.getAbsolutePath() + "/" + BLUEPRINT);
                pluginMetadata.writeBlueprint(this.name, blueprintOutputStream);
            }
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException zipEntry) {}
        }
        HashSet<String> createdEntries = new HashSet<String>();
        String manifestFolder = "META-INF/MANIFEST.MF".split("/")[0] + "/";
        ZipEntry manifestFolderEntry = new ZipEntry(manifestFolder);
        zipOutputStream.putNextEntry(manifestFolderEntry);
        zipOutputStream.closeEntry();
        createdEntries.add(manifestFolder);
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(manifestEntry);
        pluginMetadata.getManifestUpdater().write(manifest, zipOutputStream, this.name, this.symbolicName, this.version);
        zipOutputStream.closeEntry();
        createdEntries.add("META-INF/MANIFEST.MF");
        Stack<File> dirStack = new Stack<File>();
        dirStack.push(dir);
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while (dirStack.size() > 0) {
                File[] dirFiles;
                File currentDir = (File)dirStack.pop();
                String dirName = currentDir.getAbsolutePath().substring(dir.getAbsolutePath().length()) + "/";
                if (dirName.startsWith("/") || dirName.startsWith("\\")) {
                    dirName = dirName.substring(1);
                }
                if (dirName.length() > 0 && !createdEntries.contains(dirName)) {
                    ZipEntry zipEntry = new ZipEntry(dirName.replaceAll(Pattern.quote("\\"), "/"));
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.closeEntry();
                }
                if ((dirFiles = currentDir.listFiles()) == null) continue;
                for (File childFile : dirFiles) {
                    if (childFile.isDirectory()) {
                        dirStack.push(childFile);
                        continue;
                    }
                    String fileName = childFile.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
                    try (FileInputStream fileInputStream = null;){
                        fileInputStream = new FileInputStream(childFile);
                        ZipEntry childZipEntry = new ZipEntry(fileName.replaceAll(Pattern.quote("\\"), "/"));
                        zipOutputStream.putNextEntry(childZipEntry);
                        while ((len = fileInputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, len);
                        }
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {}
            this.recursiveDelete(dir);
        }
    }

    private void recursiveDelete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.recursiveDelete(child);
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }
}

