/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLibraryFileHandler
implements PluginFileHandler {
    private static Logger log = LoggerFactory.getLogger(PluginLibraryFileHandler.class);
    public static final Pattern LIB_PATTERN = Pattern.compile(".+\\/lib\\/.+\\.jar");
    public static final String JAR = ".jar";

    @Override
    public boolean handles(String fileName) {
        return LIB_PATTERN.matcher(fileName).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String relativePath, File file, PluginMetadata pluginMetadata) throws PluginHandlingException {
        FileInputStream fin = null;
        ZipInputStream jarInputStream = null;
        try {
            ZipEntry nextEntry;
            fin = new FileInputStream(file);
            jarInputStream = new JarInputStream(fin);
            String bundleSymbolicName = ((JarInputStream)jarInputStream).getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleSymbolicName != null) {
                log.info(String.format("Jar identified as an OSGi bundle [%s]; no auto-deploy. Assumed to be provided by the container.", bundleSymbolicName.toString()));
                return;
            }
            while ((nextEntry = ((JarInputStream)jarInputStream).getNextEntry()) != null) {
                String contents;
                if (nextEntry.isDirectory()) continue;
                String name = nextEntry.getName();
                try (ByteArrayOutputStream byteArrayOutputStream = null;){
                    byteArrayOutputStream = new ByteArrayOutputStream((int)Math.min(Integer.MAX_VALUE, Math.max(0L, nextEntry.getSize())));
                    ByteStreams.copy((InputStream)jarInputStream, (OutputStream)byteArrayOutputStream);
                }
                if (name.matches(".+\\.xml") && (contents = byteArrayOutputStream.toString("UTF-8")).contains("http://www.springframework.org/schema/beans")) {
                    FileWriter fileWriter = pluginMetadata.getFileWriter("META-INF/spring/" + name);
                    fileWriter.append(contents);
                    fileWriter.close();
                    continue;
                }
                OutputStream fileOut = pluginMetadata.getFileOutputStream(nextEntry.getName());
                fileOut.write(byteArrayOutputStream.toByteArray());
                fileOut.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                jarInputStream.close();
                fin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

