/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.NodeLabelsStore;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeRequestPBImpl;

public class FileSystemNodeLabelsStore
extends NodeLabelsStore {
    protected static final Log LOG = LogFactory.getLog(FileSystemNodeLabelsStore.class);
    protected static final String DEFAULT_DIR_NAME = "node-labels";
    protected static final String MIRROR_FILENAME = "nodelabel.mirror";
    protected static final String EDITLOG_FILENAME = "nodelabel.editlog";
    Path fsWorkingPath;
    FileSystem fs;
    private FSDataOutputStream editlogOs;
    private Path editLogPath;

    private String getDefaultFSNodeLabelsRootDir() throws IOException {
        return "file:///tmp/hadoop-yarn-" + UserGroupInformation.getCurrentUser().getShortUserName() + "/" + DEFAULT_DIR_NAME;
    }

    @Override
    public void init(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.node-labels.fs-store.root-dir", this.getDefaultFSNodeLabelsRootDir()));
        this.setFileSystem(conf);
        this.fs.mkdirs(this.fsWorkingPath);
    }

    @Override
    public void close() throws IOException {
        try {
            this.fs.close();
            this.editlogOs.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception happened whiling shutting down,", (Throwable)e);
        }
    }

    private void setFileSystem(Configuration conf) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setBoolean("dfs.client.retry.policy.enabled", true);
        String retryPolicy = confCopy.get("yarn.node-labels.fs-store.retry-policy-spec", "2000, 500");
        confCopy.set("dfs.client.retry.policy.spec", retryPolicy);
        this.fs = this.fsWorkingPath.getFileSystem(confCopy);
        if (this.fs.getScheme().equals("file")) {
            this.fs = ((LocalFileSystem)this.fs).getRaw();
        }
    }

    private void ensureAppendEditlogFile() throws IOException {
        this.editlogOs = this.fs.append(this.editLogPath);
    }

    private void ensureCloseEditlogFile() throws IOException {
        this.editlogOs.close();
    }

    @Override
    public void updateNodeToLabelsMappings(Map<NodeId, Set<String>> nodeToLabels) throws IOException {
        this.ensureAppendEditlogFile();
        this.editlogOs.writeInt(SerializedLogType.NODE_TO_LABELS.ordinal());
        ((ReplaceLabelsOnNodeRequestPBImpl)ReplaceLabelsOnNodeRequest.newInstance(nodeToLabels)).getProto().writeDelimitedTo((OutputStream)this.editlogOs);
        this.ensureCloseEditlogFile();
    }

    @Override
    public void storeNewClusterNodeLabels(List<NodeLabel> labels) throws IOException {
        this.ensureAppendEditlogFile();
        this.editlogOs.writeInt(SerializedLogType.ADD_LABELS.ordinal());
        ((AddToClusterNodeLabelsRequestPBImpl)AddToClusterNodeLabelsRequest.newInstance(labels)).getProto().writeDelimitedTo((OutputStream)this.editlogOs);
        this.ensureCloseEditlogFile();
    }

    @Override
    public void removeClusterNodeLabels(Collection<String> labels) throws IOException {
        this.ensureAppendEditlogFile();
        this.editlogOs.writeInt(SerializedLogType.REMOVE_LABELS.ordinal());
        ((RemoveFromClusterNodeLabelsRequestPBImpl)RemoveFromClusterNodeLabelsRequest.newInstance((Set)Sets.newHashSet(labels.iterator()))).getProto().writeDelimitedTo((OutputStream)this.editlogOs);
        this.ensureCloseEditlogFile();
    }

    protected void loadFromMirror(Path newMirrorPath, Path oldMirrorPath) throws IOException {
        FSDataInputStream is = null;
        if (this.fs.exists(newMirrorPath)) {
            is = this.fs.open(newMirrorPath);
        } else if (this.fs.exists(oldMirrorPath)) {
            is = this.fs.open(oldMirrorPath);
        }
        if (null != is) {
            List<NodeLabel> labels = new AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.parseDelimitedFrom((InputStream)is)).getNodeLabels();
            this.mgr.addToCluserNodeLabels(labels);
            Map<NodeId, Set<String>> nodeToLabels = new ReplaceLabelsOnNodeRequestPBImpl(YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.parseDelimitedFrom((InputStream)is)).getNodeToLabels();
            this.mgr.replaceLabelsOnNode(nodeToLabels);
            is.close();
        }
    }

    @Override
    public void recover() throws YarnException, IOException {
        Path mirrorPath = new Path(this.fsWorkingPath, MIRROR_FILENAME);
        Path oldMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror.old");
        this.loadFromMirror(mirrorPath, oldMirrorPath);
        this.editLogPath = new Path(this.fsWorkingPath, EDITLOG_FILENAME);
        if (this.fs.exists(this.editLogPath)) {
            FSDataInputStream is = this.fs.open(this.editLogPath);
            try {
                while (true) {
                    SerializedLogType type = SerializedLogType.values()[is.readInt()];
                    switch (type) {
                        case ADD_LABELS: {
                            List<NodeLabel> labels = new AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.parseDelimitedFrom((InputStream)is)).getNodeLabels();
                            this.mgr.addToCluserNodeLabels(labels);
                            break;
                        }
                        case REMOVE_LABELS: {
                            List<NodeLabel> labels = YarnServerResourceManagerServiceProtos.RemoveFromClusterNodeLabelsRequestProto.parseDelimitedFrom((InputStream)is).getNodeLabelsList();
                            this.mgr.removeFromClusterNodeLabels(labels);
                            break;
                        }
                        case NODE_TO_LABELS: {
                            Map<NodeId, Set<String>> map = new ReplaceLabelsOnNodeRequestPBImpl(YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.parseDelimitedFrom((InputStream)is)).getNodeToLabels();
                            this.mgr.replaceLabelsOnNode(map);
                            break;
                        }
                    }
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
        Path writingMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror.writing");
        FSDataOutputStream os = this.fs.create(writingMirrorPath, true);
        ((AddToClusterNodeLabelsRequestPBImpl)AddToClusterNodeLabelsRequestPBImpl.newInstance(this.mgr.getClusterNodeLabels())).getProto().writeDelimitedTo((OutputStream)os);
        ((ReplaceLabelsOnNodeRequestPBImpl)ReplaceLabelsOnNodeRequest.newInstance(this.mgr.getNodeLabels())).getProto().writeDelimitedTo((OutputStream)os);
        os.close();
        if (this.fs.exists(mirrorPath)) {
            this.fs.delete(oldMirrorPath, false);
            this.fs.rename(mirrorPath, oldMirrorPath);
        }
        this.fs.rename(writingMirrorPath, mirrorPath);
        this.fs.delete(writingMirrorPath, false);
        this.fs.delete(oldMirrorPath, false);
        this.editlogOs = this.fs.create(this.editLogPath, true);
        this.editlogOs.close();
        LOG.info((Object)("Finished write mirror at:" + mirrorPath.toString()));
        LOG.info((Object)("Finished create editlog file at:" + this.editLogPath.toString()));
    }

    protected static enum SerializedLogType {
        ADD_LABELS,
        NODE_TO_LABELS,
        REMOVE_LABELS;

    }
}

