/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BulkResponseInfo;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.command.BulkJobsXCommand;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.bundle.BulkBundleXCommand;
import org.apache.oozie.command.bundle.BundleJobChangeXCommand;
import org.apache.oozie.command.bundle.BundleJobResumeXCommand;
import org.apache.oozie.command.bundle.BundleJobSuspendXCommand;
import org.apache.oozie.command.bundle.BundleJobXCommand;
import org.apache.oozie.command.bundle.BundleJobsXCommand;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.command.bundle.BundleRerunXCommand;
import org.apache.oozie.command.bundle.BundleSLAAlertsDisableXCommand;
import org.apache.oozie.command.bundle.BundleSLAAlertsEnableXCommand;
import org.apache.oozie.command.bundle.BundleSLAChangeXCommand;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.JobsFilterUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogAuditFilter;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class BundleEngine
extends BaseEngine {
    public BundleEngine() {
    }

    public BundleEngine(String user) {
        this.user = ParamChecker.notEmpty(user, "user");
    }

    @Override
    public void change(String jobId, String changeValue) throws BundleEngineException {
        try {
            BundleJobChangeXCommand change = new BundleJobChangeXCommand(jobId, changeValue);
            change.call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @Override
    public String dryRunSubmit(Configuration conf) throws BundleEngineException {
        BundleSubmitXCommand submit = new BundleSubmitXCommand(true, conf);
        try {
            String jobId = (String)submit.call();
            return jobId;
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId) throws BundleEngineException {
        throw new BundleEngineException(new XException(ErrorCode.E0301, "cannot get a coordinator job from BundleEngine"));
    }

    public BundleJobBean getBundleJob(String jobId) throws BundleEngineException {
        try {
            return (BundleJobBean)new BundleJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId, String filter, int start, int length, boolean desc) throws BundleEngineException {
        throw new BundleEngineException(new XException(ErrorCode.E0301, "cannot get a coordinator job from BundleEngine"));
    }

    @Override
    public String getDefinition(String jobId) throws BundleEngineException {
        BundleJobBean job;
        try {
            job = (BundleJobBean)new BundleJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
        return job.getOrigJobXml();
    }

    @Override
    public WorkflowJob getJob(String jobId) throws BundleEngineException {
        throw new BundleEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from BundleEngine"));
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws BundleEngineException {
        throw new BundleEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from BundleEngine"));
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws BundleEngineException {
        return null;
    }

    @Override
    public void kill(String jobId) throws BundleEngineException {
        try {
            new BundleKillXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new BundleEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void reRun(String jobId, Configuration conf) throws BundleEngineException {
        throw new BundleEngineException(new XException(ErrorCode.E0301, "rerun"));
    }

    public void reRun(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) throws BaseEngineException {
        try {
            new BundleRerunXCommand(jobId, coordScope, dateScope, refresh, noCleanup).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public void resume(String jobId) throws BundleEngineException {
        BundleJobResumeXCommand resume = new BundleJobResumeXCommand(jobId);
        try {
            resume.call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @Override
    public void start(String jobId) throws BundleEngineException {
        try {
            new BundleStartXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new BundleEngineException(e);
        }
    }

    @Override
    public void streamLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BundleEngineException {
        this.streamJobLog(jobId, writer, params, BaseEngine.LOG_TYPE.LOG);
    }

    @Override
    public void streamErrorLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BundleEngineException {
        this.streamJobLog(jobId, writer, params, BaseEngine.LOG_TYPE.ERROR_LOG);
    }

    @Override
    public void streamAuditLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BundleEngineException {
        try {
            this.streamJobLog(new XLogAuditFilter(new XLogUserFilterParam(params)), jobId, writer, params, BaseEngine.LOG_TYPE.AUDIT_LOG);
        }
        catch (CommandException e) {
            throw new IOException(e);
        }
    }

    private void streamJobLog(String jobId, Writer writer, Map<String, String[]> params, BaseEngine.LOG_TYPE logType) throws IOException, BundleEngineException {
        try {
            this.streamJobLog(new XLogFilter(new XLogUserFilterParam(params)), jobId, writer, params, logType);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void streamJobLog(XLogFilter filter, String jobId, Writer writer, Map<String, String[]> params, BaseEngine.LOG_TYPE logType) throws IOException, BundleEngineException {
        try {
            filter.setParameter("JOB", jobId);
            BundleJobBean job = (BundleJobBean)new BundleJobXCommand(jobId).call();
            Date lastTime = null;
            if (job.isTerminalStatus()) {
                lastTime = job.getLastModifiedTime();
            }
            if (lastTime == null) {
                lastTime = new Date();
            }
            this.fetchLog(filter, job.getCreatedTime(), lastTime, writer, params, logType);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws BundleEngineException {
        try {
            String jobId = (String)new BundleSubmitXCommand(conf).call();
            if (startJob) {
                this.start(jobId);
            }
            return jobId;
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @Override
    public void suspend(String jobId) throws BundleEngineException {
        BundleJobSuspendXCommand suspend = new BundleJobSuspendXCommand(jobId);
        try {
            suspend.call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    public BundleJobInfo getBundleJobs(String filter, int start, int len) throws BundleEngineException {
        Map<String, List<String>> filterList = this.parseFilter(filter);
        try {
            return (BundleJobInfo)new BundleJobsXCommand(filterList, start, len).call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    @VisibleForTesting
    Map<String, List<String>> parseFilter(String filter) throws BundleEngineException {
        try {
            return JobsFilterUtils.parseFilter(filter);
        }
        catch (ServletException ex) {
            throw new BundleEngineException(ErrorCode.E0420, filter, ex.getMessage());
        }
    }

    public BulkResponseInfo getBulkJobs(String bulkFilter, int start, int len) throws BundleEngineException {
        Map<String, List<String>> bulkRequestMap = BundleEngine.parseBulkFilter(bulkFilter);
        try {
            return (BulkResponseInfo)new BulkJobsXCommand(bulkRequestMap, start, len).call();
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    public static Map<String, List<String>> parseBulkFilter(String bulkParams) throws BundleEngineException {
        HashMap<String, List<String>> bulkFilter = new HashMap<String, List<String>>();
        if (bulkFilter != null) {
            StringTokenizer st = new StringTokenizer(bulkParams, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new BundleEngineException(ErrorCode.E0420, token, "elements must be name=value pairs");
                    }
                    pair[0] = pair[0].toLowerCase();
                    String[] values = pair[1].split(",");
                    if (!BulkResponseImpl.BULK_FILTER_NAMES.contains(pair[0])) {
                        throw new BundleEngineException(ErrorCode.E0420, token, XLog.format("invalid parameter name [{0}]", pair[0]));
                    }
                    if (pair[0].contains("time")) {
                        try {
                            DateUtils.parseDateUTC(pair[1]);
                        }
                        catch (ParseException e) {
                            throw new BundleEngineException(ErrorCode.E0420, token, XLog.format("invalid value [{0}] for time. A datetime value of pattern [{1}] is expected", pair[1], "yyyy-MM-dd'T'HH:mm'Z'"));
                        }
                    }
                    if (pair[0].equals("actionstatus")) {
                        for (String value : values) {
                            try {
                                CoordinatorAction.Status.valueOf((String)value);
                            }
                            catch (IllegalArgumentException ex) {
                                throw new BundleEngineException(ErrorCode.E0420, token, XLog.format("invalid action status [{0}]", value));
                            }
                        }
                    }
                    if ((list = (ArrayList<String>)bulkFilter.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        bulkFilter.put(pair[0], list);
                    }
                    for (String value : values) {
                        if ((value = value.trim()).isEmpty()) {
                            throw new BundleEngineException(ErrorCode.E0420, token, "value is empty or whitespace");
                        }
                        list.add(value);
                    }
                    continue;
                }
                throw new BundleEngineException(ErrorCode.E0420, token, "elements must be name=value pairs");
            }
            if (!bulkFilter.containsKey("bundle")) {
                throw new BundleEngineException(ErrorCode.E0305, "bundle");
            }
        }
        return bulkFilter;
    }

    @Override
    public String getJobStatus(String jobId) throws BundleEngineException {
        try {
            BundleJobBean bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, jobId);
            return bundleJob.getStatusStr();
        }
        catch (JPAExecutorException e) {
            throw new BundleEngineException(e);
        }
    }

    @Override
    public void enableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
        try {
            new BundleSLAAlertsEnableXCommand(id, actions, dates, childIds).call();
        }
        catch (CommandException e) {
            throw new BundleEngineException(e);
        }
    }

    @Override
    public void disableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
        try {
            new BundleSLAAlertsDisableXCommand(id, actions, dates, childIds).call();
        }
        catch (CommandException e) {
            throw new BundleEngineException(e);
        }
    }

    @Override
    public void changeSLA(String id, String actions, String dates, String childIds, String newParams) throws BaseEngineException {
        Map<String, String> slaNewParams = null;
        try {
            if (newParams != null) {
                slaNewParams = JobUtils.parseChangeValue(newParams);
            }
            new BundleSLAChangeXCommand(id, actions, dates, childIds, slaNewParams).call();
        }
        catch (CommandException e) {
            throw new BundleEngineException(e);
        }
    }

    public BundleJobInfo killJobs(String filter, int start, int len) throws BundleEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            BundleJobInfo bundleJobInfo = (BundleJobInfo)new BulkBundleXCommand(filterList, start, len, OperationType.Kill).call();
            if (bundleJobInfo == null) {
                return new BundleJobInfo(new ArrayList<BundleJobBean>(), 0, 0, 0);
            }
            return bundleJobInfo;
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    public BundleJobInfo suspendJobs(String filter, int start, int len) throws BundleEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            BundleJobInfo bundleJobInfo = (BundleJobInfo)new BulkBundleXCommand(filterList, start, len, OperationType.Suspend).call();
            if (bundleJobInfo == null) {
                return new BundleJobInfo(new ArrayList<BundleJobBean>(), 0, 0, 0);
            }
            return bundleJobInfo;
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }

    public BundleJobInfo resumeJobs(String filter, int start, int len) throws BundleEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            BundleJobInfo bundleJobInfo = (BundleJobInfo)new BulkBundleXCommand(filterList, start, len, OperationType.Resume).call();
            if (bundleJobInfo == null) {
                return new BundleJobInfo(new ArrayList<BundleJobBean>(), 0, 0, 0);
            }
            return bundleJobInfo;
        }
        catch (CommandException ex) {
            throw new BundleEngineException(ex);
        }
    }
}

