/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BundleActionQueryExecutor
extends QueryExecutor<BundleActionBean, BundleActionQuery> {
    private static BundleActionQueryExecutor instance = new BundleActionQueryExecutor();

    private BundleActionQueryExecutor() {
    }

    public static QueryExecutor<BundleActionBean, BundleActionQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(BundleActionQuery namedQuery, BundleActionBean baBean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_BUNDLE_ACTION_PENDING_MODTIME: {
                query.setParameter("lastModifiedTime", (Object)baBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)baBean.getPending());
                query.setParameter("bundleActionId", (Object)baBean.getBundleActionId());
                break;
            }
            case UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME: {
                query.setParameter("status", (Object)baBean.getStatusStr());
                query.setParameter("lastModifiedTime", (Object)baBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)baBean.getPending());
                query.setParameter("bundleActionId", (Object)baBean.getBundleActionId());
                break;
            }
            case UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID: {
                query.setParameter("status", (Object)baBean.getStatusStr());
                query.setParameter("lastModifiedTime", (Object)baBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)baBean.getPending());
                query.setParameter("coordId", (Object)baBean.getCoordId());
                query.setParameter("bundleActionId", (Object)baBean.getBundleActionId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(BundleActionQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_BUNDLE_ACTION: {
                query.setParameter("bundleActionId", parameters[0]);
                break;
            }
            case GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE: {
                query.setParameter("bundleId", parameters[0]);
                break;
            }
            case GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN: {
                Timestamp ts = new Timestamp(System.currentTimeMillis() - (Long)parameters[0] * 1000L);
                query.setParameter("lastModifiedTime", (Object)ts);
                break;
            }
            case GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE: {
                query.setParameter("bundleId", parameters[0]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(BundleActionQuery namedQuery, BundleActionBean jobBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public BundleActionBean get(BundleActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null) {
            throw new JPAExecutorException(ErrorCode.E0604, query.toString());
        }
        BundleActionBean bean = this.constructBean(namedQuery, ret);
        return bean;
    }

    private BundleActionBean constructBean(BundleActionQuery namedQuery, Object ret) throws JPAExecutorException {
        BundleActionBean bean;
        switch (namedQuery) {
            case GET_BUNDLE_ACTION: 
            case GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE: {
                bean = (BundleActionBean)ret;
                break;
            }
            case GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN: {
                bean = new BundleActionBean();
                Object[] arr = (Object[])ret;
                bean.setBundleActionId((String)arr[0]);
                bean.setBundleId((String)arr[1]);
                bean.setStatusStr((String)arr[2]);
                bean.setCoordId((String)arr[3]);
                bean.setCoordName((String)arr[4]);
                break;
            }
            case GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE: {
                bean = new BundleActionBean();
                Object[] arr = (Object[])ret;
                bean.setCoordId((String)arr[0]);
                bean.setStatusStr((String)arr[1]);
                bean.setPending((Integer)arr[2]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct action bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    @Override
    public List<BundleActionBean> getList(BundleActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<?> retList = jpaService.executeGetList(namedQuery.name(), query, em);
        ArrayList<BundleActionBean> beanList = new ArrayList<BundleActionBean>();
        if (retList != null) {
            for (Object ret : retList) {
                beanList.add(this.constructBean(namedQuery, ret));
            }
        }
        return beanList;
    }

    @Override
    public Object getSingleValue(BundleActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        throw new UnsupportedOperationException();
    }

    public static enum BundleActionQuery {
        UPDATE_BUNDLE_ACTION_PENDING_MODTIME,
        UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME,
        UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID,
        GET_BUNDLE_ACTION,
        GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE,
        GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN,
        GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE;

    }
}

