/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.AuthUrlClient;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.SimpleTimestampedMessageParser;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.ZKUtils;

public class ZKXLogStreamingService
extends XLogStreamingService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private XLog log;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
        this.log = XLog.getLog(this.getClass());
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        super.instrument(instr);
    }

    @Override
    public void streamLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.getLogOverWS()) {
            if (!Services.get().get(JobsConcurrencyService.class).isAllServerRequest(params)) {
                new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
            } else {
                this.collateLogs(filter, startTime, endTime, writer, params, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation(), "log");
            }
        } else {
            writer.write("Log streaming disabled!!");
        }
    }

    @Override
    public void streamErrorLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.isErrorLogEnabled()) {
            if (!Services.get().get(JobsConcurrencyService.class).isAllServerRequest(params)) {
                new XLogStreamer(filter, xLogService.getOozieErrorLogPath(), xLogService.getOozieErrorLogName(), xLogService.getOozieErrorLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
            } else {
                this.collateLogs(filter, startTime, endTime, writer, params, xLogService.getOozieLogPath(), xLogService.getOozieErrorLogName(), xLogService.getOozieErrorLogRotation(), "errorlog");
            }
        } else {
            writer.write("Error Log streaming disabled!!");
        }
    }

    @Override
    public void streamAuditLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.isAuditLogEnabled()) {
            if (!Services.get().get(JobsConcurrencyService.class).isAllServerRequest(params)) {
                new XLogStreamer(filter, xLogService.getOozieAuditLogPath(), xLogService.getOozieAuditLogName(), xLogService.getOozieAuditLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
            } else {
                this.collateLogs(filter, startTime, endTime, writer, params, xLogService.getOozieAuditLogPath(), xLogService.getOozieAuditLogName(), xLogService.getOozieAuditLogRotation(), "auditlog");
            }
        } else {
            writer.write("Audit Log streaming disabled!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collateLogs(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params, String logPath, String logName, int rotation, String logType) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        ArrayList<String> badOozies = new ArrayList<String>();
        List<ServiceInstance<Map>> oozies = null;
        try {
            oozies = this.zk.getAllMetaData();
        }
        catch (Exception ex) {
            throw new IOException("Issue communicating with ZooKeeper: " + ex.getMessage(), ex);
        }
        ArrayList<TimestampedMessageParser> parsers = new ArrayList<TimestampedMessageParser>(oozies.size());
        try {
            for (ServiceInstance<Map> oozie : oozies) {
                Map oozieMeta = (Map)oozie.getPayload();
                String otherId = (String)oozieMeta.get("OOZIE_ID");
                if (otherId.equals(this.zk.getZKId())) {
                    BufferedReader reader = new XLogStreamer(filter, logPath, logName, rotation).makeReader(startTime, endTime);
                    parsers.add(new TimestampedMessageParser(reader, filter));
                    continue;
                }
                String otherUrl = (String)oozieMeta.get("OOZIE_URL");
                String jobId = filter.getFilterParams().get("JOB");
                try {
                    String url = otherUrl + "/v" + 2L + "/" + "job" + "/" + jobId + "?" + "show" + "=" + logType + "&" + "allservers" + "=false" + AuthUrlClient.getQueryParamString(params);
                    BufferedReader reader = AuthUrlClient.callServer(url);
                    parsers.add(new SimpleTimestampedMessageParser(reader, filter));
                }
                catch (IOException ioe) {
                    this.log.warn((Object)("Failed to retrieve logs for job [" + jobId + "] from Oozie server with ID [" + otherId + "] at [" + otherUrl + "]; log information may be incomplete"), ioe);
                    badOozies.add(otherId);
                }
            }
            if (filter.isDebugMode()) {
                writer.write(filter.getDebugMessage());
            }
            if (!badOozies.isEmpty()) {
                writer.write("Unable to contact the following Oozie Servers for logs (log information may be incomplete):\n");
                for (String badOozie : badOozies) {
                    writer.write("     ");
                    writer.write(badOozie);
                    writer.write("\n");
                }
                writer.write("\n");
                writer.flush();
            }
            if (parsers.size() == 1) {
                TimestampedMessageParser parser = (TimestampedMessageParser)parsers.get(0);
                parser.processRemaining(writer, this.bufferLen);
            } else {
                TreeMap<String, TimestampedMessageParser> timestampMap = new TreeMap<String, TimestampedMessageParser>();
                for (TimestampedMessageParser parser : parsers) {
                    if (!parser.increment()) continue;
                    timestampMap.put(parser.getLastTimestamp(), parser);
                }
                int bytesWritten = 0;
                while (timestampMap.size() > 1) {
                    TimestampedMessageParser earliestParser = (TimestampedMessageParser)timestampMap.pollFirstEntry().getValue();
                    writer.write(earliestParser.getLastMessage());
                    bytesWritten = earliestParser.getLastMessage().length();
                    if (bytesWritten > this.bufferLen) {
                        writer.flush();
                        bytesWritten = 0;
                    }
                    if (!earliestParser.increment()) continue;
                    timestampMap.put(earliestParser.getLastTimestamp(), earliestParser);
                }
                if (timestampMap.size() == 1) {
                    TimestampedMessageParser parser;
                    parser = (TimestampedMessageParser)timestampMap.values().iterator().next();
                    writer.write(parser.getLastMessage());
                    parser.processRemaining(writer, this.bufferLen, bytesWritten + parser.getLastMessage().length());
                }
            }
        }
        finally {
            for (TimestampedMessageParser parser : parsers) {
                parser.closeReader();
            }
            writer.flush();
        }
    }
}

