/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetRecordsOnRestartJPAExecutor;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XLog;

public class SLACalculatorMemory
implements SLACalculator {
    private static XLog LOG = XLog.getLog(SLACalculatorMemory.class);
    protected Map<String, SLACalcStatus> slaMap;
    protected Set<String> historySet;
    private static int capacity;
    private static JPAService jpaService;
    protected EventHandlerService eventHandler;
    private static int modifiedAfter;
    private static long jobEventLatency;

    @Override
    public void init(Configuration conf) throws ServiceException {
        capacity = ConfigurationService.getInt(conf, "oozie.sla.service.SLAService.capacity");
        jobEventLatency = ConfigurationService.getInt(conf, "oozie.sla.service.SLAService.job.event.latency");
        this.slaMap = new ConcurrentHashMap<String, SLACalcStatus>();
        this.historySet = Collections.synchronizedSet(new HashSet());
        jpaService = Services.get().get(JPAService.class);
        this.eventHandler = Services.get().get(EventHandlerService.class);
        modifiedAfter = conf.getInt("oozie.sla.service.SLAService.events.modified.after", 7);
        this.loadOnRestart();
        HistoryPurgeWorker purgeThread = new HistoryPurgeWorker();
        Services.get().get(SchedulerService.class).schedule(purgeThread, 86400L, (long)Services.get().getConf().getInt("oozie.sla.service.SLAService.history.purge.interval", 86400), SchedulerService.Unit.SEC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOnRestart() {
        boolean isJobModified = false;
        try {
            long slaPendingCount = 0L;
            long statusPendingCount = 0L;
            List<SLASummaryBean> summaryBeans = jpaService.execute(new SLASummaryGetRecordsOnRestartJPAExecutor(modifiedAfter));
            for (SLASummaryBean summaryBean : summaryBeans) {
                String jobId = summaryBean.getId();
                LockToken lock = null;
                switch (summaryBean.getAppType()) {
                    case COORDINATOR_ACTION: {
                        isJobModified = this.processSummaryBeanForCoordAction(summaryBean, jobId);
                        break;
                    }
                    case WORKFLOW_ACTION: {
                        isJobModified = this.processSummaryBeanForWorkflowAction(summaryBean, jobId);
                        break;
                    }
                    case WORKFLOW_JOB: {
                        isJobModified = this.processSummaryBeanForWorkflowJob(summaryBean, jobId);
                        break;
                    }
                }
                if (isJobModified) {
                    try {
                        boolean update = true;
                        if (Services.get().get(JobsConcurrencyService.class).isHighlyAvailableMode() && (lock = Services.get().get(MemoryLocksService.class).getWriteLock(SLACalcStatus.SLA_ENTITYKEY_PREFIX + jobId, Services.get().getConf().getLong("oozie.sla.service.SLAService.oozie.sla.calc.default.lock.timeout", 5000L))) == null) {
                            update = false;
                        }
                        if (update) {
                            summaryBean.setLastModifiedTime(new Date());
                            SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, summaryBean);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to load records for " + jobId), e);
                    }
                    finally {
                        if (lock != null) {
                            lock.release();
                            lock = null;
                        }
                    }
                }
                try {
                    if (summaryBean.getEventProcessed() == 7) {
                        this.historySet.add(jobId);
                        ++statusPendingCount;
                        continue;
                    }
                    if (summaryBean.getEventProcessed() > 7) continue;
                    SLARegistrationBean slaRegBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, jobId);
                    SLACalcStatus slaCalcStatus = new SLACalcStatus(summaryBean, slaRegBean);
                    this.slaMap.put(jobId, slaCalcStatus);
                    ++slaPendingCount;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to fetch/update records for " + jobId), e);
                }
            }
            LOG.info("Loaded SLASummary pendingSLA=" + slaPendingCount + ", pendingStatusUpdate=" + statusPendingCount);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to retrieve SLASummary records on restart", e);
        }
    }

    private boolean processSummaryBeanForCoordAction(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        CoordinatorActionBean coordAction = null;
        coordAction = jpaService.execute(new CoordActionGetForSLAJPAExecutor(jobId));
        if (!coordAction.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Coordinator action status is " + coordAction.getStatusStr() + " and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(coordAction.getStatusStr());
            if (coordAction.isTerminalStatus()) {
                WorkflowJobBean wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(coordAction.getExternalId()));
                this.setEndForSLASummaryBean(summaryBean, wfJob.getStartTime(), coordAction.getLastModifiedTime(), coordAction.getStatusStr());
            } else if (coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
                WorkflowJobBean wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(coordAction.getExternalId()));
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfJob.getStartTime());
            }
        }
        return isJobModified;
    }

    private boolean processSummaryBeanForWorkflowAction(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        WorkflowActionBean wfAction = null;
        wfAction = jpaService.execute(new WorkflowActionGetForSLAJPAExecutor(jobId));
        if (!wfAction.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Workflow action status is " + wfAction.getStatusStr() + "and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(wfAction.getStatusStr());
            if (wfAction.inTerminalState()) {
                this.setEndForSLASummaryBean(summaryBean, wfAction.getStartTime(), wfAction.getEndTime(), wfAction.getStatusStr());
            } else if (wfAction.getStatus() != WorkflowAction.Status.PREP) {
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfAction.getStartTime());
            }
        }
        return isJobModified;
    }

    private boolean processSummaryBeanForWorkflowJob(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        WorkflowJobBean wfJob = null;
        wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(jobId));
        if (!wfJob.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Workflow job status is " + wfJob.getStatusStr() + "and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(wfJob.getStatusStr());
            if (wfJob.inTerminalState()) {
                this.setEndForSLASummaryBean(summaryBean, wfJob.getStartTime(), wfJob.getEndTime(), wfJob.getStatusStr());
            } else if (wfJob.getStatus() != WorkflowJob.Status.PREP) {
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfJob.getStartTime());
            }
        }
        return isJobModified;
    }

    private void setEndForSLASummaryBean(SLASummaryBean summaryBean, Date startTime, Date endTime, String status) {
        byte eventProc = summaryBean.getEventProcessed();
        summaryBean.setEventProcessed(8);
        summaryBean.setActualStart(startTime);
        summaryBean.setActualEnd(endTime);
        long actualDuration = endTime.getTime() - startTime.getTime();
        summaryBean.setActualDuration(actualDuration);
        if (eventProc < 4) {
            if (status.equals(WorkflowJob.Status.SUCCEEDED.name()) || status.equals(WorkflowAction.Status.OK.name()) || status.equals(CoordinatorAction.Status.SUCCEEDED.name())) {
                if (endTime.getTime() <= summaryBean.getExpectedEnd().getTime()) {
                    summaryBean.setSLAStatus(SLAEvent.SLAStatus.MET);
                } else {
                    summaryBean.setSLAStatus(SLAEvent.SLAStatus.MISS);
                }
            } else {
                summaryBean.setSLAStatus(SLAEvent.SLAStatus.MISS);
            }
        }
    }

    private void setStartForSLASummaryBean(SLASummaryBean summaryBean, byte eventProc, Date startTime) {
        if ((eventProc & 1) == 0) {
            eventProc = (byte)(eventProc + 1);
            summaryBean.setEventProcessed(eventProc);
        }
        if (summaryBean.getSLAStatus().equals((Object)SLAEvent.SLAStatus.NOT_STARTED)) {
            summaryBean.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        }
        summaryBean.setActualStart(startTime);
    }

    @Override
    public int size() {
        return this.slaMap.size();
    }

    @Override
    public SLACalcStatus get(String jobId) throws JPAExecutorException {
        SLACalcStatus memObj = this.slaMap.get(jobId);
        if (memObj == null && this.historySet.contains(jobId)) {
            memObj = new SLACalcStatus(SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId), SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, jobId));
        }
        return memObj;
    }

    private SLACalcStatus getSLACalcStatus(String jobId) throws JPAExecutorException {
        SLACalcStatus memObj = this.slaMap.get(jobId);
        if (memObj == null) {
            memObj = new SLACalcStatus(SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId), SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, jobId));
        }
        return memObj;
    }

    @Override
    public Iterator<String> iterator() {
        return this.slaMap.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.slaMap.isEmpty();
    }

    @Override
    public void clear() {
        this.slaMap.clear();
        this.historySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJobSla(String jobId) throws Exception {
        SLACalcStatus slaCalc;
        SLACalcStatus sLACalcStatus = slaCalc = this.slaMap.get(jobId);
        synchronized (sLACalcStatus) {
            boolean change = false;
            SLASummaryBean summaryBean = ((SLASummaryQueryExecutor)SLASummaryQueryExecutor.getInstance()).get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED, jobId);
            byte eventProc = summaryBean.getEventProcessed();
            if (eventProc >= 7) {
                if (eventProc == 7) {
                    this.historySet.add(jobId);
                }
                this.slaMap.remove(jobId);
                LOG.trace("Removed Job [{0}] from map as SLA processed", jobId);
            } else {
                if (!slaCalc.getLastModifiedTime().equals(summaryBean.getLastModifiedTime())) {
                    slaCalc.setLastModifiedTime(summaryBean.getLastModifiedTime());
                    this.reloadExpectedTimeAndConfig(slaCalc);
                    LOG.debug("Last modified time has changed for job " + jobId + " reloading config from DB");
                }
                slaCalc.setEventProcessed(eventProc);
                SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
                if ((eventProc & 1) == 0) {
                    if (reg.getExpectedStart() != null) {
                        if (reg.getExpectedStart().getTime() + jobEventLatency < System.currentTimeMillis()) {
                            this.confirmWithDB(slaCalc);
                            eventProc = slaCalc.getEventProcessed();
                            if (eventProc != 8 && (eventProc & 1) == 0) {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                                if (this.shouldAlert(slaCalc)) {
                                    this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                                }
                                eventProc = (byte)(eventProc + 1);
                            }
                            change = true;
                        }
                    } else {
                        eventProc = (byte)(eventProc + 1);
                        change = true;
                    }
                }
                if (eventProc != 8 && (eventProc >> 1 & 1) == 0) {
                    if (reg.getExpectedDuration() == -1L) {
                        eventProc = (byte)(eventProc + 2);
                        change = true;
                    } else if (slaCalc.getActualStart() != null && reg.getExpectedDuration() + jobEventLatency < System.currentTimeMillis() - slaCalc.getActualStart().getTime()) {
                        slaCalc.setEventProcessed(eventProc);
                        this.confirmWithDB(slaCalc);
                        eventProc = slaCalc.getEventProcessed();
                        if (eventProc != 8 && (eventProc >> 1 & 1) == 0) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                            if (this.shouldAlert(slaCalc)) {
                                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            }
                            eventProc = (byte)(eventProc + 2);
                        }
                        change = true;
                    }
                }
                if (eventProc < 4 && reg.getExpectedEnd().getTime() + jobEventLatency < System.currentTimeMillis()) {
                    slaCalc.setEventProcessed(eventProc);
                    this.confirmWithDB(slaCalc);
                    eventProc = slaCalc.getEventProcessed();
                    change = true;
                }
                if (change) {
                    try {
                        boolean locked = true;
                        slaCalc.acquireLock();
                        locked = slaCalc.isLocked();
                        if (locked) {
                            if (slaCalc.getEventProcessed() >= 8) {
                                eventProc = 8;
                                slaCalc.setEventProcessed(8);
                                this.slaMap.remove(jobId);
                                LOG.trace("Removed Job [{0}] from map after Event-processed=8", jobId);
                            } else {
                                slaCalc.setEventProcessed(eventProc);
                            }
                            this.writetoDB(slaCalc, eventProc);
                            if (eventProc == 7) {
                                this.historySet.add(jobId);
                                this.slaMap.remove(jobId);
                                LOG.trace("Removed Job [{0}] from map after Event-processed=7", jobId);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw new XException(ErrorCode.E0606, slaCalc.getId(), slaCalc.getLockTimeOut());
                    }
                    finally {
                        slaCalc.releaseLock();
                    }
                }
            }
        }
    }

    private void writetoDB(SLACalcStatus slaCalc, byte eventProc) throws JPAExecutorException {
        SLASummaryBean slaSummaryBean = new SLASummaryBean();
        slaSummaryBean.setId(slaCalc.getId());
        slaSummaryBean.setEventProcessed(eventProc);
        slaSummaryBean.setSLAStatus(slaCalc.getSLAStatus());
        slaSummaryBean.setEventStatus(slaCalc.getEventStatus());
        slaSummaryBean.setActualEnd(slaCalc.getActualEnd());
        slaSummaryBean.setActualStart(slaCalc.getActualStart());
        slaSummaryBean.setActualDuration(slaCalc.getActualDuration());
        slaSummaryBean.setJobStatus(slaCalc.getJobStatus());
        slaSummaryBean.setLastModifiedTime(new Date());
        SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, slaSummaryBean);
        LOG.trace("Stored SLA SummaryBean Job [{0}] with Event-processed=[{1}]", slaCalc.getId(), slaSummaryBean.getEventProcessed());
    }

    private void updateDBSlaConfig(SLACalcStatus slaCalc, List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_CONFIG, slaCalc.getSLARegistrationBean()));
        slaCalc.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_LAST_MODIFIED_TIME, new SLASummaryBean(slaCalc)));
    }

    private void updateDBSlaExpectedValues(SLACalcStatus slaCalc, List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        slaCalc.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_EXPECTED_VALUE, slaCalc.getSLARegistrationBean()));
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES, new SLASummaryBean(slaCalc)));
    }

    private void executeBatchQuery(List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, updateList, null);
    }

    @Override
    public void updateAllSlaStatus() {
        LOG.info("Running periodic SLA check");
        for (String jobId : this.slaMap.keySet()) {
            try {
                LOG.trace("Processing SLA for jobid={0}", jobId);
                this.updateJobSla(jobId);
            }
            catch (Exception e) {
                this.setLogPrefix(jobId);
                LOG.error("Exception in SLA processing for job [{0}]", jobId, e);
                LogUtils.clearLogPrefix();
            }
        }
    }

    @Override
    public boolean addRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (this.slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            this.slaMap.put(jobId, slaCalc);
            ArrayList<JsonBean> insertList = new ArrayList<JsonBean>();
            SLASummaryBean summaryBean = new SLASummaryBean(slaCalc);
            Timestamp currentTime = DateUtils.convertDateToTimestamp(new Date());
            reg.setCreatedTimestamp(currentTime);
            summaryBean.setCreatedTimestamp(currentTime);
            insertList.add(reg);
            insertList.add(summaryBean);
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        this.setLogPrefix(reg.getId());
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        LogUtils.clearLogPrefix();
        return false;
    }

    private String getJobStatus(AppType appType) {
        String status = null;
        switch (appType) {
            case COORDINATOR_ACTION: {
                status = CoordinatorAction.Status.WAITING.name();
                break;
            }
            case WORKFLOW_ACTION: {
                status = WorkflowAction.Status.PREP.name();
                break;
            }
            case WORKFLOW_JOB: {
                status = WorkflowJob.Status.PREP.name();
                break;
            }
        }
        return status;
    }

    @Override
    public boolean updateRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (this.slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            this.slaMap.put(jobId, slaCalc);
            ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
            updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_REG_ALL, reg));
            updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, new SLASummaryBean(slaCalc)));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, updateList, null);
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        this.setLogPrefix(reg.getId());
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        LogUtils.clearLogPrefix();
        return false;
    }

    @Override
    public void removeRegistration(String jobId) {
        if (this.slaMap.remove(jobId) == null) {
            this.historySet.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJobStatus(String jobId, String jobStatus, JobEvent.EventStatus jobEventStatus, Date startTime, Date endTime) throws JPAExecutorException, ServiceException {
        SLACalcStatus slaCalc = this.slaMap.get(jobId);
        SLASummaryBean slaInfo = null;
        boolean hasSla = false;
        if (slaCalc == null) {
            SLASummaryBean slaSummaryBean;
            SLARegistrationBean slaRegBean;
            if (this.historySet.contains(jobId)) {
                slaInfo = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId);
                if (slaInfo == null) {
                    throw new JPAExecutorException(ErrorCode.E0604, jobId);
                }
                slaInfo.setJobStatus(jobStatus);
                slaInfo.setActualStart(startTime);
                slaInfo.setActualEnd(endTime);
                if (endTime != null) {
                    slaInfo.setActualDuration(endTime.getTime() - startTime.getTime());
                }
                slaInfo.setEventProcessed(8);
                this.historySet.remove(jobId);
                slaInfo.setLastModifiedTime(new Date());
                SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, slaInfo);
                hasSla = true;
            } else if (Services.get().get(JobsConcurrencyService.class).isHighlyAvailableMode() && (slaRegBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, jobId)) != null && (slaSummaryBean = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId)).getEventProcessed() < 7) {
                slaCalc = new SLACalcStatus(slaSummaryBean, slaRegBean);
                this.slaMap.put(jobId, slaCalc);
            }
        }
        if (slaCalc != null) {
            SLACalcStatus sLACalcStatus = slaCalc;
            synchronized (sLACalcStatus) {
                try {
                    boolean locked = true;
                    slaCalc.acquireLock();
                    locked = slaCalc.isLocked();
                    if (locked) {
                        SLASummaryBean summaryBean = ((SLASummaryQueryExecutor)SLASummaryQueryExecutor.getInstance()).get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED, jobId);
                        byte eventProc = summaryBean.getEventProcessed();
                        if (!slaCalc.getLastModifiedTime().equals(summaryBean.getLastModifiedTime())) {
                            slaCalc.setLastModifiedTime(summaryBean.getLastModifiedTime());
                            this.reloadExpectedTimeAndConfig(slaCalc);
                            LOG.debug("Last modified time has changed for job " + jobId + " reloading config from DB");
                        }
                        slaCalc.setEventProcessed(eventProc);
                        slaCalc.setJobStatus(jobStatus);
                        switch (jobEventStatus) {
                            case STARTED: {
                                slaInfo = this.processJobStartSLA(slaCalc, startTime);
                                break;
                            }
                            case SUCCESS: {
                                slaInfo = this.processJobEndSuccessSLA(slaCalc, startTime, endTime);
                                break;
                            }
                            case FAILURE: {
                                slaInfo = this.processJobEndFailureSLA(slaCalc, startTime, endTime);
                                break;
                            }
                            default: {
                                LOG.debug("Unknown Job Status for SLA purpose[{0}]", jobEventStatus);
                                slaInfo = this.getSLASummaryBean(slaCalc);
                            }
                        }
                        if (slaCalc.getEventProcessed() == 7) {
                            slaInfo.setEventProcessed(8);
                            this.slaMap.remove(jobId);
                        }
                        slaInfo.setLastModifiedTime(new Date());
                        SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, slaInfo);
                        hasSla = true;
                    }
                }
                catch (InterruptedException e) {
                    throw new ServiceException(ErrorCode.E0606, slaCalc.getEntityKey(), slaCalc.getLockTimeOut());
                }
                finally {
                    slaCalc.releaseLock();
                }
            }
            LOG.trace("SLA Status Event - Job:" + jobId + " Status:" + slaCalc.getSLAStatus());
        }
        return hasSla;
    }

    private SLASummaryBean processJobStartSLA(SLACalcStatus slaCalc, Date actualStart) {
        slaCalc.setActualStart(actualStart);
        if (slaCalc.getSLAStatus().equals((Object)SLAEvent.SLAStatus.NOT_STARTED)) {
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        }
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        Date expecStart = reg.getExpectedStart();
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc & 1) == 0) {
            if (expecStart != null) {
                if (actualStart.getTime() > expecStart.getTime()) {
                    slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                } else {
                    slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                }
                if (this.shouldAlert(slaCalc)) {
                    this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                }
            }
            eventProc = (byte)(eventProc + 1);
            slaCalc.setEventProcessed(eventProc);
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean processJobEndSuccessSLA(SLACalcStatus slaCalc, Date actualStart, Date actualEnd) throws JPAExecutorException {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        slaCalc.setActualStart(actualStart);
        slaCalc.setActualEnd(actualEnd);
        long expectedDuration = reg.getExpectedDuration();
        long actualDuration = actualEnd.getTime() - actualStart.getTime();
        slaCalc.setActualDuration(actualDuration);
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc >> 1 & 1) == 0) {
            this.processDurationSLA(expectedDuration, actualDuration, slaCalc);
            eventProc = (byte)(eventProc + 2);
            slaCalc.setEventProcessed(eventProc);
        }
        if (eventProc < 4) {
            Date expectedEnd = reg.getExpectedEnd();
            if (actualEnd.getTime() > expectedEnd.getTime()) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            } else {
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MET);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MET);
            }
            eventProc = (byte)(eventProc + 4);
            slaCalc.setEventProcessed(eventProc);
            if (this.shouldAlert(slaCalc)) {
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean processJobEndFailureSLA(SLACalcStatus slaCalc, Date actualStart, Date actualEnd) throws JPAExecutorException {
        slaCalc.setActualStart(actualStart);
        slaCalc.setActualEnd(actualEnd);
        if (actualStart == null && slaCalc.getEventProcessed() < 4) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            if (this.shouldAlert(slaCalc)) {
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
            slaCalc.setEventProcessed(7);
            return this.getSLASummaryBean(slaCalc);
        }
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        long expectedDuration = reg.getExpectedDuration();
        long actualDuration = actualEnd.getTime() - actualStart.getTime();
        slaCalc.setActualDuration(actualDuration);
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc >> 1 & 1) == 0) {
            if (expectedDuration != -1L) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                if (this.shouldAlert(slaCalc)) {
                    this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                }
            }
            eventProc = (byte)(eventProc + 2);
            slaCalc.setEventProcessed(eventProc);
        }
        if (eventProc < 4) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            eventProc = (byte)(eventProc + 4);
            slaCalc.setEventProcessed(eventProc);
            if (this.shouldAlert(slaCalc)) {
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean getSLASummaryBean(SLACalcStatus slaCalc) {
        SLASummaryBean slaSummaryBean = new SLASummaryBean();
        slaSummaryBean.setActualStart(slaCalc.getActualStart());
        slaSummaryBean.setActualEnd(slaCalc.getActualEnd());
        slaSummaryBean.setActualDuration(slaCalc.getActualDuration());
        slaSummaryBean.setSLAStatus(slaCalc.getSLAStatus());
        slaSummaryBean.setEventStatus(slaCalc.getEventStatus());
        slaSummaryBean.setEventProcessed(slaCalc.getEventProcessed());
        slaSummaryBean.setId(slaCalc.getId());
        slaSummaryBean.setJobStatus(slaCalc.getJobStatus());
        return slaSummaryBean;
    }

    private void processDurationSLA(long expected, long actual, SLACalcStatus slaCalc) {
        if (expected != -1L) {
            if (actual > expected) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
            } else if (actual <= expected) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MET);
            }
            if (this.shouldAlert(slaCalc)) {
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
        }
    }

    private void confirmWithDB(SLACalcStatus slaCalc) {
        block43: {
            boolean ended = false;
            boolean isEndMiss = false;
            try {
                switch (slaCalc.getAppType()) {
                    case WORKFLOW_JOB: {
                        WorkflowJobBean wf = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(slaCalc.getId()));
                        if (wf.getEndTime() != null) {
                            ended = true;
                            if (wf.getStatus() == WorkflowJob.Status.KILLED || wf.getStatus() == WorkflowJob.Status.FAILED || wf.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                isEndMiss = true;
                            }
                        }
                        slaCalc.setActualStart(wf.getStartTime());
                        slaCalc.setActualEnd(wf.getEndTime());
                        slaCalc.setJobStatus(wf.getStatusStr());
                        break;
                    }
                    case WORKFLOW_ACTION: {
                        WorkflowActionBean wa = jpaService.execute(new WorkflowActionGetForSLAJPAExecutor(slaCalc.getId()));
                        if (wa.getEndTime() != null) {
                            ended = true;
                            if (wa.isTerminalWithFailure() || wa.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                isEndMiss = true;
                            }
                        }
                        slaCalc.setActualStart(wa.getStartTime());
                        slaCalc.setActualEnd(wa.getEndTime());
                        slaCalc.setJobStatus(wa.getStatusStr());
                        break;
                    }
                    case COORDINATOR_ACTION: {
                        WorkflowJobBean wf;
                        CoordinatorActionBean ca = jpaService.execute(new CoordActionGetForSLAJPAExecutor(slaCalc.getId()));
                        if (ca.isTerminalWithFailure()) {
                            ended = true;
                            isEndMiss = true;
                            slaCalc.setActualEnd(ca.getLastModifiedTime());
                        }
                        if (ca.getExternalId() != null) {
                            wf = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(ca.getExternalId()));
                            if (wf.getEndTime() != null) {
                                ended = true;
                                if (wf.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                    isEndMiss = true;
                                }
                            }
                            slaCalc.setActualEnd(wf.getEndTime());
                            slaCalc.setActualStart(wf.getStartTime());
                        }
                        slaCalc.setJobStatus(ca.getStatusStr());
                        break;
                    }
                    default: {
                        LOG.debug("Unsupported App-type for SLA - " + slaCalc.getAppType());
                    }
                }
                byte eventProc = slaCalc.getEventProcessed();
                if (ended) {
                    if (isEndMiss) {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                    } else {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MET);
                    }
                    if (slaCalc.getActualStart() != null) {
                        if ((eventProc & 1) == 0) {
                            if (slaCalc.getExpectedStart().getTime() < slaCalc.getActualStart().getTime()) {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            } else {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                            }
                            if (this.shouldAlert(slaCalc)) {
                                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            }
                        }
                        slaCalc.setActualDuration(slaCalc.getActualEnd().getTime() - slaCalc.getActualStart().getTime());
                        if ((eventProc >> 1 & 1) == 0) {
                            this.processDurationSLA(slaCalc.getExpectedDuration(), slaCalc.getActualDuration(), slaCalc);
                        }
                    }
                    if (eventProc < 4) {
                        if (isEndMiss) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                        } else {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MET);
                        }
                        if (this.shouldAlert(slaCalc)) {
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        }
                    }
                    slaCalc.setEventProcessed(8);
                } else {
                    if (slaCalc.getActualStart() != null) {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
                    }
                    if ((eventProc & 1) == 0) {
                        if (slaCalc.getActualStart() != null) {
                            if (slaCalc.getExpectedStart().getTime() < slaCalc.getActualStart().getTime()) {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            } else {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                            }
                            if (this.shouldAlert(slaCalc)) {
                                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            }
                            eventProc = (byte)(eventProc + 1);
                        } else if (slaCalc.getExpectedStart().getTime() < System.currentTimeMillis()) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            if (this.shouldAlert(slaCalc)) {
                                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            }
                            eventProc = (byte)(eventProc + 1);
                        }
                    }
                    if ((eventProc >> 1 & 1) == 0 && slaCalc.getActualStart() != null && slaCalc.getExpectedDuration() != -1L && System.currentTimeMillis() - slaCalc.getActualStart().getTime() > slaCalc.getExpectedDuration()) {
                        slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                        if (this.shouldAlert(slaCalc)) {
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        }
                        eventProc = (byte)(eventProc + 2);
                    }
                    if (eventProc < 4 && slaCalc.getExpectedEnd().getTime() < System.currentTimeMillis()) {
                        slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                        if (this.shouldAlert(slaCalc)) {
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        }
                        eventProc = (byte)(eventProc + 4);
                    }
                    slaCalc.setEventProcessed(eventProc);
                }
            }
            catch (Exception e) {
                LOG.warn("Error while confirming SLA against DB for jobid= " + slaCalc.getId() + ". Exception is " + e.getClass().getName() + ": " + e.getMessage());
                if (slaCalc.getEventProcessed() >= 4 || slaCalc.getExpectedEnd().getTime() >= System.currentTimeMillis()) break block43;
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                if (this.shouldAlert(slaCalc)) {
                    this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                }
                slaCalc.setEventProcessed(slaCalc.getEventProcessed() + 4);
            }
        }
    }

    public void reloadExpectedTimeAndConfig(SLACalcStatus slaCalc) throws JPAExecutorException {
        SLARegistrationBean regBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_EXPECTED_VALUE_CONFIG, slaCalc.getId());
        if (regBean.getExpectedDuration() > 0L) {
            slaCalc.getSLARegistrationBean().setExpectedDuration(regBean.getExpectedDuration());
        }
        if (regBean.getExpectedEnd() != null) {
            slaCalc.getSLARegistrationBean().setExpectedEnd(regBean.getExpectedEnd());
        }
        if (regBean.getExpectedStart() != null) {
            slaCalc.getSLARegistrationBean().setExpectedStart(regBean.getExpectedStart());
        }
        if (regBean.getSLAConfigMap().containsKey("oozie.sla.disable.alerts")) {
            slaCalc.getSLARegistrationBean().addToSLAConfigMap("oozie.sla.disable.alerts", regBean.getSLAConfigMap().get("oozie.sla.disable.alerts"));
        }
        if (regBean.getNominalTime() != null) {
            slaCalc.getSLARegistrationBean().setNominalTime(regBean.getNominalTime());
        }
    }

    @VisibleForTesting
    public boolean isJobIdInSLAMap(String jobId) {
        return this.slaMap.containsKey(jobId);
    }

    @VisibleForTesting
    public boolean isJobIdInHistorySet(String jobId) {
        return this.historySet.contains(jobId);
    }

    private void setLogPrefix(String jobId) {
        LOG = LogUtils.setLogInfo(LOG, jobId, null, null);
    }

    @Override
    public boolean enableAlert(List<String> jobIds) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (String jobId : jobIds) {
            SLACalcStatus slaCalc = this.getSLACalcStatus(jobId);
            if (slaCalc == null) continue;
            slaCalc.getSLARegistrationBean().removeFromSLAConfigMap("oozie.sla.disable.alerts");
            this.updateDBSlaConfig(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    @Override
    public boolean enableChildJobAlert(List<String> parentJobIds) throws JPAExecutorException, ServiceException {
        return this.enableAlert(this.getSLAJobsforParents(parentJobIds));
    }

    @Override
    public boolean disableAlert(List<String> jobIds) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (String jobId : jobIds) {
            SLACalcStatus slaCalc = this.getSLACalcStatus(jobId);
            if (slaCalc == null) continue;
            slaCalc.getSLARegistrationBean().addToSLAConfigMap("oozie.sla.disable.alerts", Boolean.toString(true));
            this.updateDBSlaConfig(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    @Override
    public boolean disableChildJobAlert(List<String> parentJobIds) throws JPAExecutorException, ServiceException {
        return this.disableAlert(this.getSLAJobsforParents(parentJobIds));
    }

    @Override
    public boolean changeDefinition(List<Pair<String, Map<String, String>>> jobIdsSLAPair) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (Pair<String, Map<String, String>> jobIdSLAPair : jobIdsSLAPair) {
            SLACalcStatus slaCalc = this.getSLACalcStatus(jobIdSLAPair.getFist());
            if (slaCalc == null) continue;
            this.updateParams(slaCalc, jobIdSLAPair.getSecond());
            this.updateDBSlaExpectedValues(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    private void updateParams(SLACalcStatus slaCalc, Map<String, String> newParams) throws ServiceException {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        if (newParams != null) {
            try {
                Date newNominal = SLAOperations.setNominalTime(newParams.get("sla-nominal-time"), reg);
                SLAOperations.setExpectedStart(newParams.get("sla-should-start"), newNominal, reg);
                SLAOperations.setExpectedEnd(newParams.get("sla-should-end"), newNominal, reg);
                SLAOperations.setExpectedDuration(newParams.get("sla-max-duration"), reg);
            }
            catch (CommandException ce) {
                throw new ServiceException(ce);
            }
        }
    }

    private boolean shouldAlert(SLACalcStatus slaObj) {
        return !slaObj.getSLAConfigMap().containsKey("oozie.sla.disable.alerts");
    }

    private List<String> getSLAJobsforParents(List<String> parentJobIds) throws JPAExecutorException {
        ArrayList<String> childJobIds = new ArrayList<String>();
        for (String jobId : parentJobIds) {
            List<SLARegistrationBean> registrationBeanList = SLARegistrationQueryExecutor.getInstance().getList(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_FOR_PARENT_ID, jobId);
            for (SLARegistrationBean bean : registrationBeanList) {
                childJobIds.add(bean.getId());
            }
        }
        return childJobIds;
    }

    public class HistoryPurgeWorker
    implements Runnable {
        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Iterator<String> jobItr = SLACalculatorMemory.this.historySet.iterator();
            while (jobItr.hasNext()) {
                String jobId = jobItr.next();
                if (jobId.endsWith("-W")) {
                    WorkflowJobBean wfJob = null;
                    try {
                        wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, jobId);
                    }
                    catch (JPAExecutorException e) {
                        if (e.getErrorCode().equals((Object)ErrorCode.E0604)) {
                            jobItr.remove();
                        }
                        LOG.info((Object)("Failed to fetch the workflow job: " + jobId), e);
                    }
                    if (wfJob == null || !wfJob.inTerminalState()) continue;
                    try {
                        this.updateSLASummary(wfJob.getId(), wfJob.getStartTime(), wfJob.getEndTime());
                        jobItr.remove();
                    }
                    catch (JPAExecutorException e) {
                        LOG.info((Object)("Failed to update SLASummaryBean when purging history set entry for " + jobId), e);
                    }
                    continue;
                }
                if (jobId.contains("-W@")) {
                    WorkflowActionBean wfAction = null;
                    try {
                        wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_COMPLETED, jobId);
                    }
                    catch (JPAExecutorException e) {
                        if (e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                            jobItr.remove();
                        }
                        LOG.info((Object)("Failed to fetch the workflow action: " + jobId), e);
                    }
                    if (wfAction == null || !wfAction.isComplete() && !wfAction.isTerminalWithFailure()) continue;
                    try {
                        this.updateSLASummary(wfAction.getId(), wfAction.getStartTime(), wfAction.getEndTime());
                        jobItr.remove();
                    }
                    catch (JPAExecutorException e) {
                        LOG.info((Object)("Failed to update SLASummaryBean when purging history set entry for " + jobId), e);
                    }
                    continue;
                }
                if (jobId.contains("-C@")) {
                    CoordinatorActionBean cAction = null;
                    try {
                        cAction = CoordActionQueryExecutor.getInstance().get(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, jobId);
                    }
                    catch (JPAExecutorException e) {
                        if (e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                            jobItr.remove();
                        }
                        LOG.info((Object)("Failed to fetch the coord action: " + jobId), e);
                    }
                    if (cAction == null || !cAction.isTerminalStatus()) continue;
                    try {
                        this.updateSLASummaryForCoordAction(cAction);
                        jobItr.remove();
                    }
                    catch (JPAExecutorException e) {
                        XLog.getLog(SLACalculatorMemory.class).info((Object)("Failed to update SLASummaryBean when purging history set entry for " + jobId), e);
                    }
                    continue;
                }
                if (!jobId.endsWith("-C")) continue;
                CoordinatorJobBean cJob = null;
                try {
                    cJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_STATUS_PARENTID, jobId);
                }
                catch (JPAExecutorException e) {
                    if (e.getErrorCode().equals((Object)ErrorCode.E0604)) {
                        jobItr.remove();
                    }
                    LOG.info((Object)("Failed to fetch the coord job: " + jobId), e);
                }
                if (cJob == null || !cJob.isTerminalStatus()) continue;
                try {
                    this.updateSLASummary(cJob.getId(), cJob.getStartTime(), cJob.getEndTime());
                    jobItr.remove();
                }
                catch (JPAExecutorException e) {
                    LOG.info((Object)("Failed to update SLASummaryBean when purging history set entry for " + jobId), e);
                }
            }
        }

        private void updateSLASummary(String id, Date startTime, Date endTime) throws JPAExecutorException {
            SLASummaryBean sla = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, id);
            if (sla != null) {
                sla.setActualStart(startTime);
                sla.setActualEnd(endTime);
                if (startTime != null && endTime != null) {
                    sla.setActualDuration(endTime.getTime() - startTime.getTime());
                }
                sla.setLastModifiedTime(new Date());
                sla.setEventProcessed(8);
                SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_ACTUAL_TIMES, sla);
            }
        }

        private void updateSLASummaryForCoordAction(CoordinatorActionBean bean) throws JPAExecutorException {
            WorkflowJobBean wrkflow;
            String wrkflowId = bean.getExternalId();
            if (wrkflowId != null && (wrkflow = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_START_END_TIME, wrkflowId)) != null) {
                this.updateSLASummary(bean.getId(), wrkflow.getStartTime(), wrkflow.getEndTime());
            }
        }
    }
}

