/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class GetPreviewTableProgressDialog {
    private static Class<?> PKG = GetPreviewTableProgressDialog.class;
    private Shell shell;
    private DatabaseMeta dbMeta;
    private String tableName;
    private int limit;
    private List<Object[]> rows;
    private RowMetaInterface rowMeta;
    private Database db;

    public GetPreviewTableProgressDialog(Shell shell, DatabaseMeta dbInfo, String schemaName, String tableName, int limit) {
        this.shell = shell;
        this.dbMeta = dbInfo;
        this.tableName = dbInfo.getQuotedSchemaTableCombination(schemaName, tableName);
        this.limit = limit;
    }

    public List<Object[]> open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                GetPreviewTableProgressDialog.this.db = new Database(Spoon.loggingObject, GetPreviewTableProgressDialog.this.dbMeta);
                try {
                    GetPreviewTableProgressDialog.this.db.connect();
                    if (GetPreviewTableProgressDialog.this.limit > 0) {
                        GetPreviewTableProgressDialog.this.db.setQueryLimit(GetPreviewTableProgressDialog.this.limit);
                    }
                    GetPreviewTableProgressDialog.this.rows = GetPreviewTableProgressDialog.this.db.getFirstRows(GetPreviewTableProgressDialog.this.tableName, GetPreviewTableProgressDialog.this.limit, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                    GetPreviewTableProgressDialog.this.rowMeta = GetPreviewTableProgressDialog.this.db.getReturnRowMeta();
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, "Couldn't find any rows because of an error :" + e.toString());
                }
                finally {
                    GetPreviewTableProgressDialog.this.db.disconnect();
                }
            }
        };
        try {
            final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            GetPreviewTableProgressDialog.this.db.cancelQuery();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.rows;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetPreviewTableProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetPreviewTableProgressDialog.Error.Message", (String[])new String[0]), e);
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }
}

